/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class ConvTableWriter
extends OutputStreamWriter {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private BufferedOutputStream os_ = null;
    private int ccsid_ = -1;
    private ConvTable table_ = null;
    private BidiConversionProperties properties_ = new BidiConversionProperties();
    private boolean isMixedByte_ = false;
    private char[] cache_ = new char[1024];
    private boolean isCachedByte_ = false;
    private byte cachedByte_ = 0;
    private int nextWrite_ = 0;

    public ConvTableWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        super(outputStream);
        this.os_ = new BufferedOutputStream(outputStream);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.os_ = new BufferedOutputStream(outputStream);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream outputStream, int n) throws UnsupportedEncodingException {
        super(outputStream);
        if (n < 0 || n > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.os_ = new BufferedOutputStream(outputStream);
        this.ccsid_ = n;
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream outputStream, int n, int n2) throws UnsupportedEncodingException {
        this(outputStream, n, new BidiConversionProperties(n2));
    }

    public ConvTableWriter(OutputStream outputStream, int n, BidiConversionProperties bidiConversionProperties) throws UnsupportedEncodingException {
        super(outputStream);
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.os_ = new BufferedOutputStream(outputStream);
        this.ccsid_ = n;
        this.properties_ = bidiConversionProperties;
        this.initializeTable();
    }

    public ConvTableWriter(OutputStream outputStream, int n, int n2, int n3) throws UnsupportedEncodingException {
        this(outputStream, n, n2);
        if (n3 < 1) {
            throw new ExtendedIllegalArgumentException("cacheSize", 4);
        }
        this.cache_ = new char[n3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            if (this.nextWrite_ == this.cache_.length) {
                this.flush();
            }
            this.cache_[this.nextWrite_++] = c;
            if (Trace.traceOn_) {
                Trace.log(5, "Added to ConvTableWriter(" + this.toString() + ") cache: " + c + "," + this.nextWrite_ + "," + this.cache_.length, ConvTable.dumpCharArray(this.cache_, this.nextWrite_));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(char[] cArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int n3;
            this.checkOpen();
            int n4 = n2 / this.cache_.length;
            for (n3 = 0; n3 < n4; ++n3) {
                this.flush();
                System.arraycopy(cArray, n + n3 * this.cache_.length, this.cache_, 0, this.cache_.length);
                this.nextWrite_ = this.cache_.length;
            }
            n3 = n2 % this.cache_.length;
            this.flush();
            System.arraycopy(cArray, n + n4 * this.cache_.length, this.cache_, 0, n3);
            this.nextWrite_ = n3;
            if (Trace.traceOn_) {
                Trace.log(5, "Added to ConvTableWriter(" + this.toString() + ") cache: " + n + "," + n2 + "," + this.nextWrite_ + "," + this.cache_.length, ConvTable.dumpCharArray(this.cache_, this.nextWrite_));
            }
        }
    }

    private void checkOpen() throws IOException {
        if (this.table_ == null) {
            super.flush();
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.table_ == null) {
                return;
            }
            this.flush();
            if (this.isCachedByte_) {
                this.os_.write(this.cachedByte_);
                this.os_.flush();
            }
            this.table_ = null;
            this.cache_ = null;
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (Trace.traceOn_) {
                Trace.log(5, "Flushing cache for ConvTableWriter(" + this.toString() + ") with size " + this.nextWrite_ + ".");
            }
            if (this.nextWrite_ > 0 && this.table_ != null) {
                String string = new String(this.cache_, 0, this.nextWrite_);
                this.nextWrite_ = 0;
                byte[] byArray = this.table_.stringToByteArray(string, this.properties_);
                if (this.isMixedByte_) {
                    if (this.cachedByte_ == 15 && byArray[0] == 14) {
                        this.os_.write(byArray, 1, byArray.length - 2);
                        this.cachedByte_ = byArray[byArray.length - 1];
                        this.isCachedByte_ = true;
                    } else {
                        if (this.isCachedByte_) {
                            this.os_.write(this.cachedByte_);
                        }
                        this.os_.write(byArray, 0, byArray.length - 1);
                        this.cachedByte_ = byArray[byArray.length - 1];
                        this.isCachedByte_ = true;
                    }
                } else {
                    this.os_.write(byArray);
                }
                this.os_.flush();
            }
            super.flush();
        }
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    @Override
    public String getEncoding() {
        if (this.ccsid_ == -1) {
            return super.getEncoding();
        }
        return ConversionMaps.ccsidToEncoding(this.ccsid_);
    }

    private void initializeCcsid() {
        String string;
        String string2 = super.getEncoding();
        if (string2 != null && (string = ConversionMaps.encodingToCcsidString(string2)) != null) {
            this.ccsid_ = Integer.parseInt(string);
        }
    }

    private void initializeTable() throws UnsupportedEncodingException {
        try {
            this.table_ = this.ccsid_ == -1 ? ConvTable.getTable(this.getEncoding()) : ConvTable.getTable(this.ccsid_, null);
            if (this.table_ instanceof ConvTableMixedMap) {
                this.isMixedByte_ = true;
            }
            if (Trace.traceOn_) {
                Trace.log(5, "ConvTableWriter initialized with CCSID " + this.ccsid_ + ", encoding " + this.getEncoding() + ", string type " + this.properties_.getBidiStringType() + ", and table type " + this.isMixedByte_ + ".");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.traceOn_) {
                Trace.log(2, "The specified CCSID is not supported in the current JVM nor by the Toolbox: " + this.ccsid_ + "/" + this.getEncoding(), (Throwable)unsupportedEncodingException);
            }
            throw unsupportedEncodingException;
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.addToCache((char)n);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        if (cArray == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        this.addToCache(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= cArray.length) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", n);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (n2 < 0 || n2 > cArray.length) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        this.addToCache(cArray, n, n2);
    }

    @Override
    public void write(String string) throws IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        this.addToCache(string.toCharArray(), 0, string.toCharArray().length);
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'data' is null.");
            throw new NullPointerException("data");
        }
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= string.length()) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", n);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (n2 < 0 || n2 > string.length()) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        this.addToCache(string.toCharArray(), n, n2);
    }
}

