/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Reader;

final class CoverLetterReader
extends Reader {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final RecordFormat coverLetterRF_ = new RecordFormat("QAPZCOVER");
    private final SequentialFile file_ = new SequentialFile();
    private String currentLine_;
    private int currentOffset_;
    private ConvTable table_;

    CoverLetterReader(AS400 aS400, String string, int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super(coverLetterRF_);
        try {
            this.file_.setSystem(aS400);
            this.file_.setPath(string);
            this.file_.setRecordFormat(coverLetterRF_);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.table_ = ConvTable.getTable(n, null);
        this.file_.open(0, 10, 3);
        this.readRecord();
    }

    protected void finalize() {
        try {
            this.file_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentLine_ == null) {
                    return -1;
                }
                if (this.currentOffset_ >= this.currentLine_.length()) {
                    this.readRecord();
                }
                return this.currentLine_.charAt(this.currentOffset_++);
            }
        }
        catch (AS400Exception aS400Exception) {
            this.handleException(aS400Exception);
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.handleException(aS400SecurityException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.handleException(errorCompletingRequestException);
        }
        catch (InterruptedException interruptedException) {
            this.handleException(interruptedException);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.handleException(objectDoesNotExistException);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                int n;
                int n2;
                if (this.currentLine_ == null) {
                    return -1;
                }
                for (n = 0; this.currentLine_ != null && n < cArray.length; n += n2) {
                    char[] cArray2 = this.currentLine_.toCharArray();
                    n2 = cArray2.length - this.currentOffset_;
                    if (n2 > cArray.length) {
                        n2 = cArray.length;
                    }
                    System.arraycopy(cArray2, this.currentOffset_, cArray, n, n2);
                    this.currentOffset_ += n2;
                    if (this.currentOffset_ < this.currentLine_.length()) continue;
                    this.readRecord();
                }
                return n;
            }
        }
        catch (AS400Exception aS400Exception) {
            this.handleException(aS400Exception);
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.handleException(aS400SecurityException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.handleException(errorCompletingRequestException);
        }
        catch (InterruptedException interruptedException) {
            this.handleException(interruptedException);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.handleException(objectDoesNotExistException);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentLine_ == null) {
                    return -1;
                }
                boolean bl = false;
                int n3 = n;
                while (this.currentLine_ != null && n3 < n + n2) {
                    char[] cArray2 = this.currentLine_.toCharArray();
                    int n4 = cArray2.length - this.currentOffset_;
                    if (n4 > n2 - n3) {
                        n4 = n2 - n3;
                    }
                    System.arraycopy(cArray2, this.currentOffset_, cArray, n3, n4);
                    n3 += n4;
                    this.currentOffset_ += n4;
                    if (this.currentOffset_ < this.currentLine_.length()) continue;
                    this.readRecord();
                }
                return n3 - n;
            }
        }
        catch (AS400Exception aS400Exception) {
            this.handleException(aS400Exception);
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.handleException(aS400SecurityException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.handleException(errorCompletingRequestException);
        }
        catch (InterruptedException interruptedException) {
            this.handleException(interruptedException);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.handleException(objectDoesNotExistException);
        }
        return -1;
    }

    private void handleException(Exception exception) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(2, "Error on SequentialFileReader:", (Throwable)exception);
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.currentLine_ != null && this.currentOffset_ < this.currentLine_.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.file_.positionCursorBeforeFirst();
                this.readRecord();
            }
        }
        catch (AS400Exception aS400Exception) {
            this.handleException(aS400Exception);
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.handleException(aS400SecurityException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.handleException(errorCompletingRequestException);
        }
        catch (InterruptedException interruptedException) {
            this.handleException(interruptedException);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.handleException(objectDoesNotExistException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentLine_ == null) {
                    return -1L;
                }
                long l2 = 0L;
                while (this.currentLine_ != null && l2 < l) {
                    int n = this.currentLine_.length() - this.currentOffset_;
                    if ((long)n > l) {
                        n = (int)l;
                    }
                    l2 += (long)n;
                    this.currentOffset_ += n;
                    if (this.currentOffset_ < this.currentLine_.length()) continue;
                    this.readRecord();
                }
                return l2;
            }
        }
        catch (AS400Exception aS400Exception) {
            this.handleException(aS400Exception);
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.handleException(aS400SecurityException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.handleException(errorCompletingRequestException);
        }
        catch (InterruptedException interruptedException) {
            this.handleException(interruptedException);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            this.handleException(objectDoesNotExistException);
        }
        return -1L;
    }

    private void readRecord() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Record record = this.file_.readNext();
        if (record == null) {
            this.currentLine_ = null;
        } else {
            byte[] byArray = record.getContents();
            this.currentLine_ = this.table_.byteArrayToString(byArray, 0, byArray.length) + "\n";
        }
        this.currentOffset_ = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.file_.close();
            }
        }
        catch (AS400Exception aS400Exception) {
            this.handleException(aS400Exception);
        }
        catch (AS400SecurityException aS400SecurityException) {
            this.handleException(aS400SecurityException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            this.handleException(errorCompletingRequestException);
        }
        catch (InterruptedException interruptedException) {
            this.handleException(interruptedException);
        }
    }

    static {
        coverLetterRF_.addFieldDescription(new HexFieldDescription(new AS400ByteArray(80), "QAPZCOVER"));
    }
}

