/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataAreaEvent;
import com.ibm.as400.access.DataAreaImpl;
import com.ibm.as400.access.DataAreaListener;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int UNKNOWN_LENGTH = 0;
    static final int UNINITIALIZED = 0;
    static final int CHARACTER_DATA_AREA = 1;
    static final int DECIMAL_DATA_AREA = 2;
    static final int LOCAL_DATA_AREA = 3;
    static final int LOGICAL_DATA_AREA = 4;
    private AS400 system_ = null;
    private String dataAreaPathName_ = null;
    private String name_ = null;
    private QSYSObjectPathName ifsPathName_ = null;
    int length_ = 0;
    String textDescription_ = "*BLANK";
    String authority_ = "*LIBCRTAUT";
    int dataAreaType_ = 0;
    private transient Vector daListeners_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    transient DataAreaImpl impl_;

    public DataArea() {
        this.initializeTransient();
    }

    public DataArea(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.initializeTransient();
        this.ifsPathName_ = new QSYSObjectPathName(string, "DTAARA");
        this.name_ = this.ifsPathName_.getObjectName();
        this.system_ = aS400;
        this.dataAreaPathName_ = string;
    }

    public void addDataAreaListener(DataAreaListener dataAreaListener) {
        if (dataAreaListener == null) {
            throw new NullPointerException("listener");
        }
        this.daListeners_.addElement(dataAreaListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to connect before setting system.");
            throw new ExtendedIllegalStateException("System", 4);
        }
        if (this.ifsPathName_ == null) {
            Trace.log(2, "Attempt to connect before setting data area pathname.");
            throw new ExtendedIllegalStateException("Path", 4);
        }
        this.impl_ = (DataAreaImpl)this.system_.loadImpl2("com.ibm.as400.access.DataAreaImplRemote", "com.ibm.as400.access.DataAreaImplProxy");
        this.system_.connectService(2);
        this.impl_.setAttributes(this.system_.getImpl(), this.ifsPathName_, this.dataAreaType_);
    }

    static String dataAreaTypeToString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Character";
                break;
            }
            case 2: {
                string = "Decimal";
                break;
            }
            case 3: {
                string = "Local";
                break;
            }
            case 4: {
                string = "Logical";
                break;
            }
            case 0: {
                string = "Uninitialized";
                break;
            }
            default: {
                Trace.log(2, "Unrecognized data area type: " + n);
                string = "Unrecognized";
            }
        }
        return string;
    }

    void delete0() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.delete();
        this.fireDeleted();
    }

    void fireCleared() {
        Vector vector = (Vector)this.daListeners_.clone();
        DataAreaEvent dataAreaEvent = new DataAreaEvent(this, 0);
        for (int i = 0; i < vector.size(); ++i) {
            DataAreaListener dataAreaListener = (DataAreaListener)vector.elementAt(i);
            dataAreaListener.cleared(dataAreaEvent);
        }
    }

    void fireCreated() {
        Vector vector = (Vector)this.daListeners_.clone();
        DataAreaEvent dataAreaEvent = new DataAreaEvent(this, 1);
        for (int i = 0; i < vector.size(); ++i) {
            DataAreaListener dataAreaListener = (DataAreaListener)vector.elementAt(i);
            dataAreaListener.created(dataAreaEvent);
        }
    }

    void fireDeleted() {
        Vector vector = (Vector)this.daListeners_.clone();
        DataAreaEvent dataAreaEvent = new DataAreaEvent(this, 2);
        for (int i = 0; i < vector.size(); ++i) {
            DataAreaListener dataAreaListener = (DataAreaListener)vector.elementAt(i);
            dataAreaListener.deleted(dataAreaEvent);
        }
    }

    void fireRead() {
        Vector vector = (Vector)this.daListeners_.clone();
        DataAreaEvent dataAreaEvent = new DataAreaEvent(this, 3);
        for (int i = 0; i < vector.size(); ++i) {
            DataAreaListener dataAreaListener = (DataAreaListener)vector.elementAt(i);
            dataAreaListener.read(dataAreaEvent);
        }
    }

    void fireWritten() {
        Vector vector = (Vector)this.daListeners_.clone();
        DataAreaEvent dataAreaEvent = new DataAreaEvent(this, 4);
        for (int i = 0; i < vector.size(); ++i) {
            DataAreaListener dataAreaListener = (DataAreaListener)vector.elementAt(i);
            dataAreaListener.written(dataAreaEvent);
        }
    }

    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getLength();
    }

    public String getName() {
        return this.name_;
    }

    String getPath() {
        return this.dataAreaPathName_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    void initializeTransient() {
        this.impl_ = null;
        this.daListeners_ = new Vector();
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    int read(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        block11: {
            if (byArray == null) {
                throw new NullPointerException("dataBuffer");
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException illegalObjectTypeException) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block11;
                    Trace.log(4, "Unexpected exception when retrieving length for data area.", (Throwable)illegalObjectTypeException);
                }
            }
        }
        if (byArray.length < 1) {
            throw new ExtendedIllegalArgumentException("dataBuffer", 1);
        }
        if (n < 0 || n > byArray.length - 1) {
            throw new ExtendedIllegalArgumentException("dataBufferOffset", 2);
        }
        if (n2 < 0 || n2 >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n3 < 1 || n3 > byArray.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n + n3 > byArray.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n2 + n3 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        int n4 = this.impl_.readBytes(byArray, n, n2, n3);
        this.fireRead();
        return n4;
    }

    public void refreshAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.refreshAttributes();
    }

    public void removeDataAreaListener(DataAreaListener dataAreaListener) {
        if (dataAreaListener == null) {
            throw new NullPointerException("listener");
        }
        this.daListeners_.removeElement(dataAreaListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    void setImplType(int n) {
        this.dataAreaType_ = n;
    }

    void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = this.dataAreaPathName_;
        this.vetos_.fireVetoableChange("path", string2, string);
        this.ifsPathName_ = new QSYSObjectPathName(string, "DTAARA");
        this.name_ = this.ifsPathName_.getObjectName();
        this.dataAreaPathName_ = string;
        this.changes_.firePropertyChange("path", string2, string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        this.vetos_.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        this.changes_.firePropertyChange("system", aS4002, this.system_);
    }

    void write(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        block11: {
            if (byArray == null) {
                throw new NullPointerException("dataBuffer");
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException illegalObjectTypeException) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block11;
                    Trace.log(4, "Unexpected exception when retrieving length for data area.", (Throwable)illegalObjectTypeException);
                }
            }
        }
        if (byArray.length < 1) {
            throw new ExtendedIllegalArgumentException("dataBuffer", 1);
        }
        if (n < 0 || n > byArray.length - 1) {
            throw new ExtendedIllegalArgumentException("dataBufferOffset", 2);
        }
        if (n2 < 0 || n2 >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n3 < 1 || n3 > byArray.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n + n3 > byArray.length) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n2 + n3 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(byArray, n, n2, n3);
        this.fireWritten();
    }
}

