/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.DataAreaImpl;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.UnknownHostException;

class DataAreaImplRemote
implements DataAreaImpl {
    private AS400ImplRemote system_;
    private String library_;
    private String name_;
    private QSYSObjectPathName ifsPathName_;
    private byte[] dataAreaSystemPathName_;
    private ConverterImplRemote converter_;
    private int ccsid_;
    private RemoteCommandImpl rmtCmd_;
    private AS400Message[] messageList_;
    private int length_;
    private boolean attributesRetrieved_;
    private int dataAreaType_ = 0;
    private static final QSYSObjectPathName PROGRAM_NAME = new QSYSObjectPathName("/QSYS.LIB/QWCRDTAA.PGM");
    private static final int RETURNED_DATA_FIXED_HEADER_LENGTH = 36;
    private static final boolean COMMAND_CALL = true;
    private static final boolean PROGRAM_CALL = false;
    private int decimalPositions_ = 5;

    DataAreaImplRemote() {
    }

    @Override
    public void clear() throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        Object object = null;
        switch (this.dataAreaType_) {
            case 1: {
                object = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE(' ')";
                break;
            }
            case 2: {
                object = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE(0.0)";
                break;
            }
            case 3: {
                object = "QSYS/CHGDTAARA DTAARA(*LDA) VALUE(' ')";
                break;
            }
            case 4: {
                object = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE('0')";
                break;
            }
            default: {
                Trace.log(2, "Programming error: clear() was called as dataAreaType=" + this.dataAreaType_);
                throw new InternalErrorException(6, this.dataAreaType_);
            }
        }
        if (!this.run((String)object)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void create(int n, String string, String string2, String string3) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 1) {
            Trace.log(2, "Programming error: create(int,String,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        this.length_ = n;
        String string4 = "QSYS/CRTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") TYPE(*CHAR) LEN(" + String.valueOf(this.length_) + " ) VALUE('" + string + "') TEXT('" + string2 + "') AUT(" + string3 + ")";
        if (!this.run(string4)) {
            this.processCreateExceptions(this.getMessages());
        }
        this.attributesRetrieved_ = true;
    }

    @Override
    public void create(int n, int n2, BigDecimal bigDecimal, String string, String string2) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: create(int,int,BigDecimal,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        this.length_ = n;
        this.decimalPositions_ = n2;
        String string3 = "QSYS/CRTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") TYPE(*DEC) LEN(" + String.valueOf(this.length_) + " " + String.valueOf(this.decimalPositions_) + ") VALUE(" + bigDecimal.toString() + ") TEXT('" + string + "') AUT(" + string2 + ")";
        if (!this.run(string3)) {
            this.processCreateExceptions(this.getMessages());
        }
        this.attributesRetrieved_ = true;
    }

    @Override
    public void create(boolean bl, String string, String string2) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 4) {
            Trace.log(2, "Programming error: create(boolean,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String string3 = "QSYS/CRTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") TYPE(*LGL) LEN(1) VALUE('" + (bl ? "1" : "0") + "') TEXT('" + string + "') AUT(" + string2 + ")";
        if (!this.run(string3)) {
            this.processCreateExceptions(this.getMessages());
        }
        this.attributesRetrieved_ = true;
    }

    @Override
    public void delete() throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ == 3) {
            Trace.log(2, "Programming error: delete() was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String string = "QSYS/DLTDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ")";
        if (!this.run(string)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
            return;
        }
        this.attributesRetrieved_ = false;
    }

    @Override
    public int getDecimalPositions() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: create(int,String,String,String) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        return this.decimalPositions_;
    }

    @Override
    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        return this.length_;
    }

    private AS400Message[] getMessages() {
        return this.messageList_;
    }

    void processCreateExceptions(AS400Message[] aS400MessageArray) throws AS400SecurityException, ObjectAlreadyExistsException, ObjectDoesNotExistException, AS400Exception {
        if (aS400MessageArray == null) {
            return;
        }
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            Trace.log(2, aS400MessageArray[i].toString());
            String string = aS400MessageArray[i].getID();
            if (string.equals("CPF1023")) {
                Trace.log(2, "Re-throwing as ObjectAlreadyExistsException.");
                throw new ObjectAlreadyExistsException(1);
            }
            AS400Message[] aS400MessageArray2 = new AS400Message[]{aS400MessageArray[i]};
            DataAreaImplRemote.processExceptions(aS400MessageArray2);
        }
    }

    static void processExceptions(AS400Message[] aS400MessageArray) throws AS400SecurityException, ObjectDoesNotExistException, AS400Exception {
        if (aS400MessageArray == null) {
            return;
        }
        int n = 0;
        if (n < aS400MessageArray.length) {
            Trace.log(2, aS400MessageArray[n].toString());
            String string = aS400MessageArray[n].getID();
            if (string.equals("CPF1015")) {
                Trace.log(2, "Re-throwing as ObjectDoesNotExistException.");
                throw new ObjectDoesNotExistException(2);
            }
            if (string.equals("CPF1016")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(4);
            }
            if (string.equals("CPF1018")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(4);
            }
            if (string.equals("CPF1021")) {
                Trace.log(2, "Re-throwing as ObjectDoesNotExistException.");
                throw new ObjectDoesNotExistException(1);
            }
            if (string.equals("CPF1022")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(3);
            }
            if (string.equals("CPF2105")) {
                Trace.log(2, "Re-throwing as ObjectDoesNotExistException.");
                throw new ObjectDoesNotExistException(2);
            }
            if (string.equals("CPF2182")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(3);
            }
            if (string.equals("CPF2189")) {
                Trace.log(2, "Re-throwing as AS400SecurityException.");
                throw new AS400SecurityException(4);
            }
            throw new AS400Exception(aS400MessageArray[n]);
        }
    }

    @Override
    public BigDecimal readBigDecimal() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: readBigDecimal() was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        BigDecimal bigDecimal = (BigDecimal)this.retrieveAttributes();
        return bigDecimal;
    }

    @Override
    public boolean readBoolean() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 4) {
            Trace.log(2, "Programming error: readBoolean() was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        int n = 37;
        byte[] byArray = this.retrieveDataAreaContents(n, this.dataAreaSystemPathName_, -1, 1);
        String string = this.converter_.byteArrayToString(byArray, 8, 10).toUpperCase().trim();
        if (!string.equals("*LGL")) {
            if (string.equals("*CHAR")) {
                Trace.log(2, "Illegal data area type for logical data area object: " + string);
                throw new IllegalObjectTypeException(3);
            }
            if (string.equals("*DEC")) {
                Trace.log(2, "Illegal data area type for logical data area object: " + string);
                throw new IllegalObjectTypeException(4);
            }
            Trace.log(2, "Unknown data area type for logical data area object: " + string);
            throw new IOException(ResourceBundleLoader.getText("EXC_OBJECT_TYPE_UNKNOWN"));
        }
        this.length_ = BinaryConverter.byteArrayToInt(byArray, 28);
        if (this.length_ != 1) {
            Trace.log(2, "Logical data area length not valid: " + this.length_);
            throw new IOException(ResourceBundleLoader.getText("EXC_LENGTH_NOT_VALID"));
        }
        String string2 = this.converter_.byteArrayToString(byArray, 36, 1);
        boolean bl = false;
        if (string2.equals("1")) {
            bl = true;
        } else if (!string2.equals("0")) {
            Trace.log(2, "Data received not valid: " + string2);
            throw new IOException(ResourceBundleLoader.getText("EXC_DATA_NOT_VALID"));
        }
        return bl;
    }

    @Override
    public int readBytes(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n4 = 36 + n3;
        byte[] byArray2 = this.retrieveDataAreaContents(n4, this.dataAreaSystemPathName_, n2 + 1, n3);
        int n5 = BinaryConverter.byteArrayToInt(byArray2, 4);
        if ((n5 -= 36) > n3) {
            Trace.log(2, "Unexpected number of bytes returned: " + n5);
            throw new InternalErrorException(6, n5);
        }
        if (n5 < n3) {
            Trace.log(4, "Fewer bytes returned than requested: " + n5);
        }
        System.arraycopy(byArray2, 36, byArray, n, n5);
        return n5;
    }

    private byte[] retrieveDataAreaContents(int n, byte[] byArray, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        byte[] byArray2 = new byte[n];
        programParameterArray[0] = new ProgramParameter(byArray2.length);
        byte[] byArray3 = new byte[4];
        BinaryConverter.intToByteArray(byArray2.length, byArray3, 0);
        programParameterArray[1] = new ProgramParameter(byArray3);
        programParameterArray[2] = new ProgramParameter(byArray);
        byte[] byArray4 = BinaryConverter.intToByteArray(n2);
        programParameterArray[3] = new ProgramParameter(byArray4);
        byte[] byArray5 = BinaryConverter.intToByteArray(n3);
        programParameterArray[4] = new ProgramParameter(byArray5);
        byte[] byArray6 = new byte[17];
        BinaryConverter.intToByteArray(0, byArray6, 0);
        programParameterArray[5] = new ProgramParameter(byArray6, 17);
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.rmtCmd_.runProgram("QSYS", "QWCRDTAA", programParameterArray)) {
            DataAreaImplRemote.processExceptions(this.rmtCmd_.getMessageList());
        }
        byArray2 = programParameterArray[0].getOutputData();
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            String string = DataArea.dataAreaTypeToString(this.dataAreaType_);
            Trace.log(1, string + " data area data retrieved:", byArray2);
        }
        return byArray2;
    }

    @Override
    public void refreshAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.attributesRetrieved_ = false;
        this.retrieveAttributes();
    }

    @Override
    public String retrieve(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (AS400BidiTransform.isBidiCcsid(this.ccsid_)) {
            return this.retrieve(n, n2, AS400BidiTransform.getStringType((char)this.ccsid_));
        }
        return this.retrieve(n, n2, 0);
    }

    @Override
    public String retrieve(int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.dataAreaType_ != 1 && this.dataAreaType_ != 3) {
            Trace.log(2, "Programming error: retrieve(int,int) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        int n4 = 4037;
        int n5 = n == -1 ? n : n + 1;
        byte[] byArray = this.retrieveDataAreaContents(n4, this.dataAreaSystemPathName_, n5, n2);
        String string = this.converter_.byteArrayToString(byArray, 8, 10).toUpperCase().trim();
        if (!string.equals("*CHAR")) {
            if (string.equals("*DEC")) {
                Trace.log(2, "Illegal data area type for character data area object: " + string);
                throw new IllegalObjectTypeException(4);
            }
            if (string.equals("*LGL")) {
                Trace.log(2, "Illegal data area type for character data area object: " + string);
                throw new IllegalObjectTypeException(5);
            }
            Trace.log(2, "Illegal data area type for character data area object: " + string);
            throw new IOException(ResourceBundleLoader.getText("EXC_OBJECT_TYPE_UNKNOWN"));
        }
        if (n == -1) {
            this.length_ = BinaryConverter.byteArrayToInt(byArray, 28);
        }
        int n6 = BinaryConverter.byteArrayToInt(byArray, 4);
        return this.converter_.byteArrayToString(byArray, 36, n6 -= 36, n3);
    }

    private Object retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        switch (this.dataAreaType_) {
            case 1: 
            case 3: {
                return this.retrieveAttributesString();
            }
            case 2: {
                return this.retrieveAttributesBigDecimal();
            }
            case 4: {
                return this.retrieveAttributesBoolean();
            }
        }
        Trace.log(2, "Programming error: retrieveAttributes() was called as dataAreaType=" + this.dataAreaType_);
        throw new InternalErrorException(6, this.dataAreaType_);
    }

    private Object retrieveAttributesBigDecimal() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n = 60;
        byte[] byArray = this.retrieveDataAreaContents(n, this.dataAreaSystemPathName_, -1, 24);
        String string = this.converter_.byteArrayToString(byArray, 8, 10).toUpperCase().trim();
        if (!string.equals("*DEC")) {
            if (string.equals("*CHAR")) {
                Trace.log(2, "Illegal data area type for decimal data area object: " + string);
                throw new IllegalObjectTypeException(3);
            }
            if (string.equals("*LGL")) {
                Trace.log(2, "Illegal data area type for decimal data area object: " + string);
                throw new IllegalObjectTypeException(5);
            }
            Trace.log(2, "Illegal data area type for decimal data area object: " + string);
            throw new IOException(ResourceBundleLoader.getText("EXC_OBJECT_TYPE_UNKNOWN"));
        }
        this.length_ = BinaryConverter.byteArrayToInt(byArray, 28);
        this.decimalPositions_ = BinaryConverter.byteArrayToInt(byArray, 32);
        AS400PackedDecimal aS400PackedDecimal = new AS400PackedDecimal(this.length_, this.decimalPositions_);
        byte[] byArray2 = new byte[24];
        System.arraycopy(byArray, 36, byArray2, 0, 24);
        BigDecimal bigDecimal = (BigDecimal)aS400PackedDecimal.toObject(byArray2);
        this.attributesRetrieved_ = true;
        return bigDecimal;
    }

    private Object retrieveAttributesBoolean() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        boolean[] blArray = new boolean[]{this.readBoolean()};
        this.attributesRetrieved_ = true;
        return blArray;
    }

    private Object retrieveAttributesString() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = this.retrieve(-1, 1);
        this.attributesRetrieved_ = true;
        return string;
    }

    private boolean run(String string) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException {
        boolean bl = false;
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        bl = this.rmtCmd_.runCommand(string);
        this.messageList_ = this.rmtCmd_.getMessageList();
        return bl;
    }

    @Override
    public void setAttributes(AS400Impl aS400Impl, QSYSObjectPathName qSYSObjectPathName, int n) throws IOException {
        this.setSystem((AS400ImplRemote)aS400Impl);
        this.setPath(qSYSObjectPathName);
        this.setType(n);
    }

    private void setPath(QSYSObjectPathName qSYSObjectPathName) throws CharConversionException, UnsupportedEncodingException {
        this.ifsPathName_ = qSYSObjectPathName;
        this.library_ = this.ifsPathName_.getLibraryName();
        this.name_ = this.ifsPathName_.getObjectName();
        if (this.ccsid_ == 0) {
            this.ccsid_ = this.system_.getCcsid();
        }
        if (this.converter_ == null) {
            this.converter_ = ConverterImplRemote.getConverter(this.ccsid_, this.system_);
        }
        this.dataAreaSystemPathName_ = new byte[20];
        for (int i = 0; i < 20; ++i) {
            this.dataAreaSystemPathName_[i] = 64;
        }
        this.converter_.stringToByteArray(this.name_, this.dataAreaSystemPathName_, 0, 10);
        this.converter_.stringToByteArray(this.library_, this.dataAreaSystemPathName_, 10, 10);
    }

    private void setSystem(AS400ImplRemote aS400ImplRemote) {
        this.system_ = aS400ImplRemote;
    }

    private void setType(int n) {
        switch (n) {
            case 1: {
                this.length_ = 32;
                break;
            }
            case 2: {
                this.length_ = 15;
                break;
            }
            case 3: {
                this.length_ = 1024;
                break;
            }
            case 4: {
                this.length_ = 1;
                break;
            }
            default: {
                Trace.log(2, "Programming error: setType() was called with arg=" + n);
                throw new InternalErrorException(6, n);
            }
        }
        this.dataAreaType_ = n;
    }

    protected synchronized void setupRemoteCommand() throws IOException {
        if (this.rmtCmd_ == null) {
            if (this.system_.canUseNativeOptimizations()) {
                try {
                    this.rmtCmd_ = (RemoteCommandImpl)Class.forName("com.ibm.as400.access.RemoteCommandImplNative").newInstance();
                }
                catch (Throwable throwable) {
                    Trace.log(4, "Unable to instantiate class RemoteCommandImplNative.", throwable);
                }
            }
            if (this.rmtCmd_ == null) {
                this.rmtCmd_ = new RemoteCommandImplRemote();
            }
            this.rmtCmd_.setSystem(this.system_);
        }
    }

    @Override
    public void write(String string, int n) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (AS400BidiTransform.isBidiCcsid(this.ccsid_)) {
            this.write(string, n, AS400BidiTransform.getStringType((char)this.ccsid_));
        } else {
            this.write(string, n, 0);
        }
    }

    @Override
    public void write(String string, int n, int n2) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        byte[] byArray;
        int n3;
        if (this.dataAreaType_ != 1 && this.dataAreaType_ != 3) {
            Trace.log(2, "Programming error: write(String,int) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        byte[] byArray2 = this.converter_.stringToByteArray(string, n2);
        byte[] byArray3 = this.converter_.stringToByteArray("')");
        int n4 = byArray2.length;
        int n5 = 0;
        switch (this.dataAreaType_) {
            case 1: {
                n3 = 0;
                while (n3 < string.length()) {
                    int n6 = string.indexOf("''", n3);
                    if (n6 != -1) {
                        ++n5;
                        n3 = n6 + 2;
                        continue;
                    }
                    n3 = string.length();
                }
                byArray = this.converter_.stringToByteArray("QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + " (" + (n + 1) + " " + (n4 - n5) + ")) VALUE('");
                break;
            }
            case 3: {
                byArray = this.converter_.stringToByteArray("QSYS/CHGDTAARA DTAARA(*LDA (" + (n + 1) + " " + n4 + ")) VALUE('");
                break;
            }
            default: {
                Trace.log(2, "Programming error: write(String,int) was called as dataAreaType=" + this.dataAreaType_);
                throw new InternalErrorException(6, this.dataAreaType_);
            }
        }
        byte[] byArray4 = new byte[byArray.length + n4 + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, n4);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + n4, byArray3.length);
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        if (Trace.isTraceOn()) {
            String string2 = this.converter_.byteArrayToString(byArray4);
            Trace.log(1, "wrtcmd2=[" + string2 + "]");
        }
        n3 = this.rmtCmd_.runCommand(byArray4, "QSYS/CHGDTAARA") ? 1 : 0;
        this.messageList_ = this.rmtCmd_.getMessageList();
        if (n3 == 0) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void write(BigDecimal bigDecimal) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 2) {
            Trace.log(2, "Programming error: write(BigDecimal) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String string = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE(" + bigDecimal.toString() + ")";
        if (!this.run(string)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void write(boolean bl) throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, UnknownHostException {
        if (this.dataAreaType_ != 4) {
            Trace.log(2, "Programming error: write(boolean) was called when dataAreaType=" + this.dataAreaType_);
            throw new InternalErrorException(6, this.dataAreaType_);
        }
        String string = "QSYS/CHGDTAARA DTAARA(" + this.library_ + "/" + this.name_ + ") VALUE('" + (bl ? "1" : "0") + "')";
        if (!this.run(string)) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object = null;
        switch (this.dataAreaType_) {
            case 1: {
                object = this.library_ + "/" + this.name_;
                break;
            }
            case 3: {
                object = "*LDA";
                break;
            }
            default: {
                Trace.log(2, "Programming error: write(byte[],int,int,int) was called when dataAreaType=" + this.dataAreaType_);
                throw new InternalErrorException(6, this.dataAreaType_);
            }
        }
        String string = "QSYS/CHGDTAARA DTAARA(" + (String)object + " (" + (n2 + 1) + " " + n3 + ")) VALUE(X'" + BinaryConverter.bytesToString(byArray, n, n3) + "')";
        if (this.rmtCmd_ == null) {
            this.setupRemoteCommand();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "wrtcmd=[" + string + "]");
        }
        boolean bl = this.rmtCmd_.runCommand(string);
        this.messageList_ = this.rmtCmd_.getMessageList();
        if (!bl) {
            DataAreaImplRemote.processExceptions(this.getMessages());
        }
    }
}

