/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ErrorCodeParameter
extends ProgramParameter
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    private static final boolean FORMAT_ERRC0100 = true;
    private static final boolean FORMAT_ERRC0200 = false;
    private static final int CCSID_EBCDIC = 37;
    private CharConverter charConverter_;
    private boolean format_;
    private boolean returnSubstitutionData_;
    private boolean usedMinimalConstructor_;

    public ErrorCodeParameter() {
        super(BinaryConverter.intToByteArray(0), 8);
        this.format_ = true;
        this.returnSubstitutionData_ = false;
        this.usedMinimalConstructor_ = true;
    }

    public ErrorCodeParameter(boolean bl, boolean bl2) {
        this.returnSubstitutionData_ = bl;
        this.usedMinimalConstructor_ = false;
        this.format_ = !bl2;
        try {
            byte[] byArray;
            int n;
            int n2;
            if (this.format_) {
                n2 = 16;
                n = 0;
                byArray = new byte[4];
            } else {
                n2 = 32;
                n = 4;
                byArray = new byte[8];
                BinaryConverter.intToByteArray(-1, byArray, 0);
            }
            if (bl) {
                n2 += 100;
            }
            BinaryConverter.intToByteArray(n2, byArray, n);
            this.setInputData(byArray);
            this.setOutputDataLength(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
            throw new InternalErrorException(10, (Throwable)propertyVetoException);
        }
    }

    int getDataCCSID() {
        if (this.format_) {
            return 0;
        }
        byte[] byArray = this.getOutputData();
        if (byArray == null) {
            return 0;
        }
        if (byArray.length < 24) {
            Trace.log(2, "Output data buffer is too short: " + byArray.length + " bytes. Minimum size required: 24");
            throw new InternalErrorException(6, "Output buffer too short.", null);
        }
        return BinaryConverter.byteArrayToInt(byArray, 20);
    }

    public String getMessageID() {
        int n;
        if (this.usedMinimalConstructor_) {
            return null;
        }
        byte[] byArray = this.getOutputData();
        if (byArray == null) {
            return null;
        }
        int n2 = n = this.format_ ? 8 : 12;
        if (byArray.length < n + 7) {
            Trace.log(2, "Output data buffer is too short: " + byArray.length + " bytes. Minimum size required: " + (n + 7));
            throw new InternalErrorException(6, "Output buffer too short.", null);
        }
        String string = this.getCharConverter().byteArrayToString(byArray, n, 7).trim();
        if (string.length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "Blank message ID returned.");
            }
            return null;
        }
        return string;
    }

    public String getSubstitutionData() {
        String string;
        int n;
        if (!this.returnSubstitutionData_) {
            return null;
        }
        byte[] byArray = this.getOutputData();
        if (byArray == null) {
            return null;
        }
        int n2 = this.format_ ? 4 : 8;
        int n3 = n = this.format_ ? 16 : 32;
        if (byArray.length < n + 1) {
            Trace.log(2, "Output data buffer is too short: " + byArray.length + " bytes. Minimum size required: " + (n + 1));
            throw new InternalErrorException(6, "Output buffer too short.", null);
        }
        int n4 = BinaryConverter.byteArrayToInt(byArray, n2);
        int n5 = this.format_ ? n4 - 16 : BinaryConverter.byteArrayToInt(byArray, 28);
        int n6 = this.getDataCCSID();
        if (n6 == 0 || n6 == 65535) {
            string = this.getCharConverter().byteArrayToString(byArray, n, n5);
        } else {
            try {
                CharConverter charConverter = new CharConverter(n6);
                string = charConverter.byteArrayToString(byArray, n, n5);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Trace.log(2, "Received UnsupportedEncodingException for CCSID " + n6, (Throwable)unsupportedEncodingException);
                throw new InternalErrorException(10, (Throwable)unsupportedEncodingException);
            }
        }
        return string;
    }

    private CharConverter getCharConverter() {
        try {
            if (this.charConverter_ == null) {
                this.charConverter_ = new CharConverter(37);
            }
            return this.charConverter_;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(2, "Received UnsupportedEncodingException for CCSID 37", (Throwable)unsupportedEncodingException);
            throw new InternalErrorException(10, (Throwable)unsupportedEncodingException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "De-serializing ErrorCodeParameter object.");
        }
        objectInputStream.defaultReadObject();
    }
}

