/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDSimpleRow;
import java.sql.SQLException;
import java.util.Vector;

class JDSimpleRowCache
implements JDRowCache {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int index_;
    private JDSimpleRow row_;
    private Object[][] data_;
    private boolean[][] nulls_;
    private boolean[][] dataMappingErrors_;
    private boolean valid_;

    JDSimpleRowCache(JDSimpleRow jDSimpleRow) {
        this.index_ = -1;
        this.valid_ = false;
        this.row_ = jDSimpleRow;
        int n = this.row_.getFieldCount();
        this.data_ = new Object[0][n];
        this.nulls_ = new boolean[0][n];
        this.dataMappingErrors_ = new boolean[0][n];
    }

    JDSimpleRowCache(JDSimpleRow jDSimpleRow, Object[][] objectArray, boolean[][] blArray, boolean[][] blArray2) {
        this.index_ = -1;
        this.valid_ = false;
        this.row_ = jDSimpleRow;
        this.data_ = objectArray;
        this.nulls_ = blArray;
        this.dataMappingErrors_ = blArray2;
    }

    JDSimpleRowCache(JDSimpleRow jDSimpleRow, Object[][] objectArray) {
        this.index_ = -1;
        this.valid_ = false;
        this.row_ = jDSimpleRow;
        this.data_ = objectArray;
        this.nulls_ = new boolean[objectArray.length][objectArray[0].length];
        this.dataMappingErrors_ = new boolean[objectArray.length][objectArray[0].length];
    }

    JDSimpleRowCache(JDRowCache jDRowCache) throws SQLException {
        Vector<Object[]> vector = new Vector<Object[]>();
        Vector<boolean[]> vector2 = new Vector<boolean[]>();
        Vector<boolean[]> vector3 = new Vector<boolean[]>();
        JDRow jDRow = jDRowCache.getRow();
        int n = jDRow.getFieldCount();
        int n2 = 0;
        this.row_ = new JDSimpleRow(jDRow, false);
        jDRowCache.open();
        jDRowCache.next();
        while (jDRowCache.isValid()) {
            Object[] objectArray = new Object[n];
            boolean[] blArray = new boolean[n];
            boolean[] blArray2 = new boolean[n];
            for (int i = 1; i <= n; ++i) {
                objectArray[i - 1] = jDRow.getSQLData(i).getObject();
                blArray[i - 1] = jDRow.isNull(i);
                blArray2[i - 1] = jDRow.isDataMappingError(i);
            }
            vector.addElement(objectArray);
            vector2.addElement(blArray);
            vector3.addElement(blArray2);
            ++n2;
            jDRowCache.next();
        }
        this.index_ = -1;
        this.data_ = new Object[n2][n];
        this.nulls_ = new boolean[n2][n];
        this.dataMappingErrors_ = new boolean[n2][n];
        this.valid_ = false;
        for (int i = 0; i < n2; ++i) {
            this.data_[i] = (Object[])vector.elementAt(i);
            this.nulls_[i] = (boolean[])vector2.elementAt(i);
            this.dataMappingErrors_[i] = (boolean[])vector3.elementAt(i);
        }
    }

    private void reposition(boolean bl) throws SQLException {
        this.valid_ = bl;
        if (this.valid_) {
            this.row_.setData(this.data_[this.index_]);
            this.row_.setNulls(this.nulls_[this.index_]);
            this.row_.setDataMappingErrors(this.dataMappingErrors_[this.index_]);
        }
    }

    @Override
    public void open() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void flush() throws SQLException {
    }

    @Override
    public JDRow getRow() {
        return this.row_;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        return this.data_.length == 0;
    }

    @Override
    public boolean isValid() {
        return this.valid_;
    }

    @Override
    public void absolute(int n) throws SQLException {
        if (n > 0) {
            if (n <= this.data_.length) {
                this.index_ = n - 1;
                this.reposition(true);
            } else {
                this.index_ = this.data_.length;
                this.reposition(false);
            }
        } else if (n < 0) {
            if (-n <= this.data_.length) {
                this.index_ = this.data_.length + n;
                this.reposition(true);
            } else {
                this.index_ = -1;
                this.reposition(false);
            }
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.index_ = this.data_.length;
        this.reposition(false);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.index_ = -1;
        this.reposition(false);
    }

    @Override
    public void first() throws SQLException {
        this.index_ = 0;
        this.reposition(this.data_.length > 0);
    }

    @Override
    public void last() throws SQLException {
        this.index_ = this.data_.length - 1;
        this.reposition(this.data_.length > 0);
    }

    @Override
    public void next() throws SQLException {
        if (this.index_ < this.data_.length - 1) {
            ++this.index_;
            this.reposition(true);
        } else {
            this.index_ = this.data_.length;
            this.reposition(false);
        }
    }

    @Override
    public void previous() throws SQLException {
        if (this.index_ > 0) {
            --this.index_;
            this.reposition(true);
        } else {
            this.index_ = -1;
            this.reposition(false);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.reposition(this.valid_);
    }

    @Override
    public void relative(int n) throws SQLException {
        int n2 = this.index_ + n;
        if (n2 >= 0 && n2 < this.data_.length) {
            this.index_ = n2;
            this.reposition(true);
        } else {
            this.reposition(false);
        }
    }

    @Override
    public void setResultSet(AS400JDBCResultSet aS400JDBCResultSet) {
    }
}

