/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobList;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Tracker;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class JobEnumeration
implements Enumeration {
    private Job[] jobCache_;
    private JobList list_;
    private int counter_;
    private int numJobs_;
    private int listOffset_ = 0;
    private int cacheOffset_ = 0;
    private Tracker tracker_;

    JobEnumeration(JobList jobList, int n, Tracker tracker) {
        this.list_ = jobList;
        this.numJobs_ = n;
        this.tracker_ = tracker;
    }

    protected void finalize() throws Throwable {
        this.tracker_.set(false);
        super.finalize();
    }

    @Override
    public final boolean hasMoreElements() {
        if (!this.tracker_.isSet()) {
            return false;
        }
        if (this.counter_ < this.numJobs_) {
            return true;
        }
        this.tracker_.set(false);
        return false;
    }

    public final Object nextElement() {
        if (this.counter_ >= this.numJobs_ || !this.tracker_.isSet()) {
            this.tracker_.set(false);
            throw new NoSuchElementException();
        }
        if (this.jobCache_ == null || this.cacheOffset_ >= this.jobCache_.length) {
            try {
                this.jobCache_ = this.list_.getJobs(this.listOffset_, 1000);
                if (Trace.traceOn_) {
                    Trace.log(1, "Loaded next block in JobEnumeration: " + this.jobCache_.length + " messages at list offset " + this.listOffset_ + " out of " + this.numJobs_ + " total.");
                }
            }
            catch (Exception exception) {
                Trace.log(2, "Exception while loading nextElement() in JobEnumeration:", (Throwable)exception);
                throw new NoSuchElementException();
            }
            this.cacheOffset_ = 0;
            this.listOffset_ += this.jobCache_.length;
        }
        ++this.counter_;
        return this.jobCache_[this.cacheOffset_++];
    }
}

