/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

class LicenseBaseRequest
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    protected CharConverter conv_;
    static final int PRODUCT_ID_CCSID_LOCATION = 22;
    static final int PRODUCT_ID_LOCATION = 26;
    static final int FEATURE_CCSID_LOCATION = 33;
    static final int FEATURE_LOCATION = 37;
    static final int RELEASE_CCSID_LOCATION = 41;
    static final int RELEASE_LOCATION = 45;

    LicenseBaseRequest(int n, AS400 aS400) {
        block5: {
            int n2;
            this.data_ = new byte[n];
            this.setLength(n);
            this.setHeaderID(0);
            this.setServerID(57344);
            this.setCSInstance(0);
            this.setCorrelation(0);
            this.setTemplateLen(n - 20);
            this.set16bit(0, 20);
            for (n2 = 0; n2 < 7; ++n2) {
                this.data_[26 + n2] = 64;
            }
            for (n2 = 0; n2 < 4; ++n2) {
                this.data_[37 + n2] = 64;
            }
            for (n2 = 0; n2 < 6; ++n2) {
                this.data_[45 + n2] = 64;
            }
            this.set32bit(37, 22);
            this.set32bit(37, 33);
            this.set32bit(37, 41);
            try {
                this.conv_ = new CharConverter(37, aS400);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!Trace.isTraceOn()) break block5;
                Trace.log(2, "Unsupported encoding exception - CCSID 37.");
            }
        }
        this.set16bit(0, n - 2);
    }

    void setProductID(String string) {
        block2: {
            try {
                this.conv_.stringToByteArray(string, this.data_, 26, 7);
            }
            catch (CharConversionException charConversionException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Character conversion exception - productID: " + string);
            }
        }
    }

    void setFeature(String string) {
        block2: {
            try {
                this.conv_.stringToByteArray(string, this.data_, 37, 4);
            }
            catch (CharConversionException charConversionException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Character conversion exception - feature: " + string);
            }
        }
    }

    void setRelease(String string) {
        block2: {
            try {
                this.conv_.stringToByteArray(string, this.data_, 45, 6);
            }
            catch (CharConversionException charConversionException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Character conversion exception - release: " + string);
            }
        }
    }
}

