/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.QueuedMessageEnumeration;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class MessageQueue
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final String ANY = "*ANY";
    public static final String BYKEY = "*BYKEY";
    public static final String COMPLETION = "*COMP";
    public static final String COPY = "*COPY";
    public static final String CURRENT = "*CURRENT";
    public static final String DIAGNOSTIC = "*DIAG";
    public static final String FIRST = "*FIRST";
    public static final String INFORMATIONAL = "*INFO";
    public static final String INQUIRY = "*INQ";
    public static final String KEEP_UNANSWERED = "*KEEPUNANS";
    public static final String LAST = "*LAST";
    public static final String MESSAGES_NEED_REPLY = "*MNR";
    public static final String MESSAGES_NO_NEED_REPLY = "*MNNR";
    public static final String NEW = "*NEW";
    public static final byte[] NEWEST = new byte[]{-1, -1, -1, -1};
    public static final String NEXT = "*NEXT";
    public static final String OLD = "*OLD";
    public static final byte[] OLDEST = new byte[4];
    public static final String PREVIOUS = "*PRV";
    public static final String REMOVE = "*REMOVE";
    public static final String REPLY = "*RPY";
    public static final String SAME = "*SAME";
    public static final String SENDERS_COPY_NEED_REPLY = "*SCNR";
    private static final byte[] BLANK_KEY = new byte[]{64, 64, 64, 64};
    private AS400 system_;
    private String path_;
    private String library_ = null;
    private String name_ = null;
    private int length_;
    private int dataLength_;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private boolean sort_ = false;
    private int helpTextFormatting_ = 0;
    private boolean listDirection_ = true;
    private int severity_ = 0;
    private byte[] userStartingMessageKey_;
    private byte[] workstationStartingMessageKey_;
    private String selection_ = "*ALL";
    private boolean selectMessagesNeedReply_ = true;
    private boolean selectMessagesNoNeedReply_ = true;
    private boolean selectSendersCopyMessagesNeedReply_ = true;
    private transient Converter conv_ = null;
    private transient byte[] qualifiedMessageQueueName_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public MessageQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageQueue object.");
        }
        this.path_ = CURRENT;
    }

    public MessageQueue(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageQueue object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        this.path_ = CURRENT;
    }

    public MessageQueue(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing MessageQueue object, system: " + aS400 + " path: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (!string.equals(CURRENT)) {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "MSGQ");
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
        }
        this.path_ = string;
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing message queue message list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for message queue invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public int getHelpTextFormatting() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting help text formatting:", this.helpTextFormatting_);
        }
        return this.helpTextFormatting_;
    }

    public int getLength() {
        block5: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting message queue list length.");
            }
            try {
                if (this.handle_ == null || this.closeHandle_) {
                    this.load();
                }
            }
            catch (Exception exception) {
                Trace.log(2, "Exception caught getting length of message queue list:", (Throwable)exception);
                if (!(exception instanceof ExtendedIllegalStateException)) break block5;
                throw (ExtendedIllegalStateException)exception;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public boolean getListDirection() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting list direction:", this.listDirection_);
        }
        return this.listDirection_;
    }

    public Enumeration getMessages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message queue message list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new QueuedMessageEnumeration(this, this.length_);
    }

    public QueuedMessage[] getMessages(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving message queue message list, list offset: " + n + ", number:", n2);
        }
        if (n < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + n + ")", 4);
        }
        if (n2 < 0 && n != -1) {
            throw new ExtendedIllegalArgumentException("number (" + n2 + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || n2 == 0 && n != -1) {
            return new QueuedMessage[0];
        }
        if (n == -1) {
            n2 = this.length_;
            n = 0;
        } else {
            if (n >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", n + " (list length: " + this.length_ + ")");
                }
                return new QueuedMessage[0];
            }
            if (n + n2 > this.length_) {
                n2 = this.length_ - n;
            }
        }
        int n3 = this.dataLength_ / this.length_ * n2;
        byte[] byArray = ListUtilities.retrieveListEntries(this.system_, this.handle_, n3, n2, n, null);
        this.resolveConverter();
        QueuedMessage[] queuedMessageArray = new QueuedMessage[n2];
        int n4 = 0;
        for (int i = 0; i < queuedMessageArray.length; ++i) {
            int n5 = BinaryConverter.byteArrayToInt(byArray, n4);
            int n6 = BinaryConverter.byteArrayToInt(byArray, n4 + 4);
            int n7 = BinaryConverter.byteArrayToInt(byArray, n4 + 8);
            int n8 = BinaryConverter.byteArrayToInt(byArray, n4 + 12);
            String string = this.conv_.byteArrayToString(byArray, n4 + 16, 7).trim();
            int n9 = (byArray[n4 + 23] & 0xF) * 10 + (byArray[n4 + 24] & 0xF);
            if (n9 == 0) {
                n9 = -1;
            }
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, n4 + 25, byArray2, 0, 4);
            String string2 = this.conv_.byteArrayToString(byArray, n4 + 29, 10).trim();
            String string3 = this.conv_.byteArrayToString(byArray, n4 + 39, 10).trim();
            String string4 = this.conv_.byteArrayToString(byArray, n4 + 49, 10).trim();
            String string5 = this.conv_.byteArrayToString(byArray, n4 + 59, 10).trim();
            String string6 = this.conv_.byteArrayToString(byArray, n4 + 69, 7);
            String string7 = this.conv_.byteArrayToString(byArray, n4 + 76, 6);
            MessageQueue messageQueue = string5.length() > 0 && string4.length() > 0 ? new MessageQueue(this.system_, QSYSObjectPathName.toPath(string5, string4, "MSGQ")) : this;
            queuedMessageArray[i] = new QueuedMessage(messageQueue, n8, string, n9, byArray2, string2, string3, string6, string7);
            for (int j = 0; j < n7; ++j) {
                int n10 = BinaryConverter.byteArrayToInt(byArray, n6);
                int n11 = BinaryConverter.byteArrayToInt(byArray, n6 + 8);
                byte by = byArray[n6 + 12];
                int n12 = BinaryConverter.byteArrayToInt(byArray, n6 + 28);
                if (by == -61) {
                    queuedMessageArray[i].setValueInternal(n11, this.conv_.byteArrayToString(byArray, n6 + 32, n12));
                } else if (by == -62) {
                    if (n12 > 4) {
                        queuedMessageArray[i].setAsLong(n11, BinaryConverter.byteArrayToLong(byArray, n6 + 32));
                    } else {
                        queuedMessageArray[i].setAsInt(n11, BinaryConverter.byteArrayToInt(byArray, n6 + 32));
                    }
                } else {
                    int n13 = BinaryConverter.byteArrayToInt(byArray, n6 + 32);
                    String[] stringArray = new String[n13];
                    for (int k = 0; k < n13; ++k) {
                        stringArray[k] = this.conv_.byteArrayToString(byArray, n6 + 36 + k * 10, 10);
                    }
                    queuedMessageArray[i].setValueInternal(n11, stringArray);
                }
                n6 = n10;
            }
            n4 = n5;
        }
        return queuedMessageArray;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    public String getSelection() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting selection: " + this.selection_);
        }
        return this.selection_;
    }

    public int getSeverity() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting severity:", this.severity_);
        }
        return this.severity_;
    }

    public boolean getSort() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting sort:", this.sort_);
        }
        return this.sort_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public byte[] getUserStartingMessageKey() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user starting message key:", this.userStartingMessageKey_);
        }
        byte[] byArray = null;
        if (this.userStartingMessageKey_ != null) {
            byArray = new byte[this.userStartingMessageKey_.length];
            System.arraycopy(this.userStartingMessageKey_, 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public byte[] getWorkstationStartingMessageKey() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting workstation starting message key:", this.workstationStartingMessageKey_);
        }
        byte[] byArray = null;
        if (this.workstationStartingMessageKey_ != null) {
            byArray = new byte[this.workstationStartingMessageKey_.length];
            System.arraycopy(this.workstationStartingMessageKey_, 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public boolean isSelectMessagesNeedReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if messages that need a reply are selected:", this.selectMessagesNeedReply_);
        }
        return this.selectMessagesNeedReply_;
    }

    public boolean isSelectMessagesNoNeedReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if messages that do not need a reply are selected:", this.selectMessagesNoNeedReply_);
        }
        return this.selectMessagesNoNeedReply_;
    }

    public boolean isSelectSendersCopyMessagesNeedReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if sender's copy messages that need a reply are selected:", this.selectSendersCopyMessagesNeedReply_);
        }
        return this.selectSendersCopyMessagesNeedReply_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray;
        int n;
        boolean bl;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading message queue message list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        boolean bl2 = this.system_.getVRM() >= 328448;
        boolean bl3 = bl = this.selectMessagesNeedReply_ && this.selectMessagesNoNeedReply_ && this.selectSendersCopyMessagesNeedReply_ || !this.selectMessagesNeedReply_ && !this.selectMessagesNoNeedReply_ && !this.selectSendersCopyMessagesNeedReply_;
        int n2 = bl ? 1 : (this.selectMessagesNeedReply_ ? 1 : 0) + (this.selectMessagesNoNeedReply_ ? 1 : 0) + (this.selectSendersCopyMessagesNeedReply_ ? 1 : 0);
        int n3 = bl2 ? 8 : 7;
        byte[] byArray2 = new byte[52 + 10 * n2 + 4 * n3];
        if (this.listDirection_) {
            System.arraycopy(new byte[]{92, -43, -59, -25, -29, 64, 64, 64, 64, 64}, 0, byArray2, 0, 10);
        } else {
            System.arraycopy(new byte[]{92, -41, -39, -27, 64, 64, 64, 64, 64, 64}, 0, byArray2, 0, 10);
        }
        BinaryConverter.intToByteArray(this.severity_, byArray2, 12);
        for (n = 16; n < 24; ++n) {
            byArray2[n] = -1;
        }
        BinaryConverter.intToByteArray(44, byArray2, 24);
        BinaryConverter.intToByteArray(n2, byArray2, 28);
        n = 44 + n2 * 10;
        BinaryConverter.intToByteArray(n, byArray2, 32);
        BinaryConverter.intToByteArray(n + 8, byArray2, 36);
        BinaryConverter.intToByteArray(n3, byArray2, 40);
        if (bl) {
            System.arraycopy(new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64}, 0, byArray2, 44, 10);
        } else {
            int n4 = 44;
            if (this.selectMessagesNeedReply_) {
                System.arraycopy(new byte[]{92, -44, -43, -39, 64, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
            if (this.selectMessagesNoNeedReply_) {
                System.arraycopy(new byte[]{92, -44, -43, -43, -39, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
                n4 += 10;
            }
            if (this.selectSendersCopyMessagesNeedReply_) {
                System.arraycopy(new byte[]{92, -30, -61, -43, -39, 64, 64, 64, 64, 64}, 0, byArray2, n4, 10);
            }
        }
        byte[] byArray3 = this.userStartingMessageKey_ != null ? this.userStartingMessageKey_ : (this.listDirection_ ? OLDEST : NEWEST);
        System.arraycopy(byArray3, 0, byArray2, n, 4);
        byte[] byArray4 = this.workstationStartingMessageKey_ != null ? this.workstationStartingMessageKey_ : byArray3;
        System.arraycopy(byArray4, 0, byArray2, n + 4, 4);
        BinaryConverter.intToByteArray(302, byArray2, n + 8);
        BinaryConverter.intToByteArray(601, byArray2, n + 12);
        BinaryConverter.intToByteArray(603, byArray2, n + 16);
        BinaryConverter.intToByteArray(1001, byArray2, n + 20);
        BinaryConverter.intToByteArray(501, byArray2, n + 24);
        BinaryConverter.intToByteArray(404, byArray2, n + 28);
        BinaryConverter.intToByteArray(101, byArray2, n + 32);
        if (bl2) {
            BinaryConverter.intToByteArray(607, byArray2, n + 36);
        }
        if (this.path_.equals(CURRENT)) {
            byArray = new byte[]{-16, 92, -61, -28, -39, -39, -59, -43, -29, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        } else {
            byArray = new byte[]{-15, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            this.resolveConverter();
            this.conv_.stringToByteArray(this.name_, byArray, 1);
            this.conv_.stringToByteArray(this.library_, byArray, 11);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(new byte[]{this.sort_ && bl ? (byte)-15 : -16}), new ProgramParameter(byArray2), new ProgramParameter(BinaryConverter.intToByteArray(byArray2.length)), new ProgramParameter(byArray), new ProgramParameter(44), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLMSG.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray5 = programParameterArray[2].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(byArray5, 8, this.handle_, 0, 4);
        byArray5 = ListUtilities.waitForListToComplete(this.system_, this.handle_, byArray5);
        this.length_ = BinaryConverter.byteArrayToInt(byArray5, 0);
        this.dataLength_ = BinaryConverter.byteArrayToInt(byArray5, 32);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded message queue message list, length: " + this.length_ + ", data length: " + this.dataLength_ + ", handle: ", this.handle_);
        }
    }

    public QueuedMessage receive(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving from message queue, message key:", byArray);
        }
        return this.receive(byArray, 0, REMOVE, ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedMessage receive(byte[] byArray, int n, String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray2;
        byte[] byArray3;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving from message queue, waitTime: " + n + ", messageAction: " + string + ", messageType: " + string2 + ", message key:", byArray);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'messageAction' is null.");
            throw new NullPointerException("messageAction");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageType' is null.");
            throw new NullPointerException("messageType");
        }
        if (string.equals(OLD)) {
            byArray3 = new byte[]{92, -42, -45, -60, 64, 64, 64, 64, 64, 64};
        } else if (string.equals(REMOVE)) {
            byArray3 = new byte[]{92, -39, -59, -44, -42, -27, -59, 64, 64, 64};
        } else if (string.equals(SAME)) {
            byArray3 = new byte[]{92, -30, -63, -44, -59, 64, 64, 64, 64, 64};
        } else {
            Trace.log(2, "Value of parameter 'messageAction' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("messageAction (" + string + ")", 2);
        }
        if (string2.equals(ANY)) {
            byArray2 = new byte[]{92, -63, -43, -24, 64, 64, 64, 64, 64, 64};
        } else if (string2.equals(COMPLETION)) {
            byArray2 = new byte[]{92, -61, -42, -44, -41, 64, 64, 64, 64, 64};
        } else if (string2.equals(COPY)) {
            byArray2 = new byte[]{92, -61, -42, -41, -24, 64, 64, 64, 64, 64};
        } else if (string2.equals(DIAGNOSTIC)) {
            byArray2 = new byte[]{92, -60, -55, -63, -57, 64, 64, 64, 64, 64};
        } else if (string2.equals(FIRST)) {
            byArray2 = new byte[]{92, -58, -55, -39, -30, -29, 64, 64, 64, 64};
        } else if (string2.equals(INFORMATIONAL)) {
            byArray2 = new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64};
        } else if (string2.equals(INQUIRY)) {
            byArray2 = new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64};
        } else if (string2.equals(LAST)) {
            byArray2 = new byte[]{92, -45, -63, -30, -29, 64, 64, 64, 64, 64};
        } else if (string2.equals(NEXT)) {
            byArray2 = new byte[]{92, -43, -59, -25, -29, 64, 64, 64, 64, 64};
        } else if (string2.equals(PREVIOUS)) {
            byArray2 = new byte[]{92, -41, -39, -27, 64, 64, 64, 64, 64, 64};
        } else if (string2.equals(REPLY)) {
            byArray2 = new byte[]{92, -39, -41, -24, 64, 64, 64, 64, 64, 64};
        } else {
            Trace.log(2, "Value of parameter 'messageType' is not valid: " + string2);
            throw new ExtendedIllegalArgumentException("messageType (" + string2 + ")", 2);
        }
        if (byArray == null && (string2.equals(COPY) || string2.equals(NEXT) || string2.equals(PREVIOUS))) {
            Trace.log(2, "Value of parameter 'messageType' is not valid when messageKey is not specified: " + string2);
            throw new ExtendedIllegalArgumentException("messageType (" + string2 + ")", 2);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (byArray == null) {
            byArray = BLANK_KEY;
        }
        this.resolveQualifiedMessageQueueName();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(5120), new ProgramParameter(new byte[]{0, 0, 20, 0}), new ProgramParameter(new byte[]{-39, -61, -27, -44, -16, -14, -16, -16}), new ProgramParameter(this.qualifiedMessageQueueName_), new ProgramParameter(byArray2), new ProgramParameter(byArray), new ProgramParameter(BinaryConverter.intToByteArray(n)), new ProgramParameter(byArray3), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QMHRCVM.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray4 = programParameterArray[0].getOutputData();
        int n2 = BinaryConverter.byteArrayToInt(byArray4, 0);
        int n3 = BinaryConverter.byteArrayToInt(byArray4, 4);
        if (n2 == 8 && n3 == 0) {
            return null;
        }
        if (Trace.traceOn_ && n2 < n3) {
            Trace.log(4, "Possible truncation receiving from message queue, bytes returned: " + n2 + ", bytesAvailable:", n3);
        }
        this.resolveConverter();
        int n4 = BinaryConverter.byteArrayToInt(byArray4, 8);
        String string3 = this.conv_.byteArrayToString(byArray4, 12, 7).trim();
        int n5 = (byArray4[19] & 0xF) * 10 + (byArray4[20] & 0xF);
        byte[] byArray5 = new byte[4];
        System.arraycopy(byArray4, 21, byArray5, 0, 4);
        String string4 = this.conv_.byteArrayToString(byArray4, 25, 10).trim();
        String string5 = this.conv_.byteArrayToString(byArray4, 45, 10).trim();
        String string6 = this.conv_.byteArrayToString(byArray4, 55, 10).trim();
        String string7 = this.conv_.byteArrayToString(byArray4, 65, 10).trim();
        String string8 = this.conv_.byteArrayToString(byArray4, 75, 6);
        String string9 = this.conv_.byteArrayToString(byArray4, 81, 12).trim();
        String string10 = this.conv_.byteArrayToString(byArray4, 97, 7);
        String string11 = this.conv_.byteArrayToString(byArray4, 104, 6);
        String string12 = this.conv_.byteArrayToString(byArray4, 135, 9).trim();
        int n6 = BinaryConverter.byteArrayToInt(byArray4, 152);
        int n7 = BinaryConverter.byteArrayToInt(byArray4, 160);
        int n8 = BinaryConverter.byteArrayToInt(byArray4, 168);
        byte[] byArray6 = new byte[n6];
        System.arraycopy(byArray4, 176, byArray6, 0, n6);
        String string13 = n7 != 0 ? this.conv_.byteArrayToString(byArray4, 176 + n6, n7) : this.conv_.byteArrayToString(byArray6, 0, n6, 0);
        String string14 = n8 != 0 ? this.conv_.byteArrayToString(byArray4, 176 + n6 + n7, n8) : null;
        QueuedMessage queuedMessage = new QueuedMessage(this, n4, string3, n5, byArray5, string4, string5, string6, string7, string8, string9, string10, string11, byArray6, string13, string14, string12);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        return queuedMessage;
    }

    public void remove() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.removeMessages(new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64}, BLANK_KEY);
    }

    public void remove(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null) {
            Trace.log(2, "Parameter 'messageKey' is null.");
            throw new NullPointerException("messageKey");
        }
        this.removeMessages(new byte[]{92, -62, -24, -46, -59, -24, 64, 64, 64, 64}, byArray);
    }

    public void remove(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray;
        if (string == null) {
            Trace.log(2, "Parameter 'messageType' is null.");
            throw new NullPointerException("messageType");
        }
        if (string.equals(ALL)) {
            byArray = new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64};
        } else if (string.equals(KEEP_UNANSWERED)) {
            byArray = new byte[]{92, -46, -59, -59, -41, -28, -43, -63, -43, -30};
        } else if (string.equals(NEW)) {
            byArray = new byte[]{92, -43, -59, -26, 64, 64, 64, 64, 64, 64};
        } else if (string.equals(OLD)) {
            byArray = new byte[]{92, -42, -45, -60, 64, 64, 64, 64, 64, 64};
        } else {
            Trace.log(2, "Value of parameter 'messageType' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("messageType (" + string + ")", 2);
        }
        this.removeMessages(byArray, BLANK_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessages(byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.resolveQualifiedMessageQueueName();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(this.qualifiedMessageQueueName_), new ProgramParameter(byArray2), new ProgramParameter(byArray), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QMHRMVM.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    private synchronized void resolveConverter() throws IOException {
        if (this.conv_ == null) {
            this.conv_ = new Converter(this.system_.getCcsid(), this.system_);
        }
    }

    private synchronized void resolveQualifiedMessageQueueName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.qualifiedMessageQueueName_ != null) {
            return;
        }
        this.resolveConverter();
        this.qualifiedMessageQueueName_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (this.path_.equals(CURRENT)) {
            User user = new User(this.system_, this.system_.getUserId());
            user.loadUserInformation();
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(user.getMessageQueue());
            this.conv_.stringToByteArray(qSYSObjectPathName.getObjectName(), this.qualifiedMessageQueueName_, 0);
            this.conv_.stringToByteArray(qSYSObjectPathName.getLibraryName(), this.qualifiedMessageQueueName_, 10);
        } else {
            this.conv_.stringToByteArray(this.name_, this.qualifiedMessageQueueName_, 0);
            this.conv_.stringToByteArray(this.library_, this.qualifiedMessageQueueName_, 10);
        }
    }

    public void reply(byte[] byArray, String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.reply(byArray, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(byte[] byArray, String string, boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray2;
        if (byArray == null) {
            Trace.log(2, "Parameter 'messageKey' is null.");
            throw new NullPointerException("messageKey");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'replyText' is null.");
            throw new NullPointerException("replyText");
        }
        this.resolveConverter();
        byte[] byArray3 = this.conv_.stringToByteArray(string);
        if (bl) {
            byte[] byArray4 = new byte[10];
            byArray4[0] = 92;
            byArray4[1] = -24;
            byArray4[2] = -59;
            byArray4[3] = -30;
            byArray4[4] = 64;
            byArray4[5] = 64;
            byArray4[6] = 64;
            byArray4[7] = 64;
            byArray4[8] = 64;
            byArray2 = byArray4;
            byArray4[9] = 64;
        } else {
            byte[] byArray5 = new byte[10];
            byArray5[0] = 92;
            byArray5[1] = -43;
            byArray5[2] = -42;
            byArray5[3] = 64;
            byArray5[4] = 64;
            byArray5[5] = 64;
            byArray5[6] = 64;
            byArray5[7] = 64;
            byArray5[8] = 64;
            byArray2 = byArray5;
            byArray5[9] = 64;
        }
        byte[] byArray6 = byArray2;
        this.resolveQualifiedMessageQueueName();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray), new ProgramParameter(this.qualifiedMessageQueueName_), new ProgramParameter(byArray3), new ProgramParameter(BinaryConverter.intToByteArray(byArray3.length)), new ProgramParameter(byArray6), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QMHSNDRM.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] send(String string, String string2, byte[] byArray, byte[] byArray2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall programCall;
        ProgramParameter[] programParameterArray;
        Object object;
        Object object2;
        this.resolveConverter();
        byte[] byArray3 = new byte[]{64, 64, 64, 64, 64, 64, 64};
        if (string != null) {
            this.conv_.stringToByteArray(string, byArray3, 0, 7);
        }
        byte[] byArray4 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (string2 != null) {
            object2 = new QSYSObjectPathName(string2, "MSGF");
            this.conv_.stringToByteArray(((QSYSObjectPathName)object2).getObjectName(), byArray4, 0);
            this.conv_.stringToByteArray(((QSYSObjectPathName)object2).getLibraryName(), byArray4, 10);
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        object2 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (this.path_.equals(CURRENT)) {
            this.conv_.stringToByteArray(this.system_.getUserId(), (byte[])object2, 0);
            System.arraycopy(new byte[]{92, -28, -30, -59, -39}, 0, object2, 10, 5);
        } else {
            object = new QSYSObjectPathName(this.path_);
            this.conv_.stringToByteArray(((QSYSObjectPathName)object).getObjectName(), (byte[])object2, 0);
            this.conv_.stringToByteArray(((QSYSObjectPathName)object).getLibraryName(), (byte[])object2, 10);
        }
        object = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        if (string3 != null) {
            programParameterArray = new QSYSObjectPathName(string3, "MSGQ");
            this.conv_.stringToByteArray(programParameterArray.getObjectName(), (byte[])object, 0);
            this.conv_.stringToByteArray(programParameterArray.getLibraryName(), (byte[])object, 10);
        }
        if (!(programCall = new ProgramCall(this.system_, "/QSYS.LIB/QMHSNDM.PGM", programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray3), new ProgramParameter(byArray4), new ProgramParameter(byArray), new ProgramParameter(BinaryConverter.intToByteArray(byArray.length)), new ProgramParameter(byArray2), new ProgramParameter((byte[])object2), new ProgramParameter(new byte[]{0, 0, 0, 1}), new ProgramParameter((byte[])object), new ProgramParameter(4), new ErrorCodeParameter()})).run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        return programParameterArray[8].getOutputData();
    }

    public void sendInformational(String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        this.send(string, string2, null, new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64}, null);
    }

    public void sendInformational(String string, String string2, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        this.send(string, string2, byArray, new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64}, null);
    }

    public void sendInformational(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageText' is null.");
            throw new NullPointerException("messageText");
        }
        this.resolveConverter();
        this.send(null, null, this.conv_.stringToByteArray(string), new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64}, null);
    }

    public byte[] sendInquiry(String string, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'replyMessageQueue' is null.");
            throw new NullPointerException("replyMessageQueue");
        }
        return this.send(string, string2, null, new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64}, string3);
    }

    public byte[] sendInquiry(String string, String string2, byte[] byArray, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'replyMessageQueue' is null.");
            throw new NullPointerException("replyMessageQueue");
        }
        return this.send(string, string2, byArray, new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64}, string3);
    }

    public byte[] sendInquiry(String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageText' is null.");
            throw new NullPointerException("messageText");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'replyMessageQueue' is null.");
            throw new NullPointerException("replyMessageQueue");
        }
        this.resolveConverter();
        return this.send(null, null, this.conv_.stringToByteArray(string), new byte[]{92, -55, -43, -40, 64, 64, 64, 64, 64, 64}, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHelpTextFormatting(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting help text formatting:", n);
        }
        if (n < 0 || n > 2) {
            Trace.log(2, "Value of parameter 'helpTextFormatting' is not valid: " + n);
            throw new ExtendedIllegalArgumentException("helpTextFormatting (" + n + ")", 2);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.helpTextFormatting_ = n;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListDirection(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list direction:", bl);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.listDirection_ = bl;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSort(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting sort:", bl);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.sort_ = bl;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting path: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                if (!string.equals(CURRENT)) {
                    QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "MSGQ");
                    this.library_ = qSYSObjectPathName.getLibraryName();
                    this.name_ = qSYSObjectPathName.getObjectName();
                }
                this.path_ = string;
                this.qualifiedMessageQueueName_ = null;
            }
        }
        String string2 = this.path_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("path", string2, string3);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (!string.equals(CURRENT)) {
                QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "MSGQ");
                this.library_ = qSYSObjectPathName.getLibraryName();
                this.name_ = qSYSObjectPathName.getObjectName();
            }
            this.path_ = string;
            this.qualifiedMessageQueueName_ = null;
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("path", string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectMessagesNeedReply(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting messages that need a reply are selected:", bl);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selectMessagesNeedReply_ = bl;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectMessagesNoNeedReply(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting messages that do not need a reply are selected:", bl);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selectMessagesNoNeedReply_ = bl;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectSendersCopyMessagesNeedReply(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting sender's copy messages that need a reply are selected:", bl);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selectSendersCopyMessagesNeedReply_ = bl;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting selection: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'selection' is null.");
            throw new NullPointerException("selection");
        }
        if (!(string.equals(ALL) || string.equals(MESSAGES_NEED_REPLY) || string.equals(MESSAGES_NO_NEED_REPLY) || string.equals(SENDERS_COPY_NEED_REPLY))) {
            Trace.log(2, "Value of parameter 'selection' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("selection (" + string + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                this.selection_ = string;
                boolean bl = string.equals(ALL);
                this.selectMessagesNeedReply_ = bl || string.equals(MESSAGES_NEED_REPLY);
                this.selectMessagesNoNeedReply_ = bl || string.equals(MESSAGES_NO_NEED_REPLY);
                boolean bl2 = this.selectSendersCopyMessagesNeedReply_ = bl || string.equals(SENDERS_COPY_NEED_REPLY);
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.selection_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("selection", string2, string3);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.selection_ = string;
            boolean bl = string.equals(ALL);
            this.selectMessagesNeedReply_ = bl || string.equals(MESSAGES_NEED_REPLY);
            this.selectMessagesNoNeedReply_ = bl || string.equals(MESSAGES_NO_NEED_REPLY);
            boolean bl3 = this.selectSendersCopyMessagesNeedReply_ = bl || string.equals(SENDERS_COPY_NEED_REPLY);
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("selection", string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeverity(int n) throws PropertyVetoException {
        Serializable serializable;
        if (n < 0 || n > 99) {
            Trace.log(2, "Value of parameter 'severity' is not valid: " + n);
            throw new ExtendedIllegalArgumentException("severity (" + n + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.severity_ = n;
        } else {
            serializable = new Integer(this.severity_);
            Integer n2 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("severity", serializable, n2);
            }
            this.severity_ = n;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("severity", serializable, n2);
            }
        }
        serializable = this;
        synchronized (serializable) {
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                this.system_ = aS400;
                this.conv_ = null;
                this.qualifiedMessageQueueName_ = null;
            }
        }
        AS400 aS4002 = this.system_;
        AS400 aS4003 = aS400;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.system_ = aS400;
            this.conv_ = null;
            this.qualifiedMessageQueueName_ = null;
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserStartingMessageKey(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user starting message key:", byArray);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.userStartingMessageKey_ = byArray;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkstationStartingMessageKey(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting workstation starting message key:", byArray);
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.workstationStartingMessageKey_ = byArray;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }
}

