/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NLSExchangeAttrReply;
import com.ibm.as400.access.NLSExchangeAttrRequest;
import com.ibm.as400.access.NLSImpl;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.net.UnknownHostException;

class NLSImplRemote
extends NLSImpl {
    private AS400Server server_;
    private int ccsid_;

    NLSImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void connect() throws ServerStartupException, UnknownHostException, AS400SecurityException, ConnectionDroppedException, InterruptedException, IOException {
        if (this.server_ == null) {
            AS400Server aS400Server = this.server_ = this.system_.getConnection(6, false, false);
            synchronized (aS400Server) {
                DataStream dataStream = this.server_.getExchangeAttrReply();
                if (dataStream == null) {
                    try {
                        dataStream = this.server_.sendExchangeAttrRequest(new NLSExchangeAttrRequest());
                    }
                    catch (IOException iOException) {
                        Trace.log(2, "IOException After Exchange Attribute Request");
                        this.disconnect();
                        throw iOException;
                    }
                    if (dataStream instanceof NLSExchangeAttrReply) {
                        NLSExchangeAttrReply nLSExchangeAttrReply = (NLSExchangeAttrReply)dataStream;
                        if (nLSExchangeAttrReply.primaryRC_ != 0) {
                            Trace.log(4, "Exchange attribute failed, primary return code =", nLSExchangeAttrReply.primaryRC_);
                            Trace.log(2, "Exchange attribute failed, secondary return code =", nLSExchangeAttrReply.getSecondaryRC_());
                            this.disconnect();
                            throw new IOException();
                        }
                        this.ccsid_ = nLSExchangeAttrReply.getCcsid();
                    } else {
                        Trace.log(2, "Unknown instance returned from Exchange Attribute Reply");
                        throw new InternalErrorException(2);
                    }
                }
            }
        }
    }

    @Override
    void disconnect() {
        if (this.server_ != null) {
            try {
                this.system_.disconnectServer(this.server_);
                this.server_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    int getCcsid() throws IOException {
        return this.ccsid_;
    }

    static {
        AS400Server.addReplyStream((DataStream)new NLSExchangeAttrReply(), 6);
    }
}

