/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPAttrBin4;
import com.ibm.as400.access.NPAttrFloat;
import com.ibm.as400.access.NPAttrString;
import com.ibm.as400.access.NPAttribute;
import com.ibm.as400.access.NPAttributeIFS;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class NPCPAttributeValue
extends NPCodePoint {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Hashtable attrTable_;
    private boolean fDataOutOfDate_;
    private boolean fListOutOfDate_;
    static final String emptyString = "";
    private static final int LEN_ATTR_HEADER = 4;
    private static final int LEN_ATTR_ENTRY = 12;

    NPCPAttributeValue(NPCPAttributeValue nPCPAttributeValue) {
        super(nPCPAttributeValue);
        this.fDataOutOfDate_ = nPCPAttributeValue.fDataOutOfDate_;
        this.fListOutOfDate_ = nPCPAttributeValue.fListOutOfDate_;
        this.attrTable_ = new Hashtable(41);
        if (this.fDataOutOfDate_) {
            Enumeration enumeration = nPCPAttributeValue.attrTable_.elements();
            while (enumeration.hasMoreElements()) {
                NPAttribute nPAttribute = (NPAttribute)enumeration.nextElement();
                if (nPAttribute == null) continue;
                try {
                    this.attrTable_.put(new Integer(nPAttribute.getID()), nPAttribute.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    Trace.log(2, " NPCPAttribributeValue: Error cloning new attribute" + cloneNotSupportedException);
                    throw new InternalErrorException(cloneNotSupportedException.toString(), 6);
                }
            }
        } else {
            this.fListOutOfDate_ = true;
        }
    }

    NPCPAttributeValue(int n) {
        super(n);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = false;
        this.attrTable_ = new Hashtable(41);
    }

    NPCPAttributeValue(int n, byte[] byArray) {
        super(n, byArray);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = true;
        this.attrTable_ = new Hashtable(41);
    }

    @Override
    int getLength() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getLength();
    }

    boolean getfListOutOfDate() {
        return this.fListOutOfDate_;
    }

    @Override
    void setDataBuffer(byte[] byArray, int n, int n2) {
        this.fListOutOfDate_ = true;
        this.fDataOutOfDate_ = false;
        super.setDataBuffer(byArray, n, n2);
    }

    @Override
    byte[] getDataBuffer() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getDataBuffer();
    }

    @Override
    byte[] getDataBuffer(int n) {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        this.fListOutOfDate_ = true;
        return super.getDataBuffer(n);
    }

    @Override
    void reset() {
        this.zeroAttrTable();
        this.fListOutOfDate_ = false;
        this.fDataOutOfDate_ = false;
        super.reset();
    }

    void setAttrValue(int n, String string) {
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (n < 0) {
            NPAttributeIFS nPAttributeIFS = NPAttributeIFS.ifsAttrs[Math.abs(n) - 1];
            if (string.startsWith("*")) {
                this.attrTable_.put(new Integer(nPAttributeIFS.nameID_), new NPAttrString(nPAttributeIFS.nameID_, string));
            } else {
                QSYSObjectPathName qSYSObjectPathName = null;
                qSYSObjectPathName = nPAttributeIFS.typeID_ != 0 ? new QSYSObjectPathName(string) : new QSYSObjectPathName(string, nPAttributeIFS.typeString_);
                this.attrTable_.put(new Integer(nPAttributeIFS.nameID_), new NPAttrString(nPAttributeIFS.nameID_, qSYSObjectPathName.getObjectName()));
                this.attrTable_.put(new Integer(nPAttributeIFS.libraryID_), new NPAttrString(nPAttributeIFS.libraryID_, qSYSObjectPathName.getLibraryName()));
                if (nPAttributeIFS.typeID_ != 0) {
                    Object object = "*";
                    object = (String)object + qSYSObjectPathName.getObjectType();
                    this.attrTable_.put(new Integer(nPAttributeIFS.typeID_), new NPAttrString(nPAttributeIFS.typeID_, (String)object));
                }
            }
        } else {
            this.attrTable_.put(new Integer(n), new NPAttrString(n, string));
        }
        this.fDataOutOfDate_ = true;
    }

    String getStringValue(int n) {
        boolean bl = false;
        String string = null;
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (n < 0) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            NPAttributeIFS nPAttributeIFS = NPAttributeIFS.ifsAttrs[Math.abs(n) - 1];
            Object v = this.attrTable_.get(new Integer(nPAttributeIFS.nameID_));
            if (v != null) {
                string2 = ((NPAttrString)v).get();
            }
            if (string2 != null && (v = this.attrTable_.get(new Integer(nPAttributeIFS.libraryID_))) != null && 0 == (string3 = ((NPAttrString)v).get()).compareTo(emptyString)) {
                string3 = "          ";
            }
            if (nPAttributeIFS.typeID_ != 0) {
                v = this.attrTable_.get(new Integer(nPAttributeIFS.typeID_));
                if (v != null && (string4 = ((NPAttrString)v).get()) != null && string4.startsWith("*")) {
                    string4 = string4.substring(1, string4.length());
                }
            } else {
                string4 = nPAttributeIFS.typeString_;
            }
            if (string2 != null) {
                string = string2.startsWith("*") ? string2 : QSYSObjectPathName.toPath(string3, string2, string4);
            }
        } else {
            Object v = this.attrTable_.get(new Integer(n));
            if (v != null) {
                if (v instanceof NPAttrString) {
                    NPAttrString nPAttrString = (NPAttrString)v;
                    string = nPAttrString.get();
                } else {
                    throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 7);
                }
            }
        }
        return string;
    }

    void setAttrValue(int n, int n2) {
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        this.attrTable_.put(new Integer(n), new NPAttrBin4(n, n2));
        this.fDataOutOfDate_ = true;
    }

    Integer getIntValue(int n) {
        Object v;
        boolean bl = false;
        Integer n2 = null;
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if ((v = this.attrTable_.get(new Integer(n))) != null) {
            if (v instanceof NPAttrBin4) {
                NPAttrBin4 nPAttrBin4 = (NPAttrBin4)v;
                n2 = new Integer(nPAttrBin4.get());
            } else {
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 7);
            }
        }
        return n2;
    }

    void setAttrValue(int n, float f) {
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        this.attrTable_.put(new Integer(n), new NPAttrFloat(n, f));
        this.fDataOutOfDate_ = true;
    }

    Float getFloatValue(int n) {
        Object v;
        boolean bl = false;
        Float f = null;
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if ((v = this.attrTable_.get(new Integer(n))) != null) {
            if (v instanceof NPAttrFloat) {
                NPAttrFloat nPAttrFloat = (NPAttrFloat)v;
                f = new Float(nPAttrFloat.get());
            } else {
                throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 7);
            }
        }
        return f;
    }

    void addUpdateAttributes(NPCPAttributeValue nPCPAttributeValue) {
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (nPCPAttributeValue.fListOutOfDate_) {
            nPCPAttributeValue.updateList();
        }
        Enumeration enumeration = nPCPAttributeValue.attrTable_.elements();
        while (enumeration.hasMoreElements()) {
            NPAttribute nPAttribute = (NPAttribute)enumeration.nextElement();
            if (nPAttribute == null) continue;
            this.attrTable_.put(new Integer(nPAttribute.getID()), nPAttribute);
        }
        this.fDataOutOfDate_ = true;
    }

    void removeAttribute(int n) {
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (n < 0) {
            NPAttributeIFS nPAttributeIFS = NPAttributeIFS.ifsAttrs[Math.abs(n) - 1];
            this.attrTable_.remove(new Integer(nPAttributeIFS.nameID_));
            this.attrTable_.remove(new Integer(nPAttributeIFS.libraryID_));
            if (nPAttributeIFS.typeID_ != 0) {
                this.attrTable_.remove(new Integer(nPAttributeIFS.typeID_));
            }
        } else {
            this.attrTable_.remove(new Integer(n));
        }
    }

    private void updateData() {
        NPAttribute nPAttribute;
        int n = 0;
        int n2 = 4;
        Enumeration enumeration = this.attrTable_.elements();
        while (enumeration.hasMoreElements()) {
            nPAttribute = (NPAttribute)enumeration.nextElement();
            if (nPAttribute == null) continue;
            n2 += 12;
            n2 += nPAttribute.getHostLength(this.converter_);
            ++n;
        }
        byte[] byArray = super.getDataBuffer(n2);
        int n3 = super.getOffset();
        BinaryConverter.unsignedShortToByteArray(n, byArray, n3);
        BinaryConverter.unsignedShortToByteArray(12, byArray, n3 += 2);
        int n4 = (n3 += 2) + 12 * n;
        enumeration = this.attrTable_.elements();
        while (enumeration.hasMoreElements() && n != 0) {
            nPAttribute = (NPAttribute)enumeration.nextElement();
            if (nPAttribute == null) continue;
            BinaryConverter.unsignedShortToByteArray(nPAttribute.getID(), byArray, n3);
            BinaryConverter.unsignedShortToByteArray(nPAttribute.getType(), byArray, n3 += 2);
            BinaryConverter.intToByteArray(nPAttribute.getHostLength(this.converter_), byArray, n3 += 2);
            BinaryConverter.intToByteArray(n4 + 6, byArray, n3 += 4);
            n3 += 4;
            System.arraycopy(nPAttribute.getHostData(this.converter_), 0, byArray, n4, nPAttribute.getHostLength(this.converter_));
            n4 += nPAttribute.getHostLength(this.converter_);
            --n;
        }
        this.fDataOutOfDate_ = false;
    }

    private void updateList() {
        byte by = 0;
        NPAttribute nPAttribute = null;
        this.zeroAttrTable();
        byte[] byArray = super.getDataBuffer();
        if (byArray != null && byArray.length >= 4) {
            long l = super.getDataLength();
            int n = super.getOffset();
            if (l > 4L) {
                short s;
                int n2 = BinaryConverter.byteArrayToShort(byArray, n);
                n += 2;
                if (n2 != 0 && (s = BinaryConverter.byteArrayToShort(byArray, n)) >= 12 && l >= (long)((n += 2) + n2 * s)) {
                    while (n2 != 0) {
                        short s2 = BinaryConverter.byteArrayToShort(byArray, n);
                        short s3 = BinaryConverter.byteArrayToShort(byArray, n += 2);
                        int n3 = BinaryConverter.byteArrayToInt(byArray, n += 2);
                        int n4 = BinaryConverter.byteArrayToInt(byArray, n += 4);
                        n += 4;
                        n4 -= 6;
                        switch (s3) {
                            case 3: 
                            case 4: {
                                nPAttribute = new NPAttrBin4(s2, byArray, n4, n3);
                                break;
                            }
                            case 5: 
                            case 6: {
                                nPAttribute = new NPAttrString(s2, byArray, n4, n3, this.converter_);
                                break;
                            }
                            case 7: {
                                nPAttribute = new NPAttrFloat(s2, byArray, n4, n3);
                                break;
                            }
                            case 9: {
                                for (int i = 0; i < n3; ++i) {
                                    if (byArray[i + n4] != by || i >= n3 - 1 || byArray[i + n4 + 1] == by) continue;
                                    byArray[i + n4] = 122;
                                }
                                nPAttribute = new NPAttrString(s2, byArray, n4, n3, this.converter_);
                                break;
                            }
                        }
                        this.attrTable_.put(new Integer(s2), nPAttribute);
                        --n2;
                        n += s - 12;
                    }
                }
            }
        }
        this.fListOutOfDate_ = false;
    }

    private void zeroAttrTable() {
        this.attrTable_.clear();
    }
}

