/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;

class NPCPSelRes
extends NPCPSelection
implements Cloneable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int FNTRSC = 1;
    static final int FORMDF = 2;
    static final int OVL = 4;
    static final int PAGSEG = 8;
    static final int PAGDFN = 16;
    static final int ALLRSC = 31;
    static final String STR_ALL = "%ALL%";
    static final String STR_UNKNOWN = "UNKNOWN";
    static final String PEL240 = "1";
    static final String PEL300 = "2";

    NPCPSelRes(NPCPSelRes nPCPSelRes) {
        super(nPCPSelRes);
    }

    NPCPSelRes() {
    }

    @Override
    protected Object clone() {
        NPCPSelRes nPCPSelRes = new NPCPSelRes(this);
        return nPCPSelRes;
    }

    String getPelDensity() {
        String string = this.getStringValue(178);
        if (string == null) {
            return "";
        }
        return string;
    }

    String getResource() {
        String string = this.getStringValue(175);
        if (string == null) {
            return "";
        }
        String string2 = this.getStringValue(174);
        if (string2 == null) {
            return "";
        }
        String string3 = null;
        Integer n = this.getIntValue(176);
        string3 = n == null ? STR_ALL : NPCPSelRes.intTypeToStringType(n);
        return QSYSObjectPathName.toPath(string2, string, string3);
    }

    static String intTypeToStringType(int n) {
        switch (n) {
            case 8: {
                return "PAGSEG";
            }
            case 4: {
                return "OVL";
            }
            case 1: {
                return "FNTRSC";
            }
            case 2: {
                return "FORMDF";
            }
            case 16: {
                return "PAGDFN";
            }
        }
        return STR_UNKNOWN;
    }

    void setResource(String string) {
        if (string.length() == 0) {
            this.removeAttribute(-12);
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
            String string2 = qSYSObjectPathName.getObjectName();
            String string3 = qSYSObjectPathName.getLibraryName();
            String string4 = qSYSObjectPathName.getObjectType();
            if (string4.equals(STR_ALL)) {
                this.setResourceType(31);
            } else {
                try {
                    this.setResourceType(NPCPSelRes.stringTypeToIntType(string4));
                }
                catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
                    Trace.log(2, "Parameter 'resource' has a invalid object type.");
                    throw new IllegalPathNameException(string, 1);
                }
            }
            this.setAttrValue(174, string3);
            this.setAttrValue(175, string2);
        }
    }

    void setResourceType(int n) {
        this.setAttrValue(176, n);
    }

    void setPelDensity(String string) {
        if (string.length() == 0) {
            this.removeAttribute(178);
        } else {
            this.setAttrValue(178, string);
        }
    }

    static int stringTypeToIntType(String string) {
        int n = 0;
        if (string.equals("PAGSEG")) {
            n = 8;
        } else if (string.equals("OVL")) {
            n = 4;
        } else if (string.equals("FNTRSC")) {
            n = 1;
        } else if (string.equals("FORMDF")) {
            n = 2;
        } else if (string.equals("PAGDFN")) {
            n = 16;
        } else {
            Trace.log(2, "Parameter 'resourceType' has a invalid object type.");
            throw new ExtendedIllegalArgumentException("resourceType (" + string + ")", 2);
        }
        return n;
    }
}

