/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class NPDataStream
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final int NP_SERVER_ID = 57347;
    static final int TEMPLATE_LENGTH = 12;
    static final int ACTION_ID_OFFSET = 20;
    static final int FLAGS_OFFSET = 22;
    static final int RC_OFFSET = 26;
    static final int EO_OFFSET = 28;
    static final int LAST_REPLY_MASK = Integer.MIN_VALUE;
    static final int CODE_POINT_OFFSET = 32;
    static final int CREATE = 1;
    static final int OPEN = 2;
    static final int READ = 3;
    static final int WRITE = 4;
    static final int CLOSE = 5;
    static final int HOLD = 6;
    static final int RELEASE = 7;
    static final int START = 8;
    static final int END = 9;
    static final int DELETE = 10;
    static final int MOVE = 11;
    static final int SEND = 12;
    static final int CALL_EXIT_PROGRAM = 13;
    static final int CHANGE_ATTRIBUTES = 14;
    static final int RETRIEVE_ATTRIBUTES = 15;
    static final int RETRIEVE_ATTRIBUTE_INFO = 16;
    static final int RETRIEVE_MESSAGE = 17;
    static final int ANSWER_MESSAGE = 18;
    static final int WATCH = 19;
    static final int CHECK_AUTHORITY = 20;
    static final int PURGE = 21;
    static final int LIST = 22;
    static final int SEEK = 23;
    static final int TELL = 24;
    static final int SELECT_PAGE = 25;
    static final int OPEN_MODIFIED_SPLF = 26;
    static final int COPY = 27;
    static final int RET_OK = 0;
    static final int RET_INV_REQ_STRUCT = 1;
    static final int RET_INV_REQ_ID = 2;
    static final int RET_INV_ACT_ID = 3;
    static final int RET_INV_REQ_ACT = 4;
    static final int RET_INV_CODEPOINT = 5;
    static final int RET_INV_ATTR = 6;
    static final int RET_INV_ATTRVALUE = 7;
    static final int RET_NOT_AUTHORIZED = 8;
    static final int RET_CPF_MESSAGE = 9;
    static final int RET_INV_SPLF_HANDLE = 10;
    static final int RET_SPLF_CREATE_ERR = 11;
    static final int RET_CL_ERROR = 12;
    static final int RET_SPLF_NOT_OPEN = 13;
    static final int RET_SPLF_NO_MESSAGE = 14;
    static final int RET_SPLF_OPEN_FAILED = 15;
    static final int RET_SEEK_OFF_BAD = 16;
    static final int RET_SEEK_FAILED = 17;
    static final int RET_READ_INCOMPLETE = 18;
    static final int RET_READ_EOF = 19;
    static final int RET_EMPTY_LIST = 20;
    static final int RET_FUNCTION_NOT_SUP = 21;
    static final int RET_CANNOT_ACC_PRTF = 22;
    static final int RET_CANNOT_ACC_PRTF_ATTR = 23;
    static final int RET_WRITER_NOT_FOUND = 24;
    static final int RET_RETURN_CP_MISSING = 25;
    static final int RET_NO_EXIT_PGM = 26;
    static final int RET_EXIT_PGM_DENIED = 27;
    static final int RET_NLV_NOT_AVAILABLE = 28;
    static final int RET_INV_BYTE_COUNT = 29;
    static final int RET_SPLF_NOT_FOUND = 30;
    static final int RET_INV_DATA_TYPE = 31;
    static final int RET_READ_OUT_OF_RANGE = 32;
    static final int RET_PAGE_OUT_OF_RANGE = 33;
    private int reqRepID_;
    private int correlation_;
    private int actionID_;
    private ConverterImpl converter_;
    private NPCodePoint[] codePoints_ = new NPCodePoint[17];

    NPDataStream(NPDataStream nPDataStream) {
        this.data_ = new byte[nPDataStream.data_.length];
        System.arraycopy(nPDataStream.data_, 0, this.data_, 0, this.data_.length);
        this.reqRepID_ = nPDataStream.reqRepID_;
        this.correlation_ = nPDataStream.correlation_;
        this.actionID_ = nPDataStream.actionID_;
        this.converter_ = nPDataStream.converter_;
        for (int i = 0; i < this.codePoints_.length; ++i) {
            if (nPDataStream.codePoints_[i] == null) continue;
            this.codePoints_[i] = (NPCodePoint)nPDataStream.codePoints_[i].clone();
        }
    }

    NPDataStream() {
        this.reqRepID_ = 0;
        this.correlation_ = 0;
        this.actionID_ = 0;
        this.converter_ = null;
    }

    NPDataStream(int n) {
        this.correlation_ = 0;
        this.actionID_ = 0;
        this.converter_ = null;
        this.setObject(n);
    }

    @Override
    public Object getNewDataStream() {
        return new NPDataStream(this);
    }

    @Override
    public int hashCode() {
        return this.reqRepID_ | 0x8000;
    }

    void setObject(int n) {
        this.reqRepID_ = n;
    }

    void setAction(int n) {
        this.actionID_ = n;
    }

    @Override
    protected void setCorrelation(int n) {
        this.correlation_ = n;
    }

    int getCorrelationID() {
        return this.correlation_;
    }

    void setConverter(ConverterImpl converterImpl) {
        this.converter_ = converterImpl;
        for (int i = 0; i < this.codePoints_.length; ++i) {
            NPCodePoint nPCodePoint = this.codePoints_[i];
            if (nPCodePoint == null) continue;
            nPCodePoint.setConverter(this.converter_);
        }
    }

    void addCodePoint(NPCodePoint nPCodePoint) {
        int n = nPCodePoint.getID();
        if (this.validCPID(n)) {
            this.codePoints_[n] = nPCodePoint;
        }
    }

    NPCodePoint getCodePoint(int n) {
        NPCodePoint nPCodePoint = null;
        if (this.validCPID(n)) {
            nPCodePoint = this.codePoints_[n];
        }
        return nPCodePoint;
    }

    void resetCodePoints() {
        for (int i = 0; i < this.codePoints_.length; ++i) {
            this.codePoints_[i] = null;
        }
    }

    int getReturnCode() {
        return this.get16bit(26);
    }

    boolean isLastReply() {
        return (this.get32bit(22) & Integer.MIN_VALUE) == 0;
    }

    @Override
    void write(OutputStream outputStream) throws IOException {
        int n;
        int n2 = 32;
        for (n = 0; n < this.codePoints_.length; ++n) {
            NPCodePoint nPCodePoint = this.codePoints_[n];
            if (nPCodePoint == null) continue;
            nPCodePoint.setConverter(this.converter_);
            if (nPCodePoint.getDataLength() == 0) continue;
            n2 += nPCodePoint.getLength();
        }
        this.data_ = new byte[n2];
        this.setLength(n2);
        this.setHeaderID(0);
        this.setServerID(57347);
        this.setCSInstance(0);
        super.setCorrelation(this.correlation_);
        this.setTemplateLen(12);
        this.setReqRepID(this.reqRepID_);
        this.set16bit(this.actionID_, 20);
        this.set32bit(0, 22);
        this.set16bit(0, 26);
        this.set32bit(0, 28);
        n = 32;
        for (int i = 0; i < this.codePoints_.length; ++i) {
            NPCodePoint nPCodePoint = this.codePoints_[i];
            if (nPCodePoint == null || nPCodePoint.getDataLength() == 0) continue;
            int n3 = nPCodePoint.getLength();
            this.set32bit(n3, n);
            this.set16bit(nPCodePoint.getID(), n + 4);
            byte[] byArray = nPCodePoint.getDataBuffer();
            int n4 = nPCodePoint.getOffset();
            System.arraycopy(byArray, n4, this.data_, n += 6, n3 -= 6);
            n += n3;
        }
        super.write(outputStream);
    }

    @Override
    protected int readAfterHeader(InputStream inputStream) throws IOException {
        int n = this.getLength() - 20;
        int n2 = this.readFromStream(inputStream, this.data_, 20, this.getTemplateLen());
        if (0 != this.getReturnCode()) {
            Trace.log(3, " Netprint Datastream Return code was " + this.getReturnCode());
        }
        byte[] byArray = new byte[6];
        byte[] byArray2 = null;
        NPCodePoint nPCodePoint = null;
        while (n2 < n) {
            int n3 = this.readFromStream(inputStream, byArray, 0, byArray.length);
            if (n3 != byArray.length) {
                Trace.log(2, "Didn't read 6 bytes that we needed to!");
                throw new IOException(Integer.toString(byArray.length));
            }
            n2 += n3;
            int n4 = BinaryConverter.byteArrayToInt(byArray, 0) - byArray.length;
            int n5 = BinaryConverter.byteArrayToUnsignedShort(byArray, 4);
            if (!this.validCPID(n5) || this.codePoints_[n5] == null) {
                Trace.log(2, "NPDataStream receiving orphan code point ID =" + n5);
                nPCodePoint = new NPCodePoint(n5);
                if (!this.validCPID(n5)) {
                    this.codePoints_[0] = nPCodePoint;
                } else {
                    this.codePoints_[n5] = nPCodePoint;
                }
            } else {
                nPCodePoint = this.codePoints_[n5];
            }
            nPCodePoint.setConverter(this.converter_);
            byArray2 = nPCodePoint.getDataBuffer(n4);
            int n6 = nPCodePoint.getOffset();
            n3 = this.readFromStream(inputStream, byArray2, n6, n4);
            if (n3 != n4) {
                Trace.log(2, "Didn't read " + n4 + " bytes that we needed!");
                throw new IOException(Integer.toString(n4));
            }
            n2 += n3;
        }
        return n2;
    }

    private boolean validCPID(int n) {
        return n > 0 && n < this.codePoints_.length;
    }
}

