/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NetServer;
import com.ibm.as400.access.NetServerFileShare;
import com.ibm.as400.access.NetServerSession;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ArrayResourceList;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Vector;

public class NetServerConnection
extends Resource {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.access.MRI2");
    private static final String ICON_BASE_NAME_ = "NetServerConnection";
    private static final String PRESENTATION_KEY_ = "NETSERVER";
    private static ResourceMetaDataTable attributes_ = new ResourceMetaDataTable(presentationLoader_, "NETSERVER");
    private static ProgramMap getterMap_ = new ProgramMap();
    private static ProgramMap openListAttributeMap_ = new ProgramMap();
    static final int SHARE = 0;
    static final int SESSION = 1;
    private static final String OLST0600_ = "qzlsolst_zlsl0600";
    private static final String OLST0700_ = "qzlsolst_zlsl0700";
    private static final int[] INDICES_ = new int[]{0};
    public static final String CONNECT_TIME = "CONNECT_TIME";
    public static final String FILES_OPEN_COUNT = "FILES_OPEN_COUNT";
    public static final String NAME = "NAME";
    public static final String TYPE = "TYPE";
    public static final Integer TYPE_DISK_DRIVE;
    public static final Integer TYPE_SPOOLED_OUTPUT_QUEUE;
    public static final String USER = "USER";
    static final String USER_COUNT = "USER_COUNT";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.access.NetServer";
    private static ProgramCallDocument staticDocument_;
    private ProgramCallDocument document_;
    private int id_;
    private boolean idWasSet_ = false;
    private ProgramAttributeGetter attributeGetter_;

    NetServerConnection() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), null, attributes_);
    }

    NetServerConnection(AS400 aS400, int n) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setID(n);
    }

    static Object computeResourceKey(AS400 aS400, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NetServerConnection.class);
        stringBuffer.append(':');
        stringBuffer.append(aS400.getSystemName());
        stringBuffer.append(':');
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    @Override
    protected void establishConnection() throws ResourceException {
        if (!this.idWasSet_) {
            throw new ExtendedIllegalStateException("id", 4);
        }
        super.establishConnection();
        AS400 aS400 = this.getSystem();
        this.document_ = (ProgramCallDocument)staticDocument_.clone();
        try {
            this.document_.setSystem(aS400);
            String string = (String)this.getAttributeValue(NAME);
            this.document_.setValue("qzlsolst_zlsl0600.informationQualifier", string);
            this.document_.setValue("qzlsolst_zlsl0700.informationQualifier", string);
            this.attributeGetter_ = new ProgramAttributeGetter(aS400, this.document_, getterMap_);
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when establishing connection.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    @Override
    protected void freezeProperties() throws ResourceException {
        if (!this.idWasSet_) {
            throw new ExtendedIllegalStateException("id", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(Integer.toString(this.id_));
        presentation.setFullName(Integer.toString(this.id_));
        if (this.getResourceKey() == null) {
            this.setResourceKey(NetServerConnection.computeResourceKey(this.getSystem(), this.id_));
        }
        super.freezeProperties();
    }

    static ResourceMetaData[] getAttributeMetaDataStatic() {
        return attributes_.getMetaData();
    }

    @Override
    public Object getAttributeValue(Object object) throws ResourceException {
        Object object2;
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if ((object2 = super.getAttributeValue(object)) == null) {
            object2 = this.attributeGetter_.getValue(object);
        }
        return object2;
    }

    public int getID() {
        return this.id_;
    }

    static ResourceList list(AS400 aS400, int n) throws ResourceException {
        Serializable serializable;
        if (n != 0 && n != 1) {
            Trace.log(2, "Invalid type of connection: " + n);
            throw new InternalErrorException(10);
        }
        ResourceList resourceList = n == 0 ? NetServerFileShare.list(aS400) : NetServerSession.list(aS400);
        resourceList.waitForComplete();
        Vector<Resource> vector = new Vector<Resource>();
        int n2 = 0;
        while ((long)n2 < resourceList.getListLength()) {
            serializable = n == 0 ? ((NetServerFileShare)resourceList.resourceAt(n2)).listConnections() : ((NetServerSession)resourceList.resourceAt(n2)).listConnections();
            ((ResourceList)serializable).waitForComplete();
            int n3 = 0;
            while ((long)n3 < ((ResourceList)serializable).getListLength()) {
                vector.addElement(((ResourceList)serializable).resourceAt(n3));
                ++n3;
            }
            ++n2;
        }
        Object[] objectArray = new NetServerConnection[vector.size()];
        vector.copyInto(objectArray);
        serializable = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
        return new ArrayResourceList((Resource[])objectArray, (Presentation)serializable, NetServerConnection.getAttributeMetaDataStatic());
    }

    private static ResourceList list(AS400 aS400, int n, String string) throws ResourceException {
        try {
            ProgramCallDocument programCallDocument = (ProgramCallDocument)staticDocument_.clone();
            programCallDocument.setSystem(aS400);
            String string2 = n == 1 ? OLST0600_ : OLST0700_;
            programCallDocument.setValue(string2 + ".informationQualifier", string);
            int n2 = 640;
            programCallDocument.setIntValue(string2 + ".lengthOfReceiverVariable", n2);
            NetServer.callListProgram(programCallDocument, string2, true);
            int n3 = programCallDocument.getIntValue(string2 + ".listInformation.recordsReturned");
            int n4 = programCallDocument.getIntValue(string2 + ".listInformation.recordLength");
            Vector<NetServerConnection> vector = new Vector<NetServerConnection>();
            String string3 = string2 + ".receiverVariable.";
            int[] nArray = new int[1];
            Object[] objectArray = openListAttributeMap_.getIDs();
            for (int i = 0; i < n3; ++i) {
                nArray[0] = i;
                int n5 = programCallDocument.getIntValue(string3 + "connectionId", nArray);
                NetServerConnection netServerConnection = new NetServerConnection(aS400, n5);
                Object[] objectArray2 = openListAttributeMap_.getValues(objectArray, aS400, programCallDocument, string2, nArray);
                for (int j = 0; j < objectArray2.length; ++j) {
                    netServerConnection.initializeAttributeValue(objectArray[j], objectArray2[j]);
                }
                netServerConnection.freezeProperties();
                vector.addElement(netServerConnection);
            }
            Object[] objectArray3 = new NetServerConnection[vector.size()];
            vector.copyInto(objectArray3);
            Presentation presentation = presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_);
            return new ArrayResourceList((Resource[])objectArray3, presentation, NetServerConnection.getAttributeMetaDataStatic());
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when listing connections.", (Throwable)pcmlException);
            throw new ResourceException(pcmlException);
        }
    }

    static ResourceList listConnectionsForSession(AS400 aS400, String string) throws ResourceException {
        return NetServerConnection.list(aS400, 1, string);
    }

    static ResourceList listConnectionsForShare(AS400 aS400, String string) throws ResourceException {
        return NetServerConnection.list(aS400, 0, string);
    }

    @Override
    public void refreshAttributeValues() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        this.attributeGetter_.clearBuffer();
        super.refreshAttributeValues();
    }

    void setID(int n) {
        this.id_ = n;
        this.idWasSet_ = true;
    }

    static {
        attributes_.add((Object)CONNECT_TIME, Integer.class, true);
        getterMap_.add((Object)CONNECT_TIME, OLST0600_, "receiverVariable.connectionTime", INDICES_);
        getterMap_.add((Object)CONNECT_TIME, OLST0700_, "receiverVariable.connectionTime", INDICES_);
        openListAttributeMap_.add(CONNECT_TIME, null, "receiverVariable.connectionTime");
        attributes_.add((Object)FILES_OPEN_COUNT, Integer.class, true);
        getterMap_.add((Object)FILES_OPEN_COUNT, OLST0600_, "receiverVariable.numberOfFilesOpen", INDICES_);
        getterMap_.add((Object)FILES_OPEN_COUNT, OLST0700_, "receiverVariable.numberOfFilesOpen", INDICES_);
        openListAttributeMap_.add(FILES_OPEN_COUNT, null, "receiverVariable.numberOfFilesOpen");
        attributes_.add((Object)NAME, String.class, true);
        getterMap_.add((Object)NAME, OLST0600_, "receiverVariable.resourceName", INDICES_);
        getterMap_.add((Object)NAME, OLST0700_, "receiverVariable.resourceName", INDICES_);
        openListAttributeMap_.add(NAME, null, "receiverVariable.resourceName");
        TYPE_DISK_DRIVE = new Integer(0);
        TYPE_SPOOLED_OUTPUT_QUEUE = new Integer(1);
        attributes_.add(TYPE, Integer.class, true, new Object[]{TYPE_DISK_DRIVE, TYPE_SPOOLED_OUTPUT_QUEUE}, null, true);
        getterMap_.add((Object)TYPE, OLST0600_, "receiverVariable.connectionType", INDICES_);
        getterMap_.add((Object)TYPE, OLST0700_, "receiverVariable.connectionType", INDICES_);
        openListAttributeMap_.add(TYPE, null, "receiverVariable.connectionType");
        attributes_.add((Object)USER, String.class, true);
        getterMap_.add((Object)USER, OLST0600_, "receiverVariable.userName", INDICES_);
        getterMap_.add((Object)USER, OLST0700_, "receiverVariable.userName", INDICES_);
        openListAttributeMap_.add(USER, null, "receiverVariable.userName");
        attributes_.add((Object)USER_COUNT, Integer.class, true);
        getterMap_.add((Object)USER_COUNT, OLST0600_, "receiverVariable.numberOfConnectionUsers", INDICES_);
        getterMap_.add((Object)USER_COUNT, OLST0700_, "receiverVariable.numberOfConnectionUsers", INDICES_);
        openListAttributeMap_.add(USER_COUNT, null, "receiverVariable.numberOfConnectionUsers");
        staticDocument_ = null;
        try {
            staticDocument_ = new ProgramCallDocument();
            staticDocument_.setDocument(DOCUMENT_NAME_);
        }
        catch (PcmlException pcmlException) {
            Trace.log(2, "PcmlException when instantiating ProgramCallDocument.", (Throwable)pcmlException);
        }
    }
}

