/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.PxPeerConnection;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Verbose;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class PSLoadBalancer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private PSLoad load_ = null;
    private Vector peers_ = null;

    public PSLoadBalancer(PSLoad pSLoad) {
        this.load_ = pSLoad;
        this.peers_ = new Vector();
    }

    public String accept(int n) {
        String string = null;
        int n2 = this.load_.getActiveConnections();
        string = n2 < this.load_.getEffectiveBalanceThreshold() ? null : (n2 < this.load_.getEffectiveMaxConnections() ? (n > 0 ? null : this.getLeastBusyPeer(true)) : this.getLeastBusyPeer(false));
        return string;
    }

    private String getLeastBusyPeer(boolean bl) {
        double d = Double.MAX_VALUE;
        String string = "";
        Vector vector = (Vector)this.peers_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PSLoad pSLoad;
            String string2 = (String)enumeration.nextElement();
            try {
                PxPeerConnection pxPeerConnection = new PxPeerConnection(string2);
                pSLoad = pxPeerConnection.load();
                pxPeerConnection.close();
            }
            catch (ProxyException proxyException) {
                Verbose.println(ResourceBundleLoader.getText("PROXY_PEER_NOT_RESPONDING", string2));
                this.peers_.removeElement(string2);
                continue;
            }
            double d2 = pSLoad.getBusyFactor();
            if (!(d2 < d)) continue;
            d = d2;
            string = string2;
        }
        if (bl && this.load_.getBusyFactor() < d) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPeers() {
        Vector vector = this.peers_;
        synchronized (vector) {
            Object[] objectArray = new String[this.peers_.size()];
            this.peers_.copyInto(objectArray);
            return objectArray;
        }
    }

    public void setPeers(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";, ");
        int n = stringTokenizer.countTokens();
        Vector<String> vector = new Vector<String>(n);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (vector.contains(string2)) continue;
            vector.addElement(string2);
        }
        this.peers_ = (Vector)vector.clone();
    }

    public void setPeers(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (vector.contains(stringArray[i])) continue;
            vector.addElement(stringArray[i]);
        }
        this.peers_ = (Vector)vector.clone();
    }
}

