/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDPrinterFile;
import com.ibm.as400.access.NPCPSelPrtF;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.PrinterFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class PrinterFileList
extends PrintObjectList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRINTER_FILE_FILTER = "printerFileFilter";

    public PrinterFileList() {
        super(5, new NPCPSelPrtF());
    }

    public PrinterFileList(AS400 aS400) {
        super(5, new NPCPSelPrtF(), aS400);
    }

    @Override
    void chooseImpl() {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use PrinterFileList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)aS400.loadImpl2("com.ibm.as400.access.PrinterFileListImplRemote", "com.ibm.as400.access.PrinterFileListImplProxy");
        super.setImpl();
    }

    public String getPrinterFileFilter() {
        NPCPSelPrtF nPCPSelPrtF = (NPCPSelPrtF)this.getSelectionCP();
        return nPCPSelPrtF.getPrinterFile();
    }

    @Override
    PrintObject newNPObject(NPCPID nPCPID, NPCPAttribute nPCPAttribute) {
        return new PrinterFile(this.system_, (NPCPIDPrinterFile)nPCPID, nPCPAttribute);
    }

    public void setPrinterFileFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'printerFileFilter' is null");
            throw new NullPointerException(PRINTER_FILE_FILTER);
        }
        String string2 = this.getPrinterFileFilter();
        this.vetos.fireVetoableChange(PRINTER_FILE_FILTER, string2, string);
        NPCPSelPrtF nPCPSelPrtF = (NPCPSelPrtF)this.getSelectionCP();
        nPCPSelPrtF.setPrinterFile(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("printerFile", string);
        }
        this.changes.firePropertyChange(PRINTER_FILE_FILTER, string2, string);
    }
}

