/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Product;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;

public class ProductList {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private AS400 system_;
    private String[] productIDs_ = new String[1];
    private String[] productOptions_ = new String[1];
    private String[] releaseLevels_ = new String[1];
    private int currentProduct_ = 0;
    private String filter_ = "*ALL";
    private String option_ = "*ALL";
    private int chunkSize_ = 1000;
    public static final String PRODUCT_FILTER_ALL = "*ALL";
    public static final String PRODUCT_FILTER_INSTALLED = "*INSTLD";
    public static final String PRODUCT_FILTER_INSTALLED_OR_SUPPORTED = "*INSSPT";
    public static final String PRODUCT_FILTER_LIST = "*LIST";
    public static final String PRODUCT_FILTER_SUPPORTED = "*SUPPTD";
    public static final String PRODUCT_OPTION_ALL = "*ALL";
    public static final String PRODUCT_OPTION_BASE = "*BASE";

    public ProductList() {
    }

    public ProductList(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public void addProductToRetrieve(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("productID");
        }
        if (string2 == null) {
            throw new NullPointerException("productOption");
        }
        if (string3 == null) {
            throw new NullPointerException("releaseLevel");
        }
        String string4 = string.toUpperCase().trim();
        if (string4.length() != 7) {
            throw new ExtendedIllegalArgumentException("productID", 1);
        }
        Object object = string2.toUpperCase().trim();
        if (!((String)object).equals(PRODUCT_OPTION_BASE) && !((String)object).equals("*ALL")) {
            while (((String)object).length() < 5) {
                object = "0" + (String)object;
            }
        }
        if (((String)object).length() > 5) {
            throw new ExtendedIllegalArgumentException("productOption", 1);
        }
        String string5 = string3.toUpperCase().trim();
        if (string5.length() != 6) {
            throw new ExtendedIllegalArgumentException("releaseLevel", 1);
        }
        if (this.currentProduct_ >= this.productIDs_.length) {
            String[] stringArray = this.productIDs_;
            int n = stringArray.length;
            int n2 = stringArray.length * 2;
            this.productIDs_ = new String[n2];
            System.arraycopy(stringArray, 0, this.productIDs_, 0, n);
            stringArray = this.productOptions_;
            this.productOptions_ = new String[n2];
            System.arraycopy(stringArray, 0, this.productOptions_, 0, n);
            stringArray = this.releaseLevels_;
            this.releaseLevels_ = new String[n2];
            System.arraycopy(stringArray, 0, this.releaseLevels_, 0, n);
        }
        this.productIDs_[this.currentProduct_] = string4;
        this.productOptions_[this.currentProduct_] = object;
        this.releaseLevels_[this.currentProduct_++] = string5;
    }

    public void clearProductsToRetrieve() {
        this.productIDs_ = new String[1];
        this.productOptions_ = new String[1];
        this.releaseLevels_ = new String[1];
        this.currentProduct_ = 0;
        this.filter_ = "*ALL";
    }

    public Product[] getProducts() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        Object object;
        Serializable serializable;
        if (this.filter_.equals(PRODUCT_FILTER_LIST) && this.currentProduct_ == 0) {
            if (Trace.traceOn_) {
                Trace.log(2, "ProductList filter is set to PRODUCT_FILTER_LIST but no products have been added.");
            }
            throw new ExtendedIllegalArgumentException("filter", 2);
        }
        int n2 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n2, null);
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        programParameterArray[0] = new ProgramParameter(197 * this.chunkSize_);
        byte[] byArray = new byte[40];
        BinaryConverter.intToByteArray(this.chunkSize_, byArray, 0);
        AS400Text aS400Text = new AS400Text(10, n2, this.system_);
        aS400Text.toBytes("*ALL", byArray, 4);
        byArray[14] = -15;
        byArray[15] = -15;
        aS400Text.toBytes(this.option_, byArray, 16);
        aS400Text.toBytes(this.filter_, byArray, 26);
        if (this.currentProduct_ > 0 && this.filter_.equals(PRODUCT_FILTER_LIST)) {
            BinaryConverter.intToByteArray(this.currentProduct_, byArray, 36);
        }
        programParameterArray[1] = new ProgramParameter(byArray);
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("PRDS0200"));
        byte[] byArray2 = null;
        if (this.currentProduct_ > 0 && this.filter_.equals(PRODUCT_FILTER_LIST)) {
            byArray2 = new byte[18 * this.currentProduct_];
            serializable = new AS400Text(5, n2, this.system_);
            object = new AS400Text(6, n2, this.system_);
            AS400Text aS400Text2 = new AS400Text(7, n2, this.system_);
            n = 0;
            for (int i = 0; i < this.currentProduct_; ++i) {
                aS400Text2.toBytes(this.productIDs_[i], byArray2, n);
                ((AS400Text)serializable).toBytes(this.productOptions_[i], byArray2, n += 7);
                ((AS400Text)object).toBytes(this.releaseLevels_[i], byArray2, n += 5);
                n += 6;
            }
        } else {
            byArray2 = new byte[18];
        }
        programParameterArray[3] = new ProgramParameter(byArray2);
        programParameterArray[4] = new ProgramParameter(12);
        programParameterArray[5] = new ProgramParameter(new byte[4]);
        serializable = new ProgramCall(this.system_, "/QSYS.LIB/QSZSLTPR.PGM", programParameterArray);
        if (!((ProgramCall)serializable).run()) {
            throw new AS400Exception(((ProgramCall)serializable).getMessageList());
        }
        object = programParameterArray[4].getOutputData();
        int n3 = BinaryConverter.byteArrayToInt((byte[])object, 0);
        n = BinaryConverter.byteArrayToInt((byte[])object, 4);
        if (n > this.chunkSize_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Increasing ProductList chunk size from " + this.chunkSize_ + " to " + n + " and re-retrieving.");
            }
            this.chunkSize_ = n;
            return this.getProducts();
        }
        byte[] byArray3 = programParameterArray[0].getOutputData();
        int n4 = 0;
        Product[] productArray = new Product[n];
        for (int i = 0; i < n && n4 < byArray3.length; ++i) {
            n4 = i * n3;
            String string = convTable.byteArrayToString(byArray3, n4, 7);
            String string2 = convTable.byteArrayToString(byArray3, n4 += 7, 5);
            String string3 = convTable.byteArrayToString(byArray3, n4 += 5, 6);
            String string4 = convTable.byteArrayToString(byArray3, n4 += 8, 7);
            String string5 = convTable.byteArrayToString(byArray3, n4 += 7, 10);
            String string6 = convTable.byteArrayToString(byArray3, n4 += 10, 10);
            String string7 = QSYSObjectPathName.toPath(string6, string5, "MSGF");
            boolean bl = convTable.byteArrayToString(byArray3, n4 += 10, 1).equals("1");
            boolean bl2 = convTable.byteArrayToString(byArray3, ++n4, 1).equals("1");
            String string8 = convTable.byteArrayToString(byArray3, ++n4, 2);
            String string9 = convTable.byteArrayToString(byArray3, n4 += 2, 14);
            String string10 = convTable.byteArrayToString(byArray3, n4 += 14, 132);
            productArray[i] = new Product(this.system_, string, string2, string3, string4, string10, string7, bl, bl2, string8, string9);
        }
        return productArray;
    }

    public void setProductFilter(String string) {
        if (string == null) {
            throw new NullPointerException("filter");
        }
        if (!(string.equals(PRODUCT_FILTER_INSTALLED) || string.equals(PRODUCT_FILTER_SUPPORTED) || string.equals(PRODUCT_FILTER_INSTALLED_OR_SUPPORTED) || string.equals("*ALL") || string.equals(PRODUCT_FILTER_LIST))) {
            throw new ExtendedIllegalArgumentException("filter", 2);
        }
        this.filter_ = string;
    }

    public void setProductOption(String string) {
        if (string == null) {
            throw new NullPointerException("option");
        }
        if (!string.equals("*ALL") && !string.equals(PRODUCT_OPTION_BASE)) {
            throw new ExtendedIllegalArgumentException("option", 2);
        }
        this.option_ = string;
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }
}

