/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.PxAcceptRepCV;
import com.ibm.as400.access.PxClientReadDaemon;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxRepCV;
import com.ibm.as400.access.PxReqCV;
import com.ibm.as400.access.PxSocketContainer;
import com.ibm.as400.access.PxSocketContainerAdapter;
import com.ibm.as400.access.RetryInputStream;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;

public abstract class PxClientConnectionAdapter {
    private static final String copyright = "Copyrixght (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private InputStream input_ = null;
    private OutputStream output_ = null;
    private PxClientReadDaemon readDaemon_ = null;
    private PxSocketContainerAdapter socket_ = null;
    private SSLOptions sslOptions_ = null;
    boolean tunnel_ = false;
    private long clientId_ = -1L;
    private URL tunnelURL_ = null;
    private String localName = null;

    protected PxClientConnectionAdapter(String string, SSLOptions sSLOptions) {
        this.sslOptions_ = sSLOptions;
        this.open(string);
    }

    public void close() {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Closing a connection to proxy server.");
            }
            this.readDaemon_.stopSafely();
            try {
                this.input_.close();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2, (Throwable)iOException);
            }
            try {
                this.output_.close();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2, (Throwable)iOException);
            }
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2, (Throwable)iOException);
            }
        }
        this.closed_ = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.close();
        }
        super.finalize();
    }

    public PxDSFactory getFactory() {
        return this.readDaemon_.getFactory();
    }

    public void open(String string) {
        int n;
        boolean bl;
        boolean bl2 = bl = this.sslOptions_ != null && this.sslOptions_.proxyEncryptionMode_ != 2;
        if (Trace.isTraceOn()) {
            Trace.log(6, "Opening a connection to proxy server " + string + " (secure=" + bl + ").");
        }
        this.localName = string;
        String string2 = null;
        int n2 = -1;
        if (string.indexOf("://") > 0) {
            this.tunnel_ = true;
            this.localName = string.substring(string.indexOf(":") + 3);
            string2 = string.substring(0, string.indexOf(":"));
        }
        if ((n = this.localName.indexOf(58)) >= 0) {
            if (n < this.localName.length() - 1) {
                n2 = Integer.parseInt(this.localName.substring(n + 1));
            }
            this.localName = this.localName.substring(0, n);
        }
        if (!this.tunnel_) {
            if (n2 < 0) {
                n2 = bl ? 3471 : 3470;
            }
            this.openTraditional(this.localName, n2, bl);
        } else {
            this.openTunnel(string2, this.localName, n2);
        }
    }

    void openTraditional(String string, int n, boolean bl) {
        try {
            if (bl) {
                Class<?> clazz = Class.forName("com.ibm.as400.access.PxSecureSocketContainer");
                Class[] classArray = new Class[]{"".getClass(), Integer.TYPE, Class.forName("com.ibm.as400.access.SSLOptions")};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string, new Integer(n), this.sslOptions_};
                this.socket_ = (PxSocketContainerAdapter)constructor.newInstance(objectArray);
            } else {
                this.socket_ = new PxSocketContainer(string, n);
            }
            this.output_ = new BufferedOutputStream(this.socket_.getOutputStream());
            this.input_ = new BufferedInputStream(new RetryInputStream(this.socket_.getInputStream()));
            this.readDaemon_ = new PxClientReadDaemon(this.input_);
            this.readDaemon_.start();
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Connection established.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (ClassNotFound", (Throwable)classNotFoundException);
            }
            throw new ProxyException(1, (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (NoSuchMethodException", (Throwable)noSuchMethodException);
            }
            throw new ProxyException(1, (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (IllegalAccessException", (Throwable)illegalAccessException);
            }
            throw new ProxyException(1, (Throwable)illegalAccessException);
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (openio", (Throwable)iOException);
            }
            throw new ProxyException(1, (Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (IllegalArgumentException", (Throwable)illegalArgumentException);
            }
            throw new ProxyException(1, (Throwable)illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (InstantiationException", (Throwable)instantiationException);
            }
            throw new ProxyException(1, (Throwable)instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server (InvocationTargetException", (Throwable)invocationTargetException);
            }
            throw new ProxyException(1, (Throwable)invocationTargetException);
        }
    }

    void openTunnel(String string, String string2, int n) {
        try {
            this.readDaemon_ = new PxClientReadDaemon();
            this.readDaemon_.register(new PxAcceptRepCV());
            this.tunnelURL_ = n < 0 ? new URL(string, string2, "/servlet/com.ibm.as400.access.TunnelProxyServer") : new URL(string, string2, n, "/servlet/com.ibm.as400.access.TunnelProxyServer");
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)iOException);
            }
            throw new ProxyException(1, (Throwable)iOException);
        }
    }

    private URLConnection tunnelSend(PxReqCV pxReqCV) {
        try {
            pxReqCV.setClientId(this.clientId_);
            URLConnection uRLConnection = this.tunnelURL_.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            uRLConnection.setRequestProperty("Content-type", "application/octet-stream");
            uRLConnection.setRequestProperty("Connection", "Keep-Alive");
            OutputStream outputStream = uRLConnection.getOutputStream();
            if (Trace.isTraceProxyOn()) {
                pxReqCV.dump(Trace.getPrintWriter());
            }
            pxReqCV.writeTo(outputStream);
            outputStream.flush();
            return uRLConnection;
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)exception);
            }
            throw new ProxyException(1, (Throwable)exception);
        }
    }

    Object tunnelReceive(long l, URLConnection uRLConnection) throws InvocationTargetException {
        try {
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                PxRepCV pxRepCV = this.readDaemon_.getReply(l, inputStream);
                Object object = pxRepCV.process();
                this.clientId_ = pxRepCV.getClientId();
                return object;
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, "Error when receiving reply from proxy server", (Throwable)iOException);
                }
                ProxyException proxyException = new ProxyException(2, (Throwable)iOException);
                throw proxyException;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when opening connection to proxy server", (Throwable)exception);
            }
            ProxyException proxyException = new ProxyException(1, (Throwable)exception);
            throw proxyException;
        }
    }

    private Object receive(long l) throws InvocationTargetException {
        Object object = null;
        try {
            PxRepCV pxRepCV = this.readDaemon_.getReply(l);
            object = pxRepCV.process();
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "received " + object);
            }
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                Trace.log(2, "Error when receiving reply from proxy server", (Throwable)iOException);
            }
            if (iOException instanceof NotSerializableException) {
                throw new ProxyException(4, (Throwable)iOException);
            }
            throw new ProxyException(2, (Throwable)iOException);
        }
        return object;
    }

    protected synchronized void send(PxReqCV pxReqCV) {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                pxReqCV.dump(Trace.getPrintWriter());
            }
            try {
                pxReqCV.writeTo(this.output_);
                this.output_.flush();
            }
            catch (IOException iOException) {
                if (Trace.isTraceErrorOn() || Trace.isTraceProxyOn()) {
                    Trace.log(2, iOException.getMessage(), (Throwable)iOException);
                }
                throw new ProxyException(2, (Throwable)iOException);
            }
        } else {
            URLConnection uRLConnection = this.tunnelSend(pxReqCV);
        }
    }

    protected Object sendAndReceive(PxReqCV pxReqCV) throws InvocationTargetException {
        if (!this.tunnel_) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "Sending request with id " + pxReqCV.getCorrelationId());
            }
            this.send(pxReqCV);
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "Receiving with id " + pxReqCV.getCorrelationId());
            }
            return this.receive(pxReqCV.getCorrelationId());
        }
        URLConnection uRLConnection = this.tunnelSend(pxReqCV);
        Object object = this.tunnelReceive(pxReqCV.getCorrelationId(), uRLConnection);
        return object;
    }

    public String getSystemName() {
        return this.localName;
    }
}

