/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDSRV;
import com.ibm.as400.access.PxRepCV;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

class PxClientReadDaemon
extends StoppableThread {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private PxDSFactory factory_ = new PxDSFactory();
    private InputStream input_;
    private InvocationTargetException invocationTargetException_ = null;
    private IOException ioException_ = null;
    private Hashtable replies_ = new Hashtable();
    private boolean running_ = false;
    private boolean started_ = false;

    public PxClientReadDaemon() {
        super("Proxy client read daemon-" + PxClientReadDaemon.newId());
        this.setDaemon(true);
    }

    public PxClientReadDaemon(InputStream inputStream) {
        super("Proxy client read daemon-" + PxClientReadDaemon.newId());
        this.setDaemon(true);
        this.input_ = inputStream;
    }

    public PxDSFactory getFactory() {
        return this.factory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PxRepCV getReply(long l) throws InvocationTargetException, IOException {
        Long l2 = new Long(l);
        while (true) {
            Object object;
            if (this.ioException_ != null) {
                object = this.ioException_;
                this.ioException_ = null;
                throw object;
            }
            if (this.invocationTargetException_ != null) {
                object = this.invocationTargetException_;
                this.invocationTargetException_ = null;
                throw object;
            }
            object = this;
            synchronized (object) {
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, this, "correlationId is " + l);
                }
                if (this.replies_.containsKey(l2)) {
                    PxRepCV pxRepCV = (PxRepCV)this.replies_.get(l2);
                    this.replies_.remove(l2);
                    return pxRepCV;
                }
                if (this.running_ || !this.started_) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "Proxy read daemon stopped, but replies are expected.");
                    }
                    throw new InternalErrorException(4);
                }
            }
        }
    }

    public void register(PxDSRV pxDSRV) {
        this.factory_.register(pxDSRV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.started_ = true;
        this.running_ = true;
        try {
            while (this.canContinue()) {
                long l;
                this.ioException_ = null;
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, this, "calling factory_.getNextDS");
                }
                PxRepCV pxRepCV = (PxRepCV)this.factory_.getNextDS(this.input_);
                if (Trace.isTraceProxyOn()) {
                    pxRepCV.dump(Trace.getPrintWriter());
                }
                if ((l = pxRepCV.getCorrelationId()) >= 0L) {
                    PxClientReadDaemon pxClientReadDaemon = this;
                    synchronized (pxClientReadDaemon) {
                        this.replies_.put(new Long(l), pxRepCV);
                        this.notifyAll();
                        continue;
                    }
                }
                pxRepCV.process();
            }
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "Exited while loop");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.invocationTargetException_ = invocationTargetException;
        }
        catch (IOException iOException) {
            if (!this.wasStoppedSafely() && !(iOException instanceof EOFException)) {
                this.ioException_ = iOException;
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, "Ending read daemon", (Throwable)iOException);
                }
            }
            PxClientReadDaemon pxClientReadDaemon = this;
            synchronized (pxClientReadDaemon) {
                this.notifyAll();
            }
        }
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, this, "Leaving running loop invocationTargetException_=" + this.invocationTargetException_ + " ioException_=" + this.ioException_);
        }
        this.running_ = false;
    }

    public PxRepCV getReply(long l, InputStream inputStream) throws InvocationTargetException, IOException {
        PxRepCV pxRepCV;
        Long l2;
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, this, "getReply");
        }
        if (this.replies_.containsKey(l2 = new Long(l))) {
            PxRepCV pxRepCV2 = (PxRepCV)this.replies_.get(l2);
            this.replies_.remove(l2);
            return pxRepCV2;
        }
        while (true) {
            long l3;
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, this, "calling factory_.getNextDS");
            }
            pxRepCV = (PxRepCV)this.factory_.getNextDS(inputStream);
            if (Trace.isTraceProxyOn()) {
                pxRepCV.dump(Trace.getPrintWriter());
            }
            if ((l3 = pxRepCV.getCorrelationId()) == l) break;
            this.replies_.put(new Long(l3), pxRepCV);
        }
        pxRepCV.process();
        return pxRepCV;
    }
}

