/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStreamCompression;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class RCCallProgramReplyDataStream
extends ClientAccessDataStream {
    RCCallProgramReplyDataStream() {
    }

    @Override
    public Object getNewDataStream() {
        return new RCCallProgramReplyDataStream();
    }

    @Override
    public int hashCode() {
        return 32771;
    }

    int getRC() {
        return this.get16bit(20);
    }

    AS400Message[] getMessageList(ConverterImplRemote converterImplRemote) throws IOException {
        return RemoteCommandImplRemote.parseMessages(this.data_, converterImplRemote);
    }

    void getParameterList(ProgramParameter[] programParameterArray) {
        int n = 24;
        for (int i = 0; i < programParameterArray.length; ++i) {
            byte[] byArray;
            if (programParameterArray[i].getOutputDataLength() <= 0) continue;
            int n2 = BinaryConverter.byteArrayToInt(this.data_, n);
            int n3 = BinaryConverter.byteArrayToUnsignedShort(this.data_, n + 10);
            int n4 = BinaryConverter.byteArrayToInt(this.data_, n + 6);
            if (n3 == 22 || n3 == 23) {
                byArray = DataStreamCompression.decompressRLE(this.data_, n + 12, n2 - 12, n4, (byte)27);
            } else {
                byArray = new byte[n4];
                System.arraycopy(this.data_, n + 12, byArray, 0, n2 - 12);
            }
            programParameterArray[i].setOutputData(byArray);
            n += n2;
        }
    }

    @Override
    protected int readAfterHeader(InputStream inputStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving call program reply...");
        }
        return super.readAfterHeader(inputStream);
    }
}

