/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SCS5224Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCS5553Writer
extends SCS5224Writer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int CHARACTER_NORMAL = 0;
    public static final int CHARACTER_ROTATED = 1;
    public static final int SCALE_DOUBLE_HORIZONTAL = 32;
    public static final int SCALE_REGULAR = 16;
    public static final int SETCCP_NO_PRINT = 0;
    public static final int SETCCP_BLANK_CODE = 1;
    public static final int SETCCP_SI_BLANK = 2;
    private static final byte[] SCD = new byte[]{43, -46, 4, 41, 0, 0};
    private static final byte[] DGL = new byte[]{43, -3, 0, 0, 0, 0};
    private static final byte[] SFSS = new byte[]{43, -3, 4, 2, 0, 0};
    private static final byte[] STO = new byte[]{43, -45, 4, -10, 0, 0};
    private static final byte[] SPPC = new byte[]{43, -3, 4, 3, 0, 0};
    private int setCCP = 1;

    public SCS5553Writer(OutputStream outputStream) {
        super(outputStream);
    }

    public SCS5553Writer(OutputStream outputStream, int n) throws UnsupportedEncodingException {
        super(outputStream, n);
    }

    public SCS5553Writer(OutputStream outputStream, int n, AS400 aS400) throws UnsupportedEncodingException {
        super(outputStream, n, aS400);
    }

    public SCS5553Writer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    @Override
    void initPage() throws IOException {
        super.initPage();
        this.setControlCharPresentation(this.setCCP);
    }

    @Override
    public void setCPI(int n) throws IOException {
        switch (n) {
            case 10: {
                this.CPI = (byte)10;
                break;
            }
            case 12: {
                this.CPI = (byte)12;
                break;
            }
            case 15: {
                this.CPI = (byte)15;
                break;
            }
            case 18: {
                this.CPI = (byte)18;
                break;
            }
            case 20: {
                this.CPI = (byte)20;
                break;
            }
            default: {
                String string = "CPI (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
        this.fontOrCPI = true;
        if (!this.pageStarted_) {
            this.initPage();
        }
        byte[] byArray = SCD;
        byArray[byArray.length - 1] = this.CPI;
        this.addToBuffer(byArray);
    }

    public void printHorizontalGridLine(double d, double d2) throws IOException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = DGL;
        byArray2[2] = 8;
        byArray2[byArray2.length - 1] = -128;
        this.addToBuffer(byArray2);
        int n = (int)(d * 1440.0);
        int n2 = (int)(d2 * 1440.0);
        byArray[0] = (byte)(n >> 8);
        byArray[1] = (byte)n;
        byArray[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)n2;
        this.addToBuffer(byArray);
    }

    public void setCharacterRotation(int n) throws IOException {
        byte[] byArray = STO;
        switch (n) {
            case 0: {
                byArray[byArray.length - 2] = 0;
                byArray[byArray.length - 1] = 0;
                this.addToBuffer(byArray);
                break;
            }
            case 1: {
                byArray[byArray.length - 2] = -121;
                byArray[byArray.length - 1] = 0;
                this.addToBuffer(byArray);
                break;
            }
            default: {
                String string = "Rotation (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
    }

    public void setControlCharPresentation(int n) throws IOException {
        byte[] byArray = SPPC;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.setCCP = n;
                byArray[4] = (byte)(n >> 8);
                byArray[5] = (byte)n;
                this.addToBuffer(byArray);
                break;
            }
            default: {
                String string = "set (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
    }

    public void setFontScaling(int n) throws IOException {
        byte[] byArray = SFSS;
        switch (n) {
            case 16: {
                byArray[byArray.length - 2] = 16;
                this.addToBuffer(byArray);
                break;
            }
            case 32: {
                byArray[byArray.length - 2] = 32;
                this.addToBuffer(byArray);
                break;
            }
            default: {
                String string = "Scale (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
    }

    public void startVerticalGridLines(double[] dArray) throws IOException {
        byte[] byArray = DGL;
        int n = dArray.length;
        byte[] byArray2 = new byte[2 * n];
        byArray[2] = (byte)(4 + 2 * n);
        byArray[5] = 64;
        this.addToBuffer(byArray);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)(dArray[i] * 1440.0);
            byArray2[n2] = (byte)(n3 >> 8);
            byArray2[++n2] = (byte)n3;
            ++n2;
        }
        this.addToBuffer(byArray2);
    }

    public void stopVerticalGridLines() throws IOException {
        byte[] byArray = DGL;
        byArray[2] = 4;
        byArray[5] = 0;
        this.addToBuffer(byArray);
    }
}

