/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class SQLDataBase
implements SQLData {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    protected int truncated_;
    protected boolean outOfBounds_;
    protected SQLConversionSettings settings_;
    Object savedValue_ = null;

    public SQLDataBase(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
    }

    @Override
    public abstract Object clone();

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.convertFromRawBytes(byArray, n, convTable, false);
    }

    @Override
    public abstract void convertFromRawBytes(byte[] var1, int var2, ConvTable var3, boolean var4) throws SQLException;

    @Override
    public abstract void convertToRawBytes(byte[] var1, int var2, ConvTable var3) throws SQLException;

    @Override
    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
    }

    @Override
    public abstract void set(Object var1, Calendar var2, int var3) throws SQLException;

    @Override
    public abstract int getSQLType();

    @Override
    public abstract String getCreateParameters();

    @Override
    public abstract int getDisplaySize();

    @Override
    public abstract String getJavaClassName();

    @Override
    public abstract String getLiteralPrefix();

    @Override
    public abstract String getLiteralSuffix();

    @Override
    public abstract String getLocalName();

    @Override
    public abstract int getMaximumPrecision();

    @Override
    public abstract int getMaximumScale();

    @Override
    public abstract int getMinimumScale();

    @Override
    public abstract int getNativeType();

    @Override
    public abstract int getPrecision();

    @Override
    public abstract int getRadix();

    @Override
    public abstract int getScale();

    @Override
    public abstract int getType();

    @Override
    public abstract String getTypeName();

    @Override
    public abstract boolean isSigned();

    @Override
    public abstract boolean isText();

    @Override
    public abstract int getActualSize();

    @Override
    public abstract int getTruncated();

    @Override
    public void clearTruncated() {
        this.truncated_ = 0;
    }

    @Override
    public abstract boolean getOutOfBounds();

    @Override
    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.getString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            BigDecimal bigDecimal = new BigDecimal(SQLDataFactory.convertScientificNotation(this.getString().trim(), this.settings_));
            if (n >= 0) {
                if (n >= bigDecimal.scale()) {
                    this.truncated_ = 0;
                    this.outOfBounds_ = false;
                    return bigDecimal.setScale(n);
                }
                this.truncated_ = bigDecimal.scale() - n;
                this.outOfBounds_ = false;
                return bigDecimal.setScale(n, 4);
            }
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    @Override
    public abstract InputStream getBinaryStream() throws SQLException;

    @Override
    public abstract Blob getBlob() throws SQLException;

    @Override
    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = this.getString().trim();
        return string.length() > 0 && !string.equalsIgnoreCase("false") && !string.equals("0");
    }

    @Override
    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double d = new Double(this.getString().trim());
            double d2 = d;
            if (d2 > 127.0 || d2 < -128.0) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return d.byteValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1;
        }
    }

    @Override
    public abstract byte[] getBytes() throws SQLException;

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getString());
    }

    @Override
    public Clob getClob() throws SQLException {
        String string = this.getString();
        return new AS400JDBCClob(string);
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        return SQLDate.stringToDate(this.getString(), this.settings_, calendar);
    }

    @Override
    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new Double(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1.0;
        }
    }

    @Override
    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new Double(this.getString().trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1.0f;
        }
    }

    @Override
    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double d = new Double(this.getString().trim());
            double d2 = d;
            if (d2 > 2.147483647E9 || d2 < -2.147483648E9) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return d.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1;
        }
    }

    @Override
    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double d = new Double(this.getString().trim());
            double d2 = d;
            if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return d.longValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1L;
        }
    }

    @Override
    public abstract Object getObject() throws SQLException;

    @Override
    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double d = new Double(this.getString().trim());
            double d2 = d;
            if (d2 > 32767.0 || d2 < -32768.0) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return d.shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1;
        }
    }

    @Override
    public abstract String getString() throws SQLException;

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        return SQLTime.stringToTime(this.getString(), this.settings_, calendar);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        return SQLTimestamp.stringToTimestamp(this.getString(), calendar);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ReaderInputStream((Reader)new StringReader(this.getString()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(this.getNString());
    }

    @Override
    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = this.getNString();
        return new AS400JDBCNClob(string, string.length());
    }

    @Override
    public String getNString() throws SQLException {
        return this.getString();
    }

    @Override
    public abstract SQLXML getSQLXML() throws SQLException;

    @Override
    public abstract RowId getRowId() throws SQLException;

    @Override
    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }

    static String getStringFromReader(Reader reader, int n, Object object) throws SQLException {
        String string = null;
        if (n >= 0) {
            try {
                int n2 = n < 1000000 ? n : 1000000;
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[n2];
                int n3 = 0;
                int n4 = reader.read(cArray, 0, n2);
                while (n4 > -1 && n3 < n) {
                    stringBuffer.append(cArray, 0, n4);
                    int n5 = n - (n3 += n4);
                    if (n5 < n2) {
                        n2 = n5;
                    }
                    n4 = reader.read(cArray, 0, n2);
                }
                string = stringBuffer.toString();
                if (string.length() < n) {
                    JDError.throwSQLException(object, "07006");
                }
            }
            catch (IOException iOException) {
                JDError.throwSQLException(object, "HY000", iOException);
            }
        } else if (n == -2) {
            try {
                int n6 = 1000000;
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[n6];
                int n7 = reader.read(cArray, 0, n6);
                while (n7 > -1) {
                    stringBuffer.append(cArray, 0, n7);
                    n7 = reader.read(cArray, 0, n6);
                }
                string = stringBuffer.toString();
            }
            catch (IOException iOException) {
                JDError.throwSQLException(object, "HY000", iOException);
            }
        } else {
            JDError.throwSQLException(object, "07006");
        }
        return string;
    }

    static byte[] getBytesFromInputStream(InputStream inputStream, int n, Object object) throws SQLException {
        byte[] byArray = null;
        if (n >= 0) {
            InputStream inputStream2 = inputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = n < 1000000 ? n : 1000000;
            byte[] byArray2 = new byte[n2];
            try {
                int n3 = 0;
                int n4 = inputStream2.read(byArray2, 0, n2);
                while (n4 > -1 && n3 < n) {
                    byteArrayOutputStream.write(byArray2, 0, n4);
                    int n5 = n - (n3 += n4);
                    if (n5 < n2) {
                        n2 = n5;
                    }
                    n4 = inputStream2.read(byArray2, 0, n2);
                }
            }
            catch (IOException iOException) {
                JDError.throwSQLException(object, "HY000", iOException);
            }
            byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length < n) {
                JDError.throwSQLException(object, "07006");
            }
        } else if (n == -2) {
            InputStream inputStream3 = inputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n6 = 1000000;
            byte[] byArray3 = new byte[n6];
            try {
                int n7 = 0;
                int n8 = inputStream3.read(byArray3, 0, n6);
                while (n8 > -1) {
                    byteArrayOutputStream.write(byArray3, 0, n8);
                    n7 += n8;
                    n8 = inputStream3.read(byArray3, 0, n6);
                }
            }
            catch (IOException iOException) {
                JDError.throwSQLException(object, "HY000", iOException);
            }
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            JDError.throwSQLException(object, "07006");
        }
        return byArray;
    }

    static byte[] getBytesFromReader(Reader reader, int n, Object object) throws SQLException {
        byte[] byArray = null;
        if (n >= 0) {
            try {
                int n2 = n < 1000000 ? n : 1000000;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HexReaderInputStream hexReaderInputStream = new HexReaderInputStream(reader);
                byte[] byArray2 = new byte[n2];
                int n3 = 0;
                int n4 = hexReaderInputStream.read(byArray2, 0, n2);
                while (n4 > -1 && n3 < n) {
                    byteArrayOutputStream.write(byArray2, 0, n4);
                    int n5 = n - (n3 += n4);
                    if (n5 < n2) {
                        n2 = n5;
                    }
                    n4 = hexReaderInputStream.read(byArray2, 0, n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length < n) {
                    JDError.throwSQLException(object, "07006");
                }
                hexReaderInputStream.close();
            }
            catch (ExtendedIOException extendedIOException) {
                JDError.throwSQLException(object, "07006", extendedIOException);
            }
            catch (IOException iOException) {
                JDError.throwSQLException(object, "HY000", iOException);
            }
        } else if (n == -2 || n == -1) {
            try {
                int n6 = 1000000;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HexReaderInputStream hexReaderInputStream = new HexReaderInputStream(reader);
                byte[] byArray3 = new byte[n6];
                int n7 = 0;
                int n8 = hexReaderInputStream.read(byArray3, 0, n6);
                while (n8 > -1) {
                    byteArrayOutputStream.write(byArray3, 0, n8);
                    n7 += n8;
                    n8 = hexReaderInputStream.read(byArray3, 0, n6);
                }
                byArray = byteArrayOutputStream.toByteArray();
                hexReaderInputStream.close();
            }
            catch (ExtendedIOException extendedIOException) {
                JDError.throwSQLException(object, "07006", extendedIOException);
            }
            catch (IOException iOException) {
                JDError.throwSQLException(object, "HY000", iOException);
            }
        } else {
            JDError.throwSQLException(object, "07006");
        }
        return byArray;
    }

    public static boolean isCharacterType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getSavedValue() {
        return this.savedValue_;
    }
}

