/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DecFloat;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDecFloat16
extends SQLDataBase {
    private static final BigDecimal default_ = BigDecimal.valueOf(0L);
    private static final BigDecimal BYTE_MAX_VALUE = BigDecimal.valueOf(127L);
    private static final BigDecimal BYTE_MIN_VALUE = BigDecimal.valueOf(-128L);
    private static final BigDecimal SHORT_MAX_VALUE = BigDecimal.valueOf(32767L);
    private static final BigDecimal SHORT_MIN_VALUE = BigDecimal.valueOf(-32768L);
    private static final BigDecimal INTEGER_MAX_VALUE = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal INTEGER_MIN_VALUE = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal FLOAT_MAX_VALUE = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal FLOAT_MIN_VALUE = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal DOUBLE_MAX_VALUE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal DOUBLE_MIN_VALUE = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal DECFLOAT16_MAX_VALUE = new BigDecimal("9.999999999999999E384");
    private static final BigDecimal DECFLOAT16_MIN_VALUE = new BigDecimal("-9.999999999999999E384");
    static final int DECFLOAT16_MIN_EXP = -383;
    private int precision_ = 16;
    String specialValue_ = null;
    private AS400DecFloat typeConverter_;
    private BigDecimal value_;
    private JDProperties properties_;
    private int roundingMode;
    private String roundingModeStr;
    private int vrm_;

    SQLDecFloat16(SQLConversionSettings sQLConversionSettings, int n, JDProperties jDProperties) {
        super(sQLConversionSettings);
        this.roundingModeStr = jDProperties.getString(74);
        this.typeConverter_ = new AS400DecFloat(this.precision_);
        this.value_ = default_;
        this.vrm_ = n;
        this.properties_ = jDProperties;
        if (this.roundingModeStr.equals("up")) {
            this.roundingMode = 0;
        } else if (this.roundingModeStr.equals("down")) {
            this.roundingMode = 1;
        } else if (this.roundingModeStr.equals("ceiling")) {
            this.roundingMode = 2;
        } else if (this.roundingModeStr.equals("floor")) {
            this.roundingMode = 3;
        } else if (this.roundingModeStr.equals("half up")) {
            this.roundingMode = 4;
        } else if (this.roundingModeStr.equals("half down")) {
            this.roundingMode = 5;
        } else if (this.roundingModeStr.equals("half even")) {
            this.roundingMode = 6;
        }
        this.roundingModeStr = "ROUND_" + this.roundingModeStr.toUpperCase().replace(' ', '_');
    }

    @Override
    public Object clone() {
        return new SQLDecFloat16(this.settings_, this.vrm_, this.properties_);
    }

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        block2: {
            try {
                this.value_ = (BigDecimal)this.typeConverter_.toObject(byArray, n);
                this.specialValue_ = null;
            }
            catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
                this.specialValue_ = this.getSpecialValue(extendedIllegalArgumentException.toString());
                if (this.specialValue_ != null || bl) break block2;
                throw extendedIllegalArgumentException;
            }
        }
    }

    @Override
    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        try {
            if (this.specialValue_ == null) {
                this.typeConverter_.toBytes(this.value_, byArray, n);
            } else {
                this.typeConverter_.toBytes(this.specialValue_, byArray, n);
            }
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            JDError.throwSQLException((Object)this, "07006", extendedIllegalArgumentException);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int n) throws SQLException {
        BigDecimal bigDecimal;
        block18: {
            bigDecimal = null;
            this.specialValue_ = null;
            if (object instanceof String) {
                try {
                    this.specialValue_ = this.getSpecialValue((String)object);
                    if (this.specialValue_ != null) break block18;
                    if (((String)object).indexOf(44) != -1) {
                        bigDecimal = new BigDecimal(((String)object).replace(',', '.'));
                        break block18;
                    }
                    bigDecimal = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    JDError.throwSQLException((Object)this, "07006", numberFormatException);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (object instanceof Number) {
                this.specialValue_ = this.getSpecialValue(object.toString());
                if (this.specialValue_ == null) {
                    bigDecimal = new BigDecimal(object.toString());
                }
            } else if (object instanceof Boolean) {
                bigDecimal = (Boolean)object == true ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
            } else {
                if (JDTrace.isTraceOn()) {
                    if (object == null) {
                        JDTrace.logInformation(this, "Unable to assign null object");
                    } else {
                        JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                    }
                }
                JDError.throwSQLException((Object)this, "07006");
            }
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            this.value_ = null;
            return;
        }
        this.value_ = AS400DecFloat.roundByMode(bigDecimal, 16, this.roundingModeStr);
        if (this.value_.compareTo(DECFLOAT16_MAX_VALUE) > 0) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
            this.value_ = DECFLOAT16_MAX_VALUE;
        } else if (this.value_.compareTo(DECFLOAT16_MIN_VALUE) < 0) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
            this.value_ = DECFLOAT16_MIN_VALUE;
        }
    }

    @Override
    public int getSQLType() {
        return 38;
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 23;
    }

    @Override
    public String getJavaClassName() {
        return "java.math.BigDecimal";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "DECFLOAT";
    }

    @Override
    public int getMaximumPrecision() {
        return this.precision_;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 996;
    }

    @Override
    public int getPrecision() {
        return this.precision_;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 1111;
    }

    @Override
    public String getTypeName() {
        return "DECFLOAT";
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        if (this.specialValue_ == null) {
            return SQLDataFactory.getPrecision(this.value_);
        }
        return this.specialValue_.length();
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
            return null;
        }
        if (n >= 0) {
            if (n >= this.value_.scale()) {
                return this.value_.setScale(n);
            }
            this.truncated_ = this.value_.scale() - n;
            return this.value_.setScale(n, this.roundingMode);
        }
        return this.value_;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            return false;
        }
        return this.value_.compareTo(BigDecimal.valueOf(0L)) != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Double("-NaN").byteValue();
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Double("NaN").byteValue();
            }
            return new Double(this.specialValue_).byteValue();
        }
        if (this.value_.compareTo(BYTE_MAX_VALUE) > 0 || this.value_.compareTo(BYTE_MIN_VALUE) < 0) {
            if (this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0) {
                if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
                    if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
                        this.truncated_ = 15;
                        this.outOfBounds_ = true;
                    } else {
                        this.truncated_ = 7;
                        this.outOfBounds_ = true;
                    }
                } else {
                    this.truncated_ = 3;
                    this.outOfBounds_ = true;
                }
            } else {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
        }
        return this.value_.byteValue();
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Double("-NaN");
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Double("NaN");
            }
            return new Double(this.specialValue_);
        }
        if (this.value_.compareTo(DOUBLE_MAX_VALUE) > 0 || this.value_.compareTo(DOUBLE_MIN_VALUE) < 0) {
            this.truncated_ = 8;
            this.outOfBounds_ = true;
        }
        return this.value_.doubleValue();
    }

    @Override
    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Float("-NaN").floatValue();
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Float("NaN").floatValue();
            }
            return new Float(this.specialValue_).floatValue();
        }
        if (this.value_.compareTo(FLOAT_MAX_VALUE) > 0 || this.value_.compareTo(FLOAT_MIN_VALUE) < 0) {
            this.truncated_ = this.value_.compareTo(DOUBLE_MAX_VALUE) > 0 || this.value_.compareTo(DOUBLE_MIN_VALUE) < 0 ? 12 : 4;
        }
        return this.value_.floatValue();
    }

    @Override
    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
            if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
                this.truncated_ = 12;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 4;
                this.outOfBounds_ = true;
            }
        }
        return this.value_.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
            this.truncated_ = 8;
            this.outOfBounds_ = true;
        }
        return this.value_.longValue();
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            return this.specialValue_;
        }
        return this.value_;
    }

    @Override
    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        if (this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0) {
            if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
                if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
                    this.truncated_ = 14;
                    this.outOfBounds_ = true;
                } else {
                    this.truncated_ = 6;
                    this.outOfBounds_ = true;
                }
            } else {
                this.truncated_ = 2;
                this.outOfBounds_ = true;
            }
        }
        return this.value_.shortValue();
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.specialValue_ != null) {
            return this.specialValue_;
        }
        String string = this.value_.toString();
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    private String getSpecialValue(String string) {
        int n = -1;
        n = string.toUpperCase().indexOf("SNAN");
        if (n != -1) {
            if (n > 0 && string.charAt(n - 1) == '-') {
                return "-SNaN";
            }
            return "SNaN";
        }
        n = string.toUpperCase().indexOf("NAN");
        if (n != -1) {
            if (n > 0 && string.charAt(n - 1) == '-' || n > 1 && string.charAt(n - 2) == '-') {
                return "-NaN";
            }
            return String.valueOf(Double.NaN);
        }
        n = string.toUpperCase().indexOf("INF");
        if (n != -1) {
            if (n != 0 && string.charAt(n - 1) == '-') {
                return String.valueOf(Double.NEGATIVE_INFINITY);
            }
            return String.valueOf(Double.POSITIVE_INFINITY);
        }
        return null;
    }

    @Override
    public String getNString() throws SQLException {
        return this.getString();
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

