/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNClobLocator
implements SQLLocator {
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private String savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;

    SQLNClobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, true);
        this.maxLength_ = n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    @Override
    public Object clone() {
        return new SQLNClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    @Override
    public void setHandle(int n) {
        this.locator_.setHandle(n);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    @Override
    public int getHandle() {
        return this.locator_.getHandle();
    }

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.convertFromRawBytes(byArray, n, convTable, false);
    }

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    @Override
    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    @Override
    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
    }

    @Override
    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            this.truncated_ = n2 > this.maxLength_ ? n2 - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob || object instanceof NClob || object instanceof SQLXML)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        Object object;
        int n = this.scale_;
        if (n == -1) {
            try {
                n = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object2 = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object2;
        } else if (object2 instanceof Reader) {
            this.value_ = SQLDataBase.getStringFromReader((Reader)object2, n, this);
            this.savedObject_ = this.value_;
        } else if (object2 instanceof Clob) {
            if (object2 instanceof AS400JDBCClobLocator) {
                Object object3 = object = (AS400JDBCClobLocator)object2;
                synchronized (object3) {
                    if (((AS400JDBCClobLocator)object).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)object).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCClobLocator)object).savedScale_;
                        ((AS400JDBCClobLocator)object).savedObject_ = null;
                        if (!(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            object = (Clob)object2;
            this.value_ = object.getSubString(1L, (int)object.length());
        } else if (object2 instanceof SQLXML) {
            object = (SQLXML)object2;
            this.value_ = object.getString();
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int n2 = this.value_.length();
        if (n2 > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToServer() throws SQLException {
        block58: {
            try {
                Object object = this.savedObject_;
                if (object instanceof String) {
                    String string = (String)object;
                    byte[] byArray = this.converter_.stringToByteArray(string);
                    this.locator_.writeData(0L, byArray, true);
                    break block58;
                }
                if (object instanceof Reader) {
                    int n = this.scale_ * 2;
                    if (n == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block58;
                    }
                    if (n > 0) {
                        try {
                            int n2 = n < 1000000 ? n : 1000000;
                            int n3 = this.settings_.getBidiStringType();
                            if (n3 == -1) {
                                n3 = this.converter_.bidiStringType_;
                            }
                            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n3);
                            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            ReaderInputStream readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n2);
                            try {
                                byte[] byArray = new byte[n2];
                                int n4 = 0;
                                int n5 = readerInputStream.read(byArray, 0, n2);
                                while (n5 > -1 && n4 < n) {
                                    this.locator_.writeData(n4 / 2, byArray, 0, n5, true);
                                    int n6 = n - (n4 += n5);
                                    if (n6 < n2) {
                                        n2 = n6;
                                        if (readerInputStream.available() == 0 && n2 != 0) {
                                            readerInputStream.close();
                                            readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n2);
                                        }
                                    }
                                    n5 = readerInputStream.read(byArray, 0, n2);
                                }
                                if (n4 < n) {
                                    JDError.throwSQLException((Object)this, "07006");
                                }
                                break block58;
                            }
                            finally {
                                try {
                                    readerInputStream.close();
                                }
                                catch (Exception exception) {
                                    JDTrace.logException(this, "writeToServer stream.close()", exception);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                        }
                        break block58;
                    }
                    if (n == -2) {
                        try {
                            int n7 = 1000000;
                            int n8 = this.settings_.getBidiStringType();
                            if (n8 == -1) {
                                n8 = this.converter_.bidiStringType_;
                            }
                            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n8);
                            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            ReaderInputStream readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n7);
                            try {
                                byte[] byArray = new byte[n7];
                                int n9 = 0;
                                int n10 = readerInputStream.read(byArray, 0, n7);
                                while (n10 > -1) {
                                    this.locator_.writeData(n9 / 2, byArray, 0, n10, true);
                                    n9 += n10;
                                    n10 = readerInputStream.read(byArray, 0, n7);
                                }
                                break block58;
                            }
                            finally {
                                try {
                                    readerInputStream.close();
                                }
                                catch (Exception exception) {
                                    JDTrace.logException(this, "writeToServer stream2.close()", exception);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                        }
                        break block58;
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block58;
                }
                if (object instanceof InputStream) {
                    int n = this.scale_ * 2;
                    if (n == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block58;
                    }
                    if (n > 0) {
                        InputStream inputStream = (InputStream)this.savedObject_;
                        int n11 = n < 1000000 ? n : 1000000;
                        byte[] byArray = new byte[n11];
                        try {
                            int n12 = 0;
                            int n13 = inputStream.read(byArray, 0, n11);
                            while (n13 > -1 && n12 < n) {
                                this.locator_.writeData((long)n12 / 2L, byArray, 0, n13, true);
                                int n14 = n - (n12 += n13);
                                if (n14 < n11) {
                                    n11 = n14;
                                }
                                n13 = inputStream.read(byArray, 0, n11);
                            }
                            if (n12 < n) {
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block58;
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                        }
                        break block58;
                    }
                    if (n == -2) {
                        InputStream inputStream = (InputStream)this.savedObject_;
                        int n15 = 1000000;
                        byte[] byArray = new byte[n15];
                        try {
                            int n16 = 0;
                            int n17 = inputStream.read(byArray, 0, n15);
                            while (n17 > -1) {
                                this.locator_.writeData((long)n16 / 2L, byArray, 0, n17, true);
                                n16 += n17;
                                n17 = inputStream.read(byArray, 0, n15);
                            }
                            break block58;
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException((Object)this, "HY000", iOException);
                            break block58;
                        }
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block58;
                }
                if (object instanceof Clob) {
                    Clob clob;
                    boolean bl = false;
                    if (object instanceof AS400JDBCClobLocator) {
                        clob = (AS400JDBCClobLocator)object;
                        AS400JDBCClobLocator aS400JDBCClobLocator = clob;
                        synchronized (aS400JDBCClobLocator) {
                            if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                                this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                                this.savedObjectWrittenToServer_ = false;
                                this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                                ((AS400JDBCClobLocator)clob).savedObject_ = null;
                                this.writeToServer();
                                this.savedObjectWrittenToServer_ = false;
                                return;
                            }
                        }
                    }
                    if (!bl) {
                        int n;
                        clob = (Clob)object;
                        int n18 = (int)clob.length();
                        if (n18 < (n = 1000000)) {
                            n = n18;
                        }
                        int n19 = 1;
                        AS400JDBCClobLocator aS400JDBCClobLocator = new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
                        while (n19 <= n18) {
                            String string = clob.getSubString(n19, n);
                            aS400JDBCClobLocator.setString(n19, string);
                            if (n18 - (n19 += n) >= n) continue;
                            n = n18 - n19 + 1;
                        }
                        bl = true;
                        break block58;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block58;
                }
                if (object instanceof SQLXML) {
                    SQLXML sQLXML = (SQLXML)object;
                    String string = sQLXML.getString();
                    byte[] byArray = this.converter_.stringToByteArray(string);
                    this.locator_.writeData(0L, byArray, 0, byArray.length, true);
                } else {
                    JDError.throwSQLException((Object)this, "07006");
                }
            }
            finally {
                this.savedObjectWrittenToServer_ = true;
            }
        }
        this.scale_ = (int)this.locator_.getLength();
    }

    @Override
    public int getSQLType() {
        return 34;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    @Override
    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCNClobLocator";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "NCLOB";
    }

    @Override
    public int getMaximumPrecision() {
        return 0x3FFFFFFE;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 968;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 2011;
    }

    @Override
    public String getTypeName() {
        return "NCLOB";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.maxLength_;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public void clearTruncated() {
        this.truncated_ = 0;
    }

    @Override
    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
            }
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    @Override
    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    @Override
    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return string;
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCNClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        return string;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCSQLXML(this.value_, this.maxLength_);
        }
        return new AS400JDBCSQLXML(this.getString());
    }

    @Override
    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }

    @Override
    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    @Override
    public Object getSavedValue() {
        return this.savedValue_;
    }
}

