/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCFieldedTimestamp;
import com.ibm.as400.access.AS400JDBCTimestamp;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.CharConversionException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLTimestamp
extends SQLDataBase {
    static final String copyright2 = "Copyright (C) 1997-2013 International Business Machines Corporation and others.";
    static boolean jdk14 = false;
    private int year_;
    private int month_;
    private int day_;
    private int hour_;
    private int minute_;
    private int second_;
    private long picos_;
    private int length_;

    SQLTimestamp(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.length_ = n;
        this.year_ = 0;
        this.month_ = 0;
        this.day_ = 0;
        this.hour_ = 0;
        this.minute_ = 0;
        this.second_ = 0;
        this.picos_ = 0L;
    }

    @Override
    public Object clone() {
        return new SQLTimestamp(this.length_, this.settings_);
    }

    public void setTimestampFieldsFromString(String string) throws SQLException {
        try {
            int n = string.length();
            if (n < 10) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Invalid timestamp length " + string);
                }
                JDError.throwSQLException("07006", string);
            }
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Timestamp missing - " + string);
                }
                JDError.throwSQLException("07006", string);
            }
            this.year_ = Integer.parseInt(string.substring(0, 4));
            this.month_ = Integer.parseInt(string.substring(5, 7)) - 1;
            this.day_ = Integer.parseInt(string.substring(8, 10));
            this.hour_ = n >= 13 ? Integer.parseInt(string.substring(11, 13)) : 0;
            this.minute_ = n >= 16 ? Integer.parseInt(string.substring(14, 16)) : 0;
            this.second_ = n >= 19 ? Integer.parseInt(string.substring(17, 19)) : 0;
            long l = 0L;
            if (n > 20) {
                String string2 = string.substring(20).trim() + "00000000000000";
                this.picos_ = Long.parseLong(string2.substring(0, 12));
            } else {
                this.picos_ = 0L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + string, numberFormatException);
            }
            JDError.throwSQLException("07006", string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + string, stringIndexOutOfBoundsException);
            }
            JDError.throwSQLException("07006", string);
        }
    }

    public static Timestamp stringToTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            Object object;
            int n = string.length();
            if (n < 10) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Invalid timestamp length " + string);
                }
                JDError.throwSQLException("07006", string);
            }
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(null, "Timestamp missing - " + string);
                }
                JDError.throwSQLException("07006", string);
            }
            int n2 = Integer.parseInt(string.substring(0, 4));
            if (calendar == null) {
                calendar = AS400Calendar.getGregorianInstance();
                calendar.setLenient(false);
            } else {
                calendar = AS400Calendar.getConversionCalendar(calendar);
            }
            calendar.set(1, n2);
            calendar.set(2, Integer.parseInt(string.substring(5, 7)) - 1);
            calendar.set(5, Integer.parseInt(string.substring(8, 10)));
            if (n >= 13) {
                calendar.set(11, Integer.parseInt(string.substring(11, 13)));
            } else {
                calendar.set(11, 0);
            }
            if (n >= 16) {
                calendar.set(12, Integer.parseInt(string.substring(14, 16)));
            } else {
                calendar.set(12, 0);
            }
            if (n >= 19) {
                calendar.set(13, Integer.parseInt(string.substring(17, 19)));
            } else {
                calendar.set(13, 0);
            }
            long l = 0L;
            if (n > 20) {
                object = string.substring(20).trim() + "00000000000000";
                l = Long.parseLong(((String)object).substring(0, 12));
            } else {
                l = 0L;
            }
            object = null;
            try {
                long l2 = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
                if (l % 1000L == 0L) {
                    object = new Timestamp(l2);
                    ((Timestamp)object).setNanos((int)(l / 1000L));
                } else {
                    AS400JDBCTimestamp aS400JDBCTimestamp = new AS400JDBCTimestamp(l2, 32);
                    aS400JDBCTimestamp.setPicos(l);
                    object = aS400JDBCTimestamp;
                }
            }
            catch (Exception exception) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logException(null, "Error parsing timestamp " + string, exception);
                }
                JDError.throwSQLException(null, "07006", exception, string);
                return null;
            }
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + string, numberFormatException);
            }
            JDError.throwSQLException("07006", string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing timestamp " + string, stringIndexOutOfBoundsException);
            }
            JDError.throwSQLException("07006", string);
        }
        return new Timestamp(0L);
    }

    public static String timestampToString(Timestamp timestamp, Calendar calendar, SQLConversionSettings sQLConversionSettings) {
        return SQLTimestamp.timestampToString(timestamp, calendar, -1, 26, sQLConversionSettings);
    }

    public static String timestampToStringTrimTrailingZeros(Timestamp timestamp, Calendar calendar, SQLConversionSettings sQLConversionSettings) {
        int n;
        String string = SQLTimestamp.timestampToString(timestamp, calendar, -1, 32, sQLConversionSettings);
        for (n = 32; string.charAt(n - 1) == '0' && n > 21; --n) {
        }
        if (n < 32) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String timestampToString(Timestamp timestamp, Calendar calendar, int n, SQLConversionSettings sQLConversionSettings) {
        return SQLTimestamp.timestampToString(timestamp, calendar, n, 26, sQLConversionSettings);
    }

    public static String timestampToString(Timestamp timestamp, Calendar calendar, int n, int n2, SQLConversionSettings sQLConversionSettings) {
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.setTime(timestamp);
        int n3 = calendar.get(11);
        if (n == 24 && n3 == 0) {
            calendar.add(5, -1);
        }
        int n4 = calendar.get(1);
        int n5 = calendar.get(2);
        int n6 = calendar.get(5);
        int n7 = calendar.get(12);
        int n8 = calendar.get(13);
        long l = 0L;
        if (n2 > 20) {
            l = timestamp instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)timestamp).getPicos() : (long)timestamp.getNanos() * 1000L;
        }
        if (n == 24 && n3 == 0) {
            n3 = 24;
        }
        return SQLTimestamp.buildString(n4, n5, n6, n3, n7, n8, l, n2, sQLConversionSettings);
    }

    private static String buildString(int n, int n2, int n3, int n4, int n5, int n6, long l, int n7, SQLConversionSettings sQLConversionSettings) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        char c2 = ':';
        char c3 = ':';
        if (sQLConversionSettings.getTimestampFormat() == 1) {
            c = '-';
            c2 = '.';
            c3 = '.';
        }
        stringBuffer.append(JDUtilities.padZeros(n, 4));
        stringBuffer.append('-');
        stringBuffer.append(JDUtilities.padZeros(n2 + 1, 2));
        stringBuffer.append('-');
        stringBuffer.append(JDUtilities.padZeros(n3, 2));
        stringBuffer.append(c);
        stringBuffer.append(JDUtilities.padZeros(n4, 2));
        stringBuffer.append(c2);
        stringBuffer.append(JDUtilities.padZeros(n5, 2));
        stringBuffer.append(c3);
        stringBuffer.append(JDUtilities.padZeros(n6, 2));
        if (n7 > 20) {
            stringBuffer.append('.');
            stringBuffer.append(JDUtilities.padZeros(l, 12));
            stringBuffer.setLength(n7);
        }
        stringBuffer.setLength(n7);
        return stringBuffer.toString();
    }

    @Override
    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.year_ = (byArray[n] & 0xF) * 1000 + (byArray[n + 1] & 0xF) * 100 + (byArray[n + 2] & 0xF) * 10 + (byArray[n + 3] & 0xF);
        this.month_ = (byArray[n + 5] & 0xF) * 10 + (byArray[n + 6] & 0xF) - 1;
        this.day_ = (byArray[n + 8] & 0xF) * 10 + (byArray[n + 9] & 0xF);
        this.hour_ = (byArray[n + 11] & 0xF) * 10 + (byArray[n + 12] & 0xF);
        this.minute_ = (byArray[n + 14] & 0xF) * 10 + (byArray[n + 15] & 0xF);
        this.second_ = (byArray[n + 17] & 0xF) * 10 + (byArray[n + 18] & 0xF);
        long l = 100000000000L;
        this.picos_ = 0L;
        for (int i = 20; i < this.length_; ++i) {
            this.picos_ += (long)(byArray[n + i] & 0xF) * l;
            l /= 10L;
        }
    }

    @Override
    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(this.getString().replace(':', '.'));
        stringBuffer.setCharAt(10, '-');
        if (stringBuffer.length() > this.length_) {
            stringBuffer.setLength(this.length_);
        }
        try {
            convTable.stringToByteArray(stringBuffer.toString(), byArray, n);
        }
        catch (CharConversionException charConversionException) {
            JDError.throwSQLException("HY000", charConversionException);
        }
    }

    @Override
    public int getSQLType() {
        return 28;
    }

    @Override
    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        if (object instanceof String) {
            this.setTimestampFieldsFromString((String)object);
        } else if (object instanceof Timestamp) {
            calendar.setTime((Timestamp)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
            this.picos_ = object instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)object).getPicos() : (long)((Timestamp)object).getNanos() * 1000L;
        } else if (object instanceof java.util.Date) {
            calendar.setTime((java.util.Date)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
            this.hour_ = calendar.get(11);
            this.minute_ = calendar.get(12);
            this.second_ = calendar.get(13);
            this.picos_ = (long)calendar.get(14) * 1000000000L;
        } else if (object instanceof AS400JDBCFieldedTimestamp) {
            AS400JDBCFieldedTimestamp aS400JDBCFieldedTimestamp = (AS400JDBCFieldedTimestamp)object;
            this.year_ = aS400JDBCFieldedTimestamp.getYear();
            this.month_ = aS400JDBCFieldedTimestamp.getMonth();
            this.day_ = aS400JDBCFieldedTimestamp.getDay();
            this.hour_ = aS400JDBCFieldedTimestamp.getHour();
            this.minute_ = aS400JDBCFieldedTimestamp.getMinute();
            this.second_ = aS400JDBCFieldedTimestamp.getSecond();
            this.picos_ = aS400JDBCFieldedTimestamp.getPicos();
            this.length_ = aS400JDBCFieldedTimestamp.getLength();
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return this.length_;
    }

    @Override
    public String getJavaClassName() {
        return "java.sql.Timestamp";
    }

    @Override
    public String getLiteralPrefix() {
        return "'";
    }

    @Override
    public String getLiteralSuffix() {
        return "'";
    }

    @Override
    public String getLocalName() {
        return "TIMESTAMP";
    }

    @Override
    public int getMaximumPrecision() {
        return this.length_;
    }

    @Override
    public int getMaximumScale() {
        return this.getScale();
    }

    @Override
    public int getMinimumScale() {
        return this.getScale();
    }

    @Override
    public int getNativeType() {
        return 392;
    }

    @Override
    public int getPrecision() {
        return this.length_;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        int n = this.length_ - 20;
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    @Override
    public int getType() {
        return 93;
    }

    @Override
    public String getTypeName() {
        return "TIMESTAMP";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return this.length_;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 16;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        return new Date(l);
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        if (this.picos_ % 1000L == 0L) {
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos((int)(this.picos_ / 1000L));
            return timestamp;
        }
        AS400JDBCTimestamp aS400JDBCTimestamp = new AS400JDBCTimestamp(l);
        aS400JDBCTimestamp.setPicos(this.picos_);
        return aS400JDBCTimestamp;
    }

    @Override
    public Object getBatchableObject() {
        return new AS400JDBCFieldedTimestamp(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_, this.picos_, this.length_);
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return SQLTimestamp.buildString(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_, this.picos_, this.length_, this.settings_);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        this.truncated_ = 18;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(0, 0, 0, this.hour_, this.minute_, this.second_);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        return new Time(l);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        if (this.picos_ % 1000L == 0L) {
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos((int)(this.picos_ / 1000L));
            return timestamp;
        }
        AS400JDBCTimestamp aS400JDBCTimestamp = new AS400JDBCTimestamp(l);
        aS400JDBCTimestamp.setPicos(this.picos_);
        return aS400JDBCTimestamp;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() throws SQLException {
        this.savedValue_ = SQLTimestamp.buildString(this.year_, this.month_, this.day_, this.hour_, this.minute_, this.second_, this.picos_, this.length_, this.settings_);
    }

    static {
        jdk14 = JVMInfo.isJDK14();
    }
}

