/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

class SerializableInputStream
extends InputStream
implements Serializable {
    static final long serialVersionUID = 4L;
    private byte[] byteArray_;
    private transient ByteArrayInputStream iStream_;

    public SerializableInputStream(InputStream inputStream) throws IOException {
        this.byteArray_ = new byte[inputStream.available()];
        int n = inputStream.read(this.byteArray_);
        if (n < 1 && Trace.traceOn_) {
            Trace.log(1, "Initial read() of 'iStream' into internal buffer returned " + n);
        }
        this.iStream_ = new ByteArrayInputStream(this.byteArray_);
    }

    @Override
    public int available() throws IOException {
        return this.iStream_.available();
    }

    @Override
    public void close() throws IOException {
        this.iStream_.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.iStream_.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.iStream_.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.iStream_.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.iStream_.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.iStream_.read(byArray, n, n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.iStream_ = new ByteArrayInputStream(this.byteArray_);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.iStream_.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.iStream_.skip(l);
    }
}

