/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterFile;
import com.ibm.as400.access.PrinterFileImpl;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileOutputStreamImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SpooledFileOutputStream
extends OutputStream {
    private transient AS400 system_;
    private transient SpooledFileOutputStreamImpl impl_;

    public SpooledFileOutputStream(AS400 aS400, PrintParameterList printParameterList, PrinterFile printerFile, OutputQueue outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        this.chooseImpl();
        this.system_.connectService(1);
        PrinterFileImpl printerFileImpl = null;
        if (printerFile != null) {
            if (printerFile.getImpl() == null) {
                printerFile.chooseImpl();
            }
            printerFileImpl = (PrinterFileImpl)printerFile.getImpl();
        }
        OutputQueueImpl outputQueueImpl = null;
        if (outputQueue != null) {
            if (outputQueue.getImpl() == null) {
                outputQueue.chooseImpl();
            }
            outputQueueImpl = (OutputQueueImpl)outputQueue.getImpl();
        }
        this.impl_.createSpooledFileOutputStream(this.system_.getImpl(), printParameterList, printerFileImpl, outputQueueImpl);
    }

    private void chooseImpl() {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to use SpooledFileOutputStream before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (SpooledFileOutputStreamImpl)this.system_.loadImpl2("com.ibm.as400.access.SpooledFileOutputStreamImplRemote", "com.ibm.as400.access.SpooledFileOutputStreamImplProxy");
    }

    @Override
    public void close() throws IOException {
        this.impl_.close();
    }

    @Override
    public void flush() throws IOException {
        this.impl_.flush();
    }

    public SpooledFile getSpooledFile() throws IOException {
        NPCPIDSplF nPCPIDSplF;
        SpooledFile spooledFile;
        block2: {
            spooledFile = null;
            nPCPIDSplF = this.impl_.getSpooledFile();
            try {
                nPCPIDSplF.setConverter(new Converter((int)this.system_.getCcsid(), (AS400)this.system_).impl);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!Trace.isTraceErrorOn()) break block2;
                Trace.log(2, "Error initializing converter for print object", (Throwable)unsupportedEncodingException);
            }
        }
        spooledFile = new SpooledFile(this.system_, nPCPIDSplF, null);
        return spooledFile;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.impl_.write(byArray, n, n2);
    }
}

