/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserIndexNativeImpl;
import com.ibm.as400.access.UserIndexNativeImplILE;
import java.io.IOException;
import java.util.Arrays;

public class UserIndex {
    public static final int FIND_EQUALS = 1;
    public static final int FIND_GREATER = 2;
    public static final int FIND_LESSER = 3;
    public static final int FIND_NOT_LESSER = 4;
    public static final int FIND_NOT_GREATER = 5;
    public static final int FIND_FIRST = 6;
    public static final int FIND_LAST = 7;
    public static final int FIND_BETWEEN = 8;
    public static final byte FIXED_LENGTH_ENTRIES = -58;
    public static final byte VARIABLE_LENGTH_ENTRIES = -27;
    public static final byte INSERTION_BY_KEY = -15;
    public static final byte NO_INSERTION_BY_KEY = -16;
    public static final byte IMMEDIATE_UPDATE = -15;
    public static final byte NO_IMMEDIATE_UPDATE = -16;
    public static final byte OPTIMIZE_FOR_RANDOM_REFERENCES = -16;
    public static final byte OPTIMIZE_FOR_SEQUENTIAL_REFERENCES = -15;
    public static final int RULE_INSERT = 1;
    public static final int RULE_INSERT_REPLACE = 2;
    public static final int RULE_INSERT_NO_REPLACE = 3;
    private static byte[] IDXA0100 = new byte[]{-55, -60, -25, -63, -16, -15, -16, -16};
    private boolean mustUseNativeMethods_ = false;
    AS400 system_;
    String path_;
    private byte[] insertKeyValueBytes_;
    private byte[] insertOptionBytes_;
    private byte entryLengthAttribute_;
    private int entryLength_;
    private int keyLength_;
    private int valueLength_;
    private int handle_;
    private byte[] objectNameBytes_;
    private byte[] findOptionBytes_;
    UserIndexNativeImpl impl_;
    boolean supported_ = false;

    public UserIndex(AS400 aS400, String string) throws Exception {
        if (!this.supported_) {
            throw new Exception("This class is unsupported because the native methods do not exist on the IBM i.  Please open an RFE if this support is required.");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserIndex object.");
        }
        this.system_ = aS400;
        this.path_ = string;
        this.objectNameBytes_ = new byte[20];
        Arrays.fill(this.objectNameBytes_, (byte)64);
        if (string.indexOf("/QSYS.LIB/") == 0) {
            string = string.substring(9);
        }
        if (string.charAt(0) != '/') {
            throw new Exception("Path does not begin with / : " + string);
        }
        int n = string.indexOf(".LIB/");
        if (n < 2) {
            throw new Exception("Path does not contain .LIB / : " + string);
        }
        String string2 = string.substring(1, n);
        byte[] byArray = string2.getBytes("IBM-037");
        int n2 = string.indexOf(".USRIDX");
        if (n2 < n) {
            throw new Exception("Path does not contain .USRIDX / : " + string);
        }
        String string3 = string.substring(n + 5, n2);
        byte[] byArray2 = string3.getBytes("IBM-037");
        System.arraycopy(byArray2, 0, this.objectNameBytes_, 0, byArray2.length);
        System.arraycopy(byArray, 0, this.objectNameBytes_, 10, byArray.length);
        this.handle_ = 0;
        this.impl_ = new UserIndexNativeImplILE();
    }

    public void create(String string, byte by, int n, byte by2, int n2, byte by3, byte by4, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectAlreadyExistsException, Exception {
        this.entryLengthAttribute_ = by;
        this.entryLength_ = n;
        this.keyLength_ = n2;
        this.valueLength_ = this.entryLength_ - n2;
        byte[] byArray = string.getBytes("IBM-037");
        byte[] byArray2 = string2.getBytes("IBM-037");
        byte[] byArray3 = string3.getBytes("IBM-037");
        int n3 = n - n2;
        if (n3 <= 0) {
            throw new Exception("Entry lentgh attribute of " + n + " not correct for key length of " + n2);
        }
        if (this.entryLengthAttribute_ != -58) {
            throw new Exception("Entry lenth attribute of " + by + " not supported:  Valid values = -58");
        }
        this.handle_ = this.impl_.createAndOpen(this.objectNameBytes_, byArray, by, n, by2, n2, by3, by4, byArray2, byArray3);
    }

    public void delete() {
        this.impl_.delete(this.handle_, this.objectNameBytes_);
        this.handle_ = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEntry(String string, String string2, int n) throws Exception {
        byte[] byArray = string.getBytes("IBM-037");
        byte[] byArray2 = string2.getBytes("IBM-037");
        if (this.handle_ == 0) {
            this.open();
        }
        if (this.entryLengthAttribute_ == -58) {
            if (byArray2.length > this.entryLength_ - this.keyLength_) {
                throw new Exception("value too long " + string2);
            }
        } else {
            throw new Exception("EntryLengthAttribute of " + this.entryLengthAttribute_ + " Not yet supported");
        }
        if (this.insertOptionBytes_ == null) {
            this.insertOptionBytes_ = new byte[20];
        }
        if (this.insertKeyValueBytes_ == null) {
            this.insertKeyValueBytes_ = new byte[this.entryLength_];
        }
        byte[] byArray3 = this.insertKeyValueBytes_;
        synchronized (this.insertKeyValueBytes_) {
            Arrays.fill(this.insertKeyValueBytes_, (byte)64);
            if (this.entryLengthAttribute_ == -58) {
                System.arraycopy(byArray, 0, this.insertKeyValueBytes_, 0, byArray.length);
                System.arraycopy(byArray2, 0, this.insertKeyValueBytes_, this.keyLength_, byArray2.length);
            }
            UserIndex.resetOptionBytes(this.insertOptionBytes_);
            UserIndex.setOptionBytesRule(this.insertOptionBytes_, n);
            UserIndex.setOptionBytesOccCount(this.insertOptionBytes_, 1);
            if (this.handle_ == 0) {
                this.open();
            }
            this.impl_.insertEntry(this.handle_, this.insertKeyValueBytes_, this.insertOptionBytes_);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public void insertEntry(byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (this.handle_ == 0) {
            this.open();
        }
        this.impl_.insertEntry(this.handle_, byArray, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] findEntries(String string, int n, int n2) throws Exception {
        byte[] byArray;
        String[][] stringArray = null;
        if (this.handle_ == 0) {
            this.open();
        }
        if (this.entryLengthAttribute_ != -58) {
            throw new Exception("Unsupported entryLengthAttribute=0x" + Integer.toHexString(0xFF & this.entryLengthAttribute_));
        }
        byte[] byArray2 = string.getBytes("IBM-037");
        byte[] byArray3 = new byte[n2 * this.entryLength_];
        if (n2 == 1) {
            if (this.findOptionBytes_ == null) {
                this.findOptionBytes_ = new byte[40];
            }
            byArray = this.findOptionBytes_;
        } else {
            byArray = new byte[10 + 4 * n2];
        }
        byte[] byArray4 = byArray;
        synchronized (byArray) {
            UserIndex.setOptionBytesOccCount(byArray, n2);
            UserIndex.setOptionBytesRule(byArray, n);
            UserIndex.setOptionBytesArgLength(byArray, byArray2.length);
            this.impl_.findEntries(this.handle_, byArray3, byArray, byArray2);
            int n3 = UserIndex.getOptionBytesReturnCount(byArray);
            stringArray = new String[n3][];
            if (this.entryLengthAttribute_ == -58) {
                for (int i = 0; i < n3; ++i) {
                    int n4 = i * this.entryLength_;
                    stringArray[i] = new String[2];
                    stringArray[i][0] = new String(byArray3, n4, this.keyLength_, "IBM-037");
                    stringArray[i][1] = new String(byArray3, n4 + this.keyLength_, this.valueLength_, "IBM-037");
                }
            } else {
                throw new Exception("EntryLengthAttribute of " + this.entryLengthAttribute_ + " Not yet supported");
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return stringArray;
        }
    }

    public void findEntries(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        if (this.handle_ == 0) {
            this.open();
        }
        this.impl_.findEntries(this.handle_, byArray, byArray2, byArray3);
    }

    public String toString() {
        return "UserIndex " + this.path_;
    }

    public boolean isMustUseNativeMethods() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if user index must use native methods:", this.mustUseNativeMethods_);
        }
        return this.mustUseNativeMethods_;
    }

    public void setMustUseNativeMethods(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting if user index must use native methods:", bl);
        }
        this.mustUseNativeMethods_ = bl;
    }

    private void open() {
        this.handle_ = this.impl_.open(this.objectNameBytes_);
        byte[] byArray = new byte[60];
        this.impl_.getAttributes(byArray, IDXA0100, this.objectNameBytes_);
        this.entryLengthAttribute_ = byArray[28];
        this.entryLength_ = (0xFF & byArray[36]) * 0x1000000 + (0xFF & byArray[37]) * 65536 + (0xFF & byArray[38]) * 256 + (0xFF & byArray[39]);
        this.keyLength_ = (0xFF & byArray[44]) * 0x1000000 + (0xFF & byArray[45]) * 65536 + (0xFF & byArray[46]) * 256 + (0xFF & byArray[47]);
        this.valueLength_ = this.entryLength_ - this.keyLength_;
    }

    public static void resetOptionBytes(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
    }

    public static void setOptionBytesRule(byte[] byArray, int n) {
        byArray[0] = 0;
        byArray[1] = (byte)(n & 0xFF);
    }

    public static void setOptionBytesArgLength(byte[] byArray, int n) {
        byArray[2] = (byte)(n / 256 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
    }

    public static void setOptionBytesOccCount(byte[] byArray, int n) {
        byArray[6] = (byte)(n / 256 & 0xFF);
        byArray[7] = (byte)(n & 0xFF);
    }

    public static int getOptionBytesReturnCount(byte[] byArray) {
        return (byArray[8] & 0xFF) * 256 + (byArray[9] & 0xFF);
    }
}

