/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSRandomAccessFileImplRemote;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.RemoteCommandImplRemote;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpaceImpl;
import java.beans.PropertyVetoException;
import java.io.FileNotFoundException;
import java.io.IOException;

class UserSpaceImplRemote
implements UserSpaceImpl {
    protected AS400ImplRemote system_ = null;
    protected String path_ = null;
    protected String library_ = null;
    protected String name_ = null;
    protected boolean mustUseProgramCall_ = false;
    protected boolean mustUseSockets_ = false;
    protected ConverterImplRemote converter_;
    private ProgramParameter nameParameter_ = null;
    private ProgramParameter errorCodeParameter_ = null;
    protected RemoteCommandImpl remoteCommand_;
    private Boolean runOnThread_ = RemoteCommandImpl.OFF_THREAD;
    private IFSRandomAccessFileImplRemote file_;

    UserSpaceImplRemote() {
    }

    private AS400Exception buildException() throws AS400SecurityException, ObjectDoesNotExistException {
        AS400Message[] aS400MessageArray = this.remoteCommand_.getMessageList();
        String string = aS400MessageArray[0].getID();
        if (string.equals("CPF9801") || string.equals("CPF2105")) {
            Trace.log(2, "Object does not exist: " + this.path_);
            throw new ObjectDoesNotExistException(this.path_, 2);
        }
        if (string.equals("CPF9802") || string.equals("CPF2189")) {
            Trace.log(2, "User is not authorized to object: " + this.path_);
            throw new AS400SecurityException(this.path_, 4);
        }
        if (string.equals("CPF9810") || string.equals("CPF2209") || string.equals("CPF2110")) {
            Trace.log(2, "Library does not exist: " + this.path_);
            throw new ObjectDoesNotExistException(this.path_, 1);
        }
        if (string.equals("CPF9820") || string.equals("CPF2182")) {
            Trace.log(2, "User is not authorized to library: " + this.path_);
            throw new AS400SecurityException(this.path_, 3);
        }
        if (string.equals("CPF2283")) {
            String string2 = "/QSYS.LIB/" + this.converter_.byteArrayToString(aS400MessageArray[0].getSubstitutionData()).trim() + ".AUTL";
            Trace.log(2, "Object does not exist: " + string2);
            throw new ObjectDoesNotExistException(string2, 2);
        }
        return new AS400Exception(aS400MessageArray);
    }

    @Override
    public void close() throws IOException {
        if (this.file_ != null) {
            this.file_.close();
            this.file_ = null;
        }
    }

    @Override
    public void create(byte[] byArray, int n, boolean bl, String string, byte by, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray2;
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] programParameterArray = new ProgramParameter[11];
        programParameterArray[0] = this.nameParameter_;
        programParameterArray[1] = new ProgramParameter(UserSpaceImplRemote.padByteArray(this.converter_.stringToByteArray(string), 10));
        programParameterArray[2] = new ProgramParameter(BinaryConverter.intToByteArray(n));
        programParameterArray[3] = new ProgramParameter(new byte[]{by});
        programParameterArray[4] = new ProgramParameter(UserSpaceImplRemote.padByteArray(this.converter_.stringToByteArray(string3), 10));
        programParameterArray[5] = new ProgramParameter(UserSpaceImplRemote.padByteArray(this.converter_.stringToByteArray(string2), 50));
        if (bl) {
            byte[] byArray3 = new byte[10];
            byArray3[0] = 92;
            byArray3[1] = -24;
            byArray3[2] = -59;
            byArray3[3] = -30;
            byArray3[4] = 64;
            byArray3[5] = 64;
            byArray3[6] = 64;
            byArray3[7] = 64;
            byArray3[8] = 64;
            byArray2 = byArray3;
            byArray3[9] = 64;
        } else {
            byte[] byArray4 = new byte[10];
            byArray4[0] = 92;
            byArray4[1] = -43;
            byArray4[2] = -42;
            byArray4[3] = 64;
            byArray4[4] = 64;
            byArray4[5] = 64;
            byArray4[6] = 64;
            byArray4[7] = 64;
            byArray4[8] = 64;
            byArray2 = byArray4;
            byArray4[9] = 64;
        }
        programParameterArray[6] = new ProgramParameter(byArray2);
        programParameterArray[7] = this.errorCodeParameter_;
        programParameterArray[8] = new ProgramParameter(byArray);
        programParameterArray[9] = new ProgramParameter(new byte[]{0, 0, 0, 0});
        programParameterArray[10] = new ProgramParameter(new byte[]{n > 0xFFF000 ? (byte)-16 : -15});
        ProgramParameter[] programParameterArray2 = programParameterArray;
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSCRTUS", programParameterArray2, this.runOnThread_)) {
            throw this.buildException();
        }
    }

    private static byte[] padByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = byArray.length; i < n; ++i) {
            byArray2[i] = 64;
        }
        return byArray2;
    }

    @Override
    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{this.nameParameter_, this.errorCodeParameter_};
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSDLTUS", programParameterArray, this.runOnThread_)) {
            throw this.buildException();
        }
    }

    @Override
    public byte getInitialValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.retrieveAttributes()[13];
    }

    @Override
    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return BinaryConverter.byteArrayToInt(this.retrieveAttributes(), 8);
    }

    @Override
    public boolean isAutoExtendible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.retrieveAttributes()[12] == -15;
    }

    protected byte[] retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(24), new ProgramParameter(new byte[]{0, 0, 0, 24}), new ProgramParameter(new byte[]{-30, -41, -61, -63, -16, -15, -16, -16}), this.nameParameter_, this.errorCodeParameter_};
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSRUSAT", programParameterArray, this.runOnThread_)) {
            throw this.buildException();
        }
        return programParameterArray[0].getOutputData();
    }

    @Override
    public int read(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.mustUseProgramCall_) {
            this.setupNameParameter();
            ProgramParameter[] programParameterArray = new ProgramParameter[]{this.nameParameter_, new ProgramParameter(BinaryConverter.intToByteArray(n + 1)), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(n3)};
            if (this.remoteCommand_ == null) {
                this.setupRemoteCommand();
            }
            if (!this.remoteCommand_.runProgram("QSYS", "QUSRTVUS", programParameterArray, this.runOnThread_)) {
                String string = this.remoteCommand_.getMessageList()[0].getID();
                if (!string.equals("CPF3C14") && !string.equals("CPD3C14")) {
                    throw this.buildException();
                }
                int n4 = this.getLength();
                if (n4 < n) {
                    return -1;
                }
                n3 = n4 - n;
                try {
                    programParameterArray[2].setInputData(BinaryConverter.intToByteArray(n3));
                    programParameterArray[3].setOutputDataLength(n3);
                }
                catch (PropertyVetoException propertyVetoException) {
                    Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
                    throw new InternalErrorException(10);
                }
                if (!this.remoteCommand_.runProgram("QSYS", "QUSRTVUS", programParameterArray, this.runOnThread_)) {
                    throw this.buildException();
                }
            }
            System.arraycopy(programParameterArray[3].getOutputData(), 0, byArray, n2, n3);
            return n3;
        }
        this.setupFile();
        this.file_.seek(n);
        return this.file_.read(byArray, n2, n3, false);
    }

    @Override
    public void setAutoExtendible(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.changeAttributes(new byte[]{0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 1, bl ? (byte)-15 : -16});
    }

    @Override
    public void setInitialValue(byte by) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.changeAttributes(new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, by});
    }

    @Override
    public void setLength(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray = new byte[]{0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 0};
        BinaryConverter.intToByteArray(n, byArray, 12);
        this.changeAttributes(byArray);
    }

    protected void changeAttributes(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.close();
        this.setupNameParameter();
        this.setupErrorCodeParameter();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(10), this.nameParameter_, new ProgramParameter(byArray), this.errorCodeParameter_};
        if (this.remoteCommand_ == null) {
            this.setupRemoteCommand();
        }
        if (!this.remoteCommand_.runProgram("QSYS", "QUSCUSAT", programParameterArray, this.runOnThread_)) {
            throw this.buildException();
        }
    }

    @Override
    public void setProperties(AS400Impl aS400Impl, String string, String string2, String string3, boolean bl, boolean bl2) {
        this.system_ = (AS400ImplRemote)aS400Impl;
        this.path_ = string;
        this.library_ = string3;
        this.name_ = string2;
        this.mustUseProgramCall_ = bl;
        this.mustUseSockets_ = bl2;
    }

    private void setupErrorCodeParameter() {
        if (this.errorCodeParameter_ == null) {
            this.errorCodeParameter_ = new ProgramParameter(new byte[8]);
        }
    }

    private synchronized void setupFile() throws AS400SecurityException, IOException, ObjectDoesNotExistException {
        if (this.file_ == null) {
            try {
                IFSFileDescriptorImplRemote iFSFileDescriptorImplRemote = new IFSFileDescriptorImplRemote();
                iFSFileDescriptorImplRemote.initialize(0L, this, this.path_, -1, this.system_);
                this.file_ = new IFSRandomAccessFileImplRemote();
                this.file_.setFD(iFSFileDescriptorImplRemote);
                this.file_.setMode("rw");
                this.file_.setExistenceOption(3);
                this.file_.open();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.log(2, "Object does not exist: " + this.path_, (Throwable)fileNotFoundException);
                throw new ObjectDoesNotExistException(this.path_, 2);
            }
            catch (ExtendedIOException extendedIOException) {
                if (extendedIOException.getReturnCode() == 5) {
                    Trace.log(2, "User is not authorized to object: " + this.path_, (Throwable)extendedIOException);
                    throw new AS400SecurityException(this.path_, 4);
                }
                if (extendedIOException.getReturnCode() == 23 && this.library_.equals("QTEMP")) {
                    Trace.log(4, "File server cannot access QTEMP, use mustUseProgramCall option.");
                }
                Trace.log(2, "Error opening file: " + this.path_, (Throwable)extendedIOException);
                throw extendedIOException;
            }
        }
    }

    private synchronized void setupNameParameter() throws IOException {
        if (this.nameParameter_ == null) {
            this.converter_ = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
            byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            this.converter_.stringToByteArray(this.name_, byArray, 0);
            this.converter_.stringToByteArray(this.library_, byArray, 10);
            this.nameParameter_ = new ProgramParameter(byArray);
        }
    }

    protected synchronized void setupRemoteCommand() throws IOException {
        if (this.remoteCommand_ == null) {
            String string;
            boolean bl = false;
            if (this.system_.canUseNativeOptimizations()) {
                try {
                    this.remoteCommand_ = (RemoteCommandImpl)Class.forName("com.ibm.as400.access.RemoteCommandImplNative").newInstance();
                    bl = true;
                }
                catch (Throwable throwable) {
                    Trace.log(4, "Unable to instantiate class RemoteCommandImplNative.", throwable);
                }
            }
            if (this.remoteCommand_ == null) {
                this.remoteCommand_ = new RemoteCommandImplRemote();
            }
            this.remoteCommand_.setSystem(this.system_);
            if (!(!bl || this.mustUseSockets_ || (string = ProgramCall.getThreadSafetyProperty()) != null && string.equals("false"))) {
                this.runOnThread_ = RemoteCommandImpl.ON_THREAD;
            }
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2, int n3, int n4) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.mustUseProgramCall_) {
            this.setupNameParameter();
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            ProgramParameter[] programParameterArray = new ProgramParameter[]{this.nameParameter_, new ProgramParameter(BinaryConverter.intToByteArray(n + 1)), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(byArray2), new ProgramParameter(new byte[]{(byte)(0xF0 | n4)})};
            if (this.remoteCommand_ == null) {
                this.setupRemoteCommand();
            }
            if (!this.remoteCommand_.runProgram("QSYS", "QUSCHGUS", programParameterArray, this.runOnThread_)) {
                throw this.buildException();
            }
        } else {
            this.setupFile();
            this.file_.seek(n);
            switch (n4) {
                case 2: {
                    this.file_.setForceToStorage(true);
                    break;
                }
                case 1: {
                    this.file_.setForceToStorage(false);
                }
            }
            this.file_.writeBytes(byArray, n2, n3);
        }
    }
}

