/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.list.OpenList;
import com.ibm.as400.access.list.SpooledFileListItem;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class SpooledFileOpenList
extends OpenList {
    static final long serialVersionUID = 17674018445884278L;
    private static final byte[] ALL = new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64};
    public static final String FORMAT_0100 = "OSPL0100";
    public static final String FORMAT_0200 = "OSPL0200";
    public static final String FORMAT_0300 = "OSPL0300";
    public static final int JOB_NAME = 0;
    public static final int JOB_USER = 1;
    public static final int JOB_NUMBER = 2;
    public static final int NAME = 3;
    public static final int NUMBER = 4;
    public static final int STATUS = 5;
    public static final int DATE_OPENED = 6;
    public static final int TIME_OPENED = 7;
    public static final int SCHEDULE = 8;
    public static final int JOB_SYSTEM = 9;
    public static final int USER_DATA = 10;
    public static final int FORM_TYPE = 11;
    public static final int OUTPUT_QUEUE_NAME = 12;
    public static final int OUTPUT_QUEUE_LIBRARY = 13;
    public static final int ASP = 14;
    public static final int SIZE = 15;
    private static final int SIZE_MULTIPLIER = 16;
    public static final int TOTAL_PAGES = 17;
    public static final int COPIES_LEFT_TO_PRINT = 18;
    public static final int PRIORITY = 19;
    public static final int PRINTER_NAME = 20;
    public static final int PRINTER_ASSIGNED = 21;
    public static final int CURRENT_PAGE = 22;
    public static final int DEVICE_TYPE = 23;
    private int format_ = 3;
    private String filterJobName_ = "";
    private String filterJobUser_ = "";
    private String filterJobNumber_ = "";
    private String[] filterUsers_;
    private QSYSObjectPathName[] filterOutputQueues_;
    private String filterFormType_;
    private String filterUserData_;
    private String[] filterStatuses_;
    private String[] filterDevices_;
    private String filterJobSystemName_;
    private Date filterCreationDateStart_;
    private Date filterCreationDateEnd_;
    private Vector sortKeys_ = new Vector();

    public SpooledFileOpenList(AS400 aS400) {
        super(aS400);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing SpooledFileOpenList object.");
        }
    }

    public SpooledFileOpenList(AS400 aS400, String string) {
        this(aS400);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing SpooledFileOpenList object.");
        }
        this.setFormat(string);
    }

    public void addSortField(int n, boolean bl) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Adding sort field, field: " + n + ", ascending: " + bl);
        }
        if (n == 15) {
            this.addSortField(16, bl);
        }
        this.sortKeys_.addElement(new int[]{n, bl ? 241 : 242});
    }

    @Override
    protected byte[] callOpenListAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall programCall;
        int n;
        int n2;
        int n3;
        int n4;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opening spooled file list.");
        }
        int n5 = this.system_.getVRM();
        CharConverter charConverter = new CharConverter(this.system_.getCcsid(), this.system_);
        int n6 = this.sortKeys_.size();
        byte[] byArray = new byte[4 + 12 * n6];
        BinaryConverter.intToByteArray(n6, byArray, 0);
        int n7 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            int[] nArray = (int[])this.sortKeys_.elementAt(n4);
            int n8 = nArray[0];
            n3 = this.findFieldLength(n8, n5);
            if (n3 > 0) {
                BinaryConverter.intToByteArray(this.findStartingPosition(n8), byArray, 4 + n7 * 12);
                BinaryConverter.intToByteArray(n3, byArray, 8 + n7 * 12);
                BinaryConverter.shortToByteArray(this.findDataType(n8), byArray, 12 + n7 * 12);
                byArray[14 + n7 * 12] = (byte)nArray[1];
                ++n7;
                continue;
            }
            Trace.log(4, "Sort key not valid, position: " + n4 + ", field: " + n8);
        }
        if (n7 != n6) {
            byte[] byArray2 = byArray;
            byArray = new byte[4 + 12 * n7];
            BinaryConverter.intToByteArray(n7, byArray, 0);
            System.arraycopy(byArray2, 4, byArray, 4, 12 * n7);
        }
        n4 = 0;
        boolean bl = false;
        if (n5 < 328192 || this.filterJobSystemName_ == null && this.filterCreationDateStart_ == null && this.filterCreationDateEnd_ == null) {
            n4 = 92;
            if (this.filterUsers_ != null && this.filterUsers_.length > 1) {
                n4 += 12 * (this.filterUsers_.length - 1);
            }
            if (this.filterOutputQueues_ != null && this.filterOutputQueues_.length > 1) {
                n4 += 20 * (this.filterOutputQueues_.length - 1);
            }
            if (this.filterStatuses_ != null && this.filterStatuses_.length > 1) {
                n4 += 12 * (this.filterStatuses_.length - 1);
            }
            if (this.filterDevices_ != null && this.filterDevices_.length > 1) {
                n4 += 12 * (this.filterDevices_.length - 1);
            }
        } else {
            bl = true;
            n4 = 110;
            if (this.filterUsers_ != null) {
                n4 += 10 * this.filterUsers_.length;
            }
            if (this.filterOutputQueues_ != null) {
                n4 += 20 * this.filterOutputQueues_.length;
            }
            if (this.filterStatuses_ != null) {
                n4 += 10 * this.filterStatuses_.length;
            }
            if (this.filterDevices_ != null) {
                n4 += 10 * this.filterDevices_.length;
            }
        }
        byte[] byArray3 = new byte[n4];
        n3 = 0;
        if (!bl) {
            if (this.filterUsers_ == null || this.filterUsers_.length == 0) {
                BinaryConverter.intToByteArray(1, byArray3, n3);
                System.arraycopy(ALL, 0, byArray3, n3 += 4, 10);
                n3 += 12;
            } else {
                BinaryConverter.intToByteArray(this.filterUsers_.length, byArray3, n3);
                n3 += 4;
                for (n2 = 0; n2 < this.filterUsers_.length; ++n2) {
                    for (n = 0; n < 10; ++n) {
                        byArray3[n + n3] = 64;
                    }
                    charConverter.stringToByteArray(this.filterUsers_[n2], byArray3, n3, 10);
                    n3 += 12;
                }
            }
            if (this.filterOutputQueues_ == null || this.filterOutputQueues_.length == 0) {
                BinaryConverter.intToByteArray(1, byArray3, n3);
                System.arraycopy(ALL, 0, byArray3, n3 += 4, 10);
                n3 += 10;
                for (n2 = 0; n2 < 10; ++n2) {
                    byArray3[n2 + n3] = 64;
                }
                n3 += 10;
            } else {
                BinaryConverter.intToByteArray(this.filterOutputQueues_.length, byArray3, n3);
                n3 += 4;
                for (n2 = 0; n2 < this.filterOutputQueues_.length; ++n2) {
                    for (n = 0; n < 20; ++n) {
                        byArray3[n + n3] = 64;
                    }
                    charConverter.stringToByteArray(this.filterOutputQueues_[n2].getObjectName(), byArray3, n3, 10);
                    charConverter.stringToByteArray(this.filterOutputQueues_[n2].getLibraryName(), byArray3, n3 += 10, 10);
                    n3 += 10;
                }
            }
            if (this.filterFormType_ == null) {
                System.arraycopy(ALL, 0, byArray3, n3, 10);
            } else {
                for (n2 = 0; n2 < 10; ++n2) {
                    byArray3[n2 + n3] = 64;
                }
                charConverter.stringToByteArray(this.filterFormType_, byArray3, n3, 10);
            }
            n3 += 10;
            if (this.filterUserData_ == null) {
                System.arraycopy(ALL, 0, byArray3, n3, 10);
            } else {
                for (n2 = 0; n2 < 10; ++n2) {
                    byArray3[n2 + n3] = 64;
                }
                charConverter.stringToByteArray(this.filterUserData_, byArray3, n3, 10);
            }
            n3 += 10;
            if (this.filterStatuses_ == null || this.filterStatuses_.length == 0) {
                BinaryConverter.intToByteArray(1, byArray3, n3);
                System.arraycopy(ALL, 0, byArray3, n3 += 4, 10);
                n3 += 12;
            } else {
                BinaryConverter.intToByteArray(this.filterStatuses_.length, byArray3, n3);
                n3 += 4;
                for (n2 = 0; n2 < this.filterStatuses_.length; ++n2) {
                    for (n = 0; n < 10; ++n) {
                        byArray3[n + n3] = 64;
                    }
                    charConverter.stringToByteArray(this.filterStatuses_[n2], byArray3, n3, 10);
                    n3 += 12;
                }
            }
            if (this.filterDevices_ == null || this.filterDevices_.length == 0) {
                BinaryConverter.intToByteArray(1, byArray3, n3);
                System.arraycopy(ALL, 0, byArray3, n3 += 4, 10);
                n3 += 12;
            } else {
                BinaryConverter.intToByteArray(this.filterDevices_.length, byArray3, n3);
                n3 += 4;
                for (n2 = 0; n2 < this.filterDevices_.length; ++n2) {
                    for (n = 0; n < 10; ++n) {
                        byArray3[n + n3] = 64;
                    }
                    charConverter.stringToByteArray(this.filterDevices_[n2], byArray3, n3, 10);
                    n3 += 12;
                }
            }
        } else {
            for (n2 = 52; n2 < 106; ++n2) {
                byArray3[n2] = 64;
            }
            for (n2 = 110; n2 < byArray3.length; ++n2) {
                byArray3[n2] = 64;
            }
            n3 = 110;
            BinaryConverter.intToByteArray(106, byArray3, 0);
            if (this.filterUsers_ != null && this.filterUsers_.length > 0) {
                BinaryConverter.intToByteArray(n3, byArray3, 4);
                BinaryConverter.intToByteArray(this.filterUsers_.length, byArray3, 8);
                for (n2 = 0; n2 < this.filterUsers_.length; ++n2) {
                    charConverter.stringToByteArray(this.filterUsers_[n2], byArray3, n3, 10);
                    n3 += 10;
                }
            }
            BinaryConverter.intToByteArray(10, byArray3, 12);
            if (this.filterOutputQueues_ != null && this.filterOutputQueues_.length > 0) {
                BinaryConverter.intToByteArray(n3, byArray3, 16);
                BinaryConverter.intToByteArray(this.filterOutputQueues_.length, byArray3, 20);
                for (n2 = 0; n2 < this.filterOutputQueues_.length; ++n2) {
                    charConverter.stringToByteArray(this.filterOutputQueues_[n2].getObjectName(), byArray3, n3, 10);
                    charConverter.stringToByteArray(this.filterOutputQueues_[n2].getLibraryName(), byArray3, n3 += 10, 10);
                    n3 += 10;
                }
            }
            BinaryConverter.intToByteArray(20, byArray3, 24);
            if (this.filterStatuses_ != null && this.filterStatuses_.length > 0) {
                BinaryConverter.intToByteArray(n3, byArray3, 28);
                BinaryConverter.intToByteArray(this.filterStatuses_.length, byArray3, 32);
                for (n2 = 0; n2 < this.filterStatuses_.length; ++n2) {
                    charConverter.stringToByteArray(this.filterStatuses_[n2], byArray3, n3, 10);
                    n3 += 10;
                }
            }
            BinaryConverter.intToByteArray(10, byArray3, 36);
            if (this.filterDevices_ != null && this.filterDevices_.length > 0) {
                BinaryConverter.intToByteArray(n3, byArray3, 40);
                BinaryConverter.intToByteArray(this.filterDevices_.length, byArray3, 44);
                for (n2 = 0; n2 < this.filterDevices_.length; ++n2) {
                    charConverter.stringToByteArray(this.filterDevices_[n2], byArray3, n3, 10);
                    n3 += 10;
                }
            }
            BinaryConverter.intToByteArray(10, byArray3, 48);
            if (this.filterFormType_ == null) {
                System.arraycopy(ALL, 0, byArray3, 52, 4);
            } else {
                charConverter.stringToByteArray(this.filterFormType_, byArray3, 52, 10);
            }
            if (this.filterUserData_ == null) {
                System.arraycopy(ALL, 0, byArray3, 62, 4);
            } else {
                charConverter.stringToByteArray(this.filterUserData_, byArray3, 62, 10);
            }
            if (this.filterJobSystemName_ == null) {
                System.arraycopy(ALL, 0, byArray3, 72, 4);
            } else {
                charConverter.stringToByteArray(this.filterJobSystemName_, byArray3, 72, 8);
            }
            if (this.filterCreationDateStart_ == null && this.filterCreationDateEnd_ == null) {
                System.arraycopy(ALL, 0, byArray3, 80, 4);
            } else if (this.filterCreationDateStart_ == null) {
                byArray3[80] = 92;
                byArray3[81] = -58;
                byArray3[82] = -55;
                byArray3[83] = -39;
                byArray3[84] = -30;
                byArray3[85] = -29;
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateEnd_, byArray3, 93);
            } else if (this.filterCreationDateEnd_ == null) {
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateStart_, byArray3, 80);
                byArray3[93] = 92;
                byArray3[94] = -45;
                byArray3[95] = -63;
                byArray3[96] = -30;
                byArray3[97] = -29;
            } else {
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateStart_, byArray3, 80);
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateEnd_, byArray3, 93);
            }
        }
        byte[] byArray4 = new byte[26];
        for (n = 0; n < 26; ++n) {
            byArray4[n] = 64;
        }
        charConverter.stringToByteArray(this.filterJobName_, byArray4, 0, 10);
        charConverter.stringToByteArray(this.filterJobUser_, byArray4, 10, 10);
        charConverter.stringToByteArray(this.filterJobNumber_, byArray4, 20, 6);
        byte[] byArray5 = new byte[]{-42, -30, -41, -45, -16, (byte)(0xF0 | this.format_), -16, -16};
        ProgramParameter[] programParameterArray = new ProgramParameter[bl ? 10 : 9];
        programParameterArray[0] = new ProgramParameter(0);
        programParameterArray[1] = new ProgramParameter(new byte[]{0, 0, 0, 0});
        programParameterArray[2] = new ProgramParameter(80);
        programParameterArray[3] = new ProgramParameter(new byte[]{-1, -1, -1, -1});
        programParameterArray[4] = new ProgramParameter(byArray);
        programParameterArray[5] = new ProgramParameter(byArray3);
        programParameterArray[6] = new ProgramParameter(byArray4);
        programParameterArray[7] = new ProgramParameter(byArray5);
        programParameterArray[8] = EMPTY_ERROR_CODE_PARM;
        if (bl) {
            programParameterArray[9] = new ProgramParameter(new byte[]{-42, -30, -41, -58, -16, -14, -16, -16});
        }
        if (!(programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLSPL.PGM", programParameterArray)).run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        return programParameterArray[2].getOutputData();
    }

    public void clearSortFields() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Clearing sort fields.");
        }
        this.sortKeys_.removeAllElements();
    }

    private final short findDataType(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return this.format_ == 3 ? (short)0 : 4;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 0;
            }
            case 16: {
                return 0;
            }
            case 17: {
                return 0;
            }
            case 18: {
                return 0;
            }
            case 19: {
                return 4;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 0;
            }
            case 23: {
                return 4;
            }
        }
        return 0;
    }

    private final int findFieldLength(int n, int n2) {
        switch (n) {
            case 0: {
                return 10;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return this.format_ == 3 ? 4 : 10;
            }
            case 6: {
                return this.format_ != 1 || n2 >= 328192 ? 7 : 0;
            }
            case 7: {
                return this.format_ != 1 || n2 >= 328192 ? 6 : 0;
            }
            case 8: {
                return this.format_ == 3 ? 1 : 0;
            }
            case 9: {
                return this.format_ == 3 ? 10 : (n2 >= 328192 ? 8 : 0);
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 10;
            }
            case 14: {
                return this.format_ == 3 ? 4 : 0;
            }
            case 15: {
                return this.format_ == 3 ? 4 : 0;
            }
            case 16: {
                return this.format_ == 3 ? 4 : 0;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 4;
            }
            case 19: {
                return this.format_ == 3 ? 1 : 2;
            }
            case 20: {
                return this.format_ == 2 ? 10 : 0;
            }
            case 21: {
                return this.format_ == 2 ? 1 : 0;
            }
            case 22: {
                return this.format_ == 3 ? 0 : 4;
            }
            case 23: {
                return this.format_ == 3 ? 0 : 10;
            }
        }
        return 0;
    }

    private final int findStartingPosition(int n) {
        switch (n) {
            case 0: {
                return this.format_ == 3 ? 1 : 11;
            }
            case 1: {
                return this.format_ == 3 ? 11 : 21;
            }
            case 2: {
                return this.format_ == 3 ? 21 : 31;
            }
            case 3: {
                return this.format_ == 3 ? 27 : 1;
            }
            case 4: {
                return 37;
            }
            case 5: {
                return this.format_ == 3 ? 41 : 83;
            }
            case 6: {
                return this.format_ == 3 ? 45 : (this.format_ == 2 ? 161 : 169);
            }
            case 7: {
                return this.format_ == 3 ? 52 : (this.format_ == 2 ? 168 : 176);
            }
            case 8: {
                return 58;
            }
            case 9: {
                return this.format_ == 3 ? 59 : (this.format_ == 2 ? 193 : 161);
            }
            case 10: {
                return this.format_ == 3 ? 69 : 73;
            }
            case 11: {
                return this.format_ == 3 ? 79 : 93;
            }
            case 12: {
                return this.format_ == 3 ? 89 : 53;
            }
            case 13: {
                return this.format_ == 3 ? 99 : 63;
            }
            case 14: {
                return 109;
            }
            case 15: {
                return 113;
            }
            case 16: {
                return 117;
            }
            case 17: {
                return this.format_ == 3 ? 121 : 41;
            }
            case 18: {
                return this.format_ == 3 ? 125 : 49;
            }
            case 19: {
                return this.format_ == 3 ? 129 : 103;
            }
            case 20: {
                return 175;
            }
            case 21: {
                return 174;
            }
            case 22: {
                return 45;
            }
            case 23: {
                return 137;
            }
        }
        return 0;
    }

    private static final void formatOS400DateString(Date date, byte[] byArray, int n) {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.clear();
        calendar.setTime(date);
        int n2 = calendar.get(1);
        byArray[n] = (byte)(n2 / 100 - 19 | 0xF0);
        int n3 = n2 % 100;
        byArray[n + 1] = (byte)(n3 / 10 | 0xF0);
        byArray[n + 2] = (byte)(n3 % 10 | 0xF0);
        int n4 = calendar.get(2) + 1;
        byArray[n + 3] = (byte)(n4 / 10 | 0xF0);
        byArray[n + 4] = (byte)(n4 % 10 | 0xF0);
        int n5 = calendar.get(5);
        byArray[n + 5] = (byte)(n5 / 10 | 0xF0);
        byArray[n + 6] = (byte)(n5 % 10 | 0xF0);
        int n6 = calendar.get(11);
        byArray[n + 7] = (byte)(n6 / 10 | 0xF0);
        byArray[n + 8] = (byte)(n6 % 10 | 0xF0);
        int n7 = calendar.get(12);
        byArray[n + 9] = (byte)(n7 / 10 | 0xF0);
        byArray[n + 10] = (byte)(n7 % 10 | 0xF0);
        int n8 = calendar.get(13);
        byArray[n + 11] = (byte)(n8 / 10 | 0xF0);
        byArray[n + 12] = (byte)(n8 % 10 | 0xF0);
    }

    @Override
    protected Object[] formatOutputData(byte[] byArray, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n3 = this.system_.getVRM();
        CharConverter charConverter = new CharConverter(this.system_.getCcsid(), this.system_);
        Object[] objectArray = new SpooledFileListItem[n];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            String string;
            int n5;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            int n6;
            int n7;
            String string8;
            String string9;
            String string10;
            String string11;
            if (this.format_ != 3) {
                string11 = charConverter.byteArrayToString(byArray, n4, 10).trim();
                string10 = charConverter.byteArrayToString(byArray, n4 + 10, 10).trim();
                string9 = charConverter.byteArrayToString(byArray, n4 + 20, 10).trim();
                string8 = charConverter.byteArrayToString(byArray, n4 + 30, 6);
                n7 = BinaryConverter.byteArrayToInt(byArray, n4 + 36);
                n6 = BinaryConverter.byteArrayToInt(byArray, n4 + 40);
                int n8 = BinaryConverter.byteArrayToInt(byArray, n4 + 44);
                int n9 = BinaryConverter.byteArrayToInt(byArray, n4 + 48);
                string7 = charConverter.byteArrayToString(byArray, n4 + 52, 10).trim();
                string6 = charConverter.byteArrayToString(byArray, n4 + 62, 10).trim();
                string5 = charConverter.byteArrayToString(byArray, n4 + 72, 10);
                string4 = charConverter.byteArrayToString(byArray, n4 + 82, 10).trim();
                string3 = charConverter.byteArrayToString(byArray, n4 + 92, 10).trim();
                string2 = charConverter.byteArrayToString(byArray, n4 + 102, 2).trim();
                byte[] byArray2 = new byte[16];
                System.arraycopy(byArray, n4 + 104, byArray2, 0, 16);
                byte[] byArray3 = new byte[16];
                System.arraycopy(byArray, n4 + 120, byArray3, 0, 16);
                String string12 = charConverter.byteArrayToString(byArray, n4 + 136, 10).trim();
                n5 = BinaryConverter.byteArrayToInt(byArray, n4 + 148);
                String string13 = null;
                string = null;
                String string14 = null;
                if (n5 > 0) {
                    string13 = charConverter.byteArrayToString(byArray, n4 + n5, 8).trim();
                    string = charConverter.byteArrayToString(byArray, n4 + n5 + 8, 7);
                    string14 = charConverter.byteArrayToString(byArray, n4 + n5 + 15, 6);
                }
                if (this.format_ == 1) {
                    objectArray[i] = new SpooledFileListItem(string11, string10, string9, string8, n7, n6, n8, n9, string7, string6, string5, string4, string3, string2, byArray2, byArray3, string12, string13, string, string14);
                } else {
                    string = charConverter.byteArrayToString(byArray, n4 + 160, 7);
                    string14 = charConverter.byteArrayToString(byArray, n4 + 167, 6);
                    String string15 = charConverter.byteArrayToString(byArray, n4 + 173, 1);
                    String string16 = charConverter.byteArrayToString(byArray, n4 + 174, 10).trim();
                    objectArray[i] = new SpooledFileListItem(string11, string10, string9, string8, n7, n6, n8, n9, string7, string6, string5, string4, string3, string2, byArray2, byArray3, string12, string13, string, string14, string15, string16);
                }
            } else {
                string11 = charConverter.byteArrayToString(byArray, n4, 10).trim();
                string10 = charConverter.byteArrayToString(byArray, n4 + 10, 10).trim();
                string9 = charConverter.byteArrayToString(byArray, n4 + 20, 6);
                string8 = charConverter.byteArrayToString(byArray, n4 + 26, 10).trim();
                n7 = BinaryConverter.byteArrayToInt(byArray, n4 + 36);
                n6 = BinaryConverter.byteArrayToInt(byArray, n4 + 40);
                String string17 = charConverter.byteArrayToString(byArray, n4 + 44, 7);
                String string18 = charConverter.byteArrayToString(byArray, n4 + 51, 6);
                string7 = charConverter.byteArrayToString(byArray, n4 + 57, 1);
                string6 = charConverter.byteArrayToString(byArray, n4 + 58, 10).trim();
                string5 = charConverter.byteArrayToString(byArray, n4 + 68, 10);
                string4 = charConverter.byteArrayToString(byArray, n4 + 78, 10).trim();
                string3 = charConverter.byteArrayToString(byArray, n4 + 88, 10).trim();
                string2 = charConverter.byteArrayToString(byArray, n4 + 98, 10).trim();
                int n10 = BinaryConverter.byteArrayToInt(byArray, n4 + 108);
                int n11 = BinaryConverter.byteArrayToInt(byArray, n4 + 112);
                int n12 = BinaryConverter.byteArrayToInt(byArray, n4 + 116);
                n5 = BinaryConverter.byteArrayToInt(byArray, n4 + 120);
                int n13 = BinaryConverter.byteArrayToInt(byArray, n4 + 124);
                string = charConverter.byteArrayToString(byArray, n4 + 128, 1);
                int n14 = 0;
                if (n3 >= 328448) {
                    n14 = BinaryConverter.byteArrayToInt(byArray, n4 + 132);
                }
                objectArray[i] = new SpooledFileListItem(string11, string10, string9, string8, n7, n6, string17, string18, string7, string6, string5, string4, string3, string2, n10, n11, n12, n5, n13, string, n14);
            }
            n4 += n2;
        }
        return objectArray;
    }

    @Override
    protected int getBestGuessReceiverSize(int n) {
        switch (this.format_) {
            case 1: {
                return 192 * n;
            }
            case 2: {
                return 224 * n;
            }
        }
        return 136 * n;
    }

    public Date getFilterCreationDateEnd() {
        return this.filterCreationDateEnd_;
    }

    public Date getFilterCreationDateStart() {
        return this.filterCreationDateStart_;
    }

    public String[] getFilterDevices() {
        return this.filterDevices_;
    }

    public String getFilterFormType() {
        return this.filterFormType_;
    }

    public String getFilterJobName() {
        return this.filterJobName_;
    }

    public String getFilterJobNumber() {
        return this.filterJobNumber_;
    }

    public String getFilterJobSystemName() {
        return this.filterJobSystemName_;
    }

    public String getFilterJobUser() {
        return this.filterJobUser_;
    }

    public String[] getFilterOutputQueues() {
        if (this.filterOutputQueues_ == null) {
            return null;
        }
        String[] stringArray = new String[this.filterOutputQueues_.length];
        for (int i = 0; i < this.filterOutputQueues_.length; ++i) {
            stringArray[i] = this.filterOutputQueues_[i].getPath();
        }
        return stringArray;
    }

    public String[] getFilterStatuses() {
        return this.filterStatuses_;
    }

    public String getFilterUserData() {
        return this.filterUserData_;
    }

    public String[] getFilterUsers() {
        return this.filterUsers_;
    }

    public String getFormat() {
        switch (this.format_) {
            case 1: {
                return FORMAT_0100;
            }
            case 2: {
                return FORMAT_0200;
            }
        }
        return FORMAT_0300;
    }

    public void setFilterCreationDate(Date date, Date date2) {
        this.filterCreationDateStart_ = date;
        this.filterCreationDateEnd_ = date2;
        this.resetHandle();
    }

    public void setFilterDevices(String[] stringArray) {
        this.filterDevices_ = stringArray;
        this.resetHandle();
    }

    public void setFilterFormType(String string) {
        this.filterFormType_ = string;
        this.resetHandle();
    }

    public void setFilterJobInformation(String string, String string2, String string3) {
        this.filterJobName_ = string == null ? "" : string.trim();
        this.filterJobUser_ = string2 == null ? "" : string2.trim();
        String string4 = this.filterJobNumber_ = string3 == null ? "" : string3.trim();
        if (this.filterJobName_.equals("*")) {
            this.filterJobUser_ = "";
            this.filterJobNumber_ = "";
        }
        this.resetHandle();
    }

    public void setFilterJobSystemName(String string) {
        this.filterJobSystemName_ = string;
        this.resetHandle();
    }

    public void setFilterOutputQueues(String[] stringArray) {
        if (stringArray == null) {
            this.filterOutputQueues_ = null;
        } else {
            this.filterOutputQueues_ = new QSYSObjectPathName[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.filterOutputQueues_[i] = new QSYSObjectPathName(stringArray[i]);
                if (this.filterOutputQueues_[i].getObjectType().equals("OUTQ")) continue;
                Trace.log(4, "Object type is not valid, path: '" + stringArray[i] + "'");
            }
        }
        this.resetHandle();
    }

    public void setFilterStatuses(String[] stringArray) {
        this.filterStatuses_ = stringArray;
        this.resetHandle();
    }

    public void setFilterUserData(String string) {
        this.filterUserData_ = string;
        this.resetHandle();
    }

    public void setFilterUsers(String[] stringArray) {
        this.filterUsers_ = stringArray;
        this.resetHandle();
    }

    public void setFormat(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'format' is null.");
            throw new NullPointerException("format");
        }
        if ((string = string.toUpperCase().trim()).equals(FORMAT_0100)) {
            this.format_ = 1;
        } else if (string.equals(FORMAT_0200)) {
            this.format_ = 2;
        } else if (string.equals(FORMAT_0300)) {
            this.format_ = 3;
        } else {
            Trace.log(2, "Value of parameter 'format' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("format (" + string + ")", 2);
        }
        this.resetHandle();
    }
}

