/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlAttribute;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XMLErrorHandler;
import com.ibm.as400.data.XPCMLHelper;
import com.ibm.as400.data.XmlException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class PcmlSAXParser
extends DefaultHandler {
    private transient PcmlDocument m_rootNode = null;
    private transient PcmlDocNode m_currentNode = null;
    private transient String m_docName;
    private transient XMLErrorHandler m_xh;
    private transient boolean exceptionIfParseError_;
    Vector curAttrs = new Vector();
    Vector curQName = new Vector();
    int curDim = -1;
    String lastQName = "";
    int[] dimArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    PcmlDimensions dimensions = new PcmlDimensions(this.dimArray);
    private String initValue = "";
    private boolean docIsXPCML = false;
    private boolean firstInstance = true;
    ByteArrayOutputStream xmlOut = new ByteArrayOutputStream();
    ByteArrayInputStream xmlIn;
    private InputStream xsdFileStream;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    private static HashSet knownTypes_ = null;
    private static HashSet knownArrayTypes_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PcmlSAXParser(String string, InputStream inputStream, InputStream inputStream2, boolean bl, boolean bl2) throws MissingResourceException, IOException, ParseException, PcmlSpecificationException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        this.exceptionIfParseError_ = bl2;
        this.xsdFileStream = inputStream2;
        this.docIsXPCML = bl;
        this.curAttrs.add(0, new AttributesImpl());
        this.curQName.add(0, "");
        String string2 = string.endsWith(".pcml") || string.endsWith(".pcmlsrc") || string.endsWith(".xpcml") || string.endsWith(".xpcmlsrc") ? string.substring(0, string.lastIndexOf(46)) : string;
        this.m_docName = string2.substring(string2.lastIndexOf(46) + 1);
        InputStream inputStream3 = null;
        InputStream inputStream4 = null;
        try {
            Object object;
            SAXParser sAXParser;
            if (bl) {
                if (this.xsdFileStream != null) {
                    try {
                        XPCMLHelper.doSimplifyXSDTransform(this.xsdFileStream, this.xmlOut);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (SAXException sAXException) {
                        throw sAXException;
                    }
                    this.xmlIn = new ByteArrayInputStream(this.xmlOut.toByteArray());
                    if (this.xmlIn == null) {
                        throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                    }
                }
                inputStream4 = new BufferedInputStream(inputStream);
            } else {
                inputStream3 = SystemResourceFinder.getPCMLHeader();
                inputStream4 = new SequenceInputStream(inputStream3, inputStream);
            }
            this.m_xh = new XMLErrorHandler(this.m_docName, SystemResourceFinder.getHeaderLineCount());
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            sAXParserFactory.setNamespaceAware(false);
            if (bl) {
                PcmlSAXParser.setFeatures(sAXParserFactory);
            }
            try {
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                sAXParserFactory.setValidating(false);
                sAXParser = sAXParserFactory.newSAXParser();
            }
            try {
                object = sAXParser.getXMLReader();
                object.setErrorHandler(this.m_xh);
                sAXParser.parse(new InputSource(inputStream4), (DefaultHandler)this);
                inputStream4.close();
                inputStream4 = null;
            }
            catch (SAXException sAXException) {
                Trace.log(7, sAXException);
                ParseException parseException = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{this.m_docName}));
                parseException.addMessage(sAXException.getMessage());
                throw parseException;
            }
            object = this.m_xh.getException();
            if (object != null) {
                ((ParseException)object).reportErrors();
                throw object;
            }
            this.augmentTree(this.m_rootNode, new Stack());
            this.checkAttributes(this.m_rootNode);
            try {
                if (bl) {
                    this.m_rootNode.copyValues(this.m_rootNode, this.m_rootNode);
                }
            }
            catch (XmlException xmlException) {
                Trace.log(7, "All data values may not have been copied to struct parm refs.", (Throwable)xmlException);
                throw new SAXException(xmlException);
            }
            if (this.m_rootNode != null && this.m_rootNode.getPcmlSpecificationException() != null) {
                throw this.m_rootNode.getPcmlSpecificationException();
            }
        }
        finally {
            if (inputStream3 != null) {
                try {
                    inputStream3.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream4 != null) {
                try {
                    inputStream4.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static void setFeatures(SAXParserFactory sAXParserFactory) throws SAXException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        sAXParserFactory.setFeature(NAMESPACES_FEATURE_ID, true);
        sAXParserFactory.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, true);
        sAXParserFactory.setFeature(VALIDATION_FEATURE_ID, true);
        sAXParserFactory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        sAXParserFactory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        sAXParserFactory.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, false);
    }

    PcmlDocument getPcmlDocument() {
        return this.m_rootNode;
    }

    private void augmentTree(PcmlDocNode pcmlDocNode, Stack stack) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string;
            PcmlData pcmlData;
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            if (pcmlDocNode2 instanceof PcmlData && (pcmlData = (PcmlData)pcmlDocNode2).getDataType() == 7 && pcmlData.getNbrChildren() == 0 && (string = pcmlData.getStruct()) != null) {
                PcmlDocNode pcmlDocNode3 = (PcmlDocNode)this.m_rootNode.getElement(string);
                if (pcmlDocNode3 instanceof PcmlStruct) {
                    if (stack.search(pcmlDocNode3) != -1) {
                        this.m_rootNode.addPcmlSpecificationError("CIRCULAR_REFERENCE", new Object[]{string, pcmlData.getBracketedTagName(), pcmlData.getNameForException()});
                    } else {
                        Enumeration enumeration2 = pcmlDocNode3.getChildren();
                        while (enumeration2.hasMoreElements()) {
                            PcmlDocNode pcmlDocNode4 = (PcmlDocNode)enumeration2.nextElement();
                            PcmlDocNode pcmlDocNode5 = (PcmlDocNode)pcmlDocNode4.clone();
                            pcmlData.addChild(pcmlDocNode5);
                            this.m_rootNode.addToHashtable(pcmlDocNode5);
                        }
                    }
                } else if (pcmlDocNode3 == null) {
                    this.m_rootNode.addPcmlSpecificationError("REF_NOT_FOUND", new Object[]{string, "<struct>", pcmlData.getBracketedTagName(), pcmlData.getNameForException()});
                } else {
                    this.m_rootNode.addPcmlSpecificationError("REF_WRONG_TYPE", new Object[]{string, "<struct>", pcmlData.getBracketedTagName(), pcmlData.getNameForException()});
                }
            }
            stack.push(pcmlDocNode2);
            this.augmentTree(pcmlDocNode2, stack);
            stack.pop();
        }
    }

    private void checkAttributes(PcmlDocNode pcmlDocNode) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            pcmlDocNode2.checkAttributes();
            this.checkAttributes(pcmlDocNode2);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Object object;
        String string4 = string3;
        PcmlDocNode pcmlDocNode = null;
        String string5 = string3;
        AttributesImpl attributesImpl = new AttributesImpl();
        boolean bl = false;
        boolean bl2 = false;
        this.initValue = "";
        if (!this.docIsXPCML) {
            object = new PcmlAttributeList(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                ((PcmlAttributeList)object).addAttribute(new PcmlAttribute(attributes.getQName(i), attributes.getValue(i), true));
            }
            if (string4.equals("pcml")) {
                pcmlDocNode = new PcmlDocument((PcmlAttributeList)object, this.m_docName);
            } else if (string4.equals("program")) {
                pcmlDocNode = new PcmlProgram((PcmlAttributeList)object);
            } else if (string4.equals("struct")) {
                pcmlDocNode = new PcmlStruct((PcmlAttributeList)object);
            } else if (string4.equals("data")) {
                pcmlDocNode = new PcmlData((PcmlAttributeList)object);
            } else {
                pcmlDocNode = null;
                if (this.m_rootNode != null) {
                    this.m_rootNode.addPcmlSpecificationError("BAD_TAG", new Object[]{string4, PcmlSAXParser.getBracketedTagName(string4)});
                } else {
                    PcmlSpecificationException pcmlSpecificationException = new PcmlSpecificationException(SystemResourceFinder.format("BAD_TAG", new Object[]{string4, PcmlSAXParser.getBracketedTagName(string4)}));
                    throw new RuntimeException(pcmlSpecificationException);
                }
            }
            if (pcmlDocNode != null) {
                if (this.m_rootNode == null) {
                    this.m_rootNode = pcmlDocNode;
                    this.m_currentNode = pcmlDocNode;
                } else {
                    this.m_currentNode.addChild(pcmlDocNode);
                    this.m_currentNode = pcmlDocNode;
                }
            }
        }
        if (this.docIsXPCML) {
            int n;
            boolean bl3;
            String string6;
            Object object2;
            int n2;
            if (this.xsdFileStream != null && !PcmlSAXParser.getKnownTypes().contains(string3)) {
                bl = true;
                object = new ByteArrayInputStream(this.xmlOut.toByteArray());
                if (object == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                }
                LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object));
                try {
                    String string7 = lineNumberReader.readLine();
                    n2 = 0;
                    while (string7 != null && n2 == 0) {
                        if (string7.indexOf("name=\"" + string3 + "\"") != -1 && string7.indexOf("parm type=") != -1) {
                            if (string7.indexOf("parm type=string") != -1) {
                                string5 = "stringParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=int") != -1) {
                                string5 = "intParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=uint") != -1) {
                                string5 = "unsignedIntParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=hexBinary") != -1) {
                                string5 = "hexBinaryParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=byte") != -1) {
                                string5 = "byteParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=ubyte") != -1) {
                                string5 = "unsignedByteParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=short") != -1) {
                                string5 = "shortParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=ushort") != -1) {
                                string5 = "unsignedShortParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=long") != -1) {
                                string5 = "longParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=ulong") != -1) {
                                string5 = "unsignedLongParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=float") != -1) {
                                string5 = "floatParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=double") != -1) {
                                string5 = "doubleParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=packed") != -1) {
                                string5 = "packedDecimalParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=zoned") != -1) {
                                string5 = "zonedDecimalParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=date") != -1) {
                                string5 = "dateParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=time") != -1) {
                                string5 = "timeParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=timestamp") != -1) {
                                string5 = "timestampParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=structParm") != -1) {
                                string5 = "structParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfString") != -1) {
                                string5 = "arrayOfStringParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfInt") != -1) {
                                string5 = "arrayOfIntParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfUInt") != -1) {
                                string5 = "arrayOfUnsignedIntParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfHexBinary") != -1) {
                                string5 = "arrayOfHexBinaryParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfShort") != -1) {
                                string5 = "arrayOfShortParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfUShort") != -1) {
                                string5 = "arrayOfUnsignedShortParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfLong") != -1) {
                                string5 = "arrayOfLongParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfULong") != -1) {
                                string5 = "arrayOfUnsignedLongParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfFloat") != -1) {
                                string5 = "arrayOfFloatParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfDouble") != -1) {
                                string5 = "arrayOfDoubleParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfPacked") != -1) {
                                string5 = "arrayOfPackedDecimalParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfZoned") != -1) {
                                string5 = "arrayOfZonedDecimalParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfDate") != -1) {
                                string5 = "arrayOfDateParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfTime") != -1) {
                                string5 = "arrayOfTimeParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfTimestamp") != -1) {
                                string5 = "arrayOfTimestampParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=arrayOfStructParm") != -1) {
                                string5 = "arrayOfStructParm";
                                n2 = 1;
                            } else if (string7.indexOf("parm type=structArray") != -1) {
                                string5 = "arrayOfStruct";
                                n2 = 1;
                            } else {
                                Trace.log(4, "User defined type passed in not found in xsd stream");
                            }
                            if (n2 == 1) {
                                string7 = lineNumberReader.readLine();
                                while (string7 != null && string7.indexOf("parm type=") == -1) {
                                    object2 = "";
                                    String string8 = "";
                                    if (string7.indexOf("attributeName=") != -1) {
                                        object2 = string7.substring(string7.indexOf("attributeName=") + 14, string7.indexOf("attributeValue=")).trim();
                                    }
                                    if (string7.indexOf("attributeValue=") != -1) {
                                        string8 = string7.substring(string7.indexOf("attributeValue=") + 15).trim();
                                    }
                                    attributesImpl.addAttribute("", "", (String)object2, "", string8);
                                    string7 = lineNumberReader.readLine();
                                }
                            }
                        }
                        if (n2 != 0) continue;
                        string7 = lineNumberReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Trace.log(7, "Error reading xsd stream in startElement.", (Throwable)iOException);
                }
            }
            if (PcmlSAXParser.getKnownArrayTypes().contains(string5)) {
                ++this.curDim;
                if (bl) {
                    if (this.curAttrs.size() > this.curDim) {
                        this.curAttrs.set(this.curDim, attributesImpl);
                    } else {
                        this.curAttrs.add(this.curDim, attributesImpl);
                    }
                } else if (this.curAttrs.size() > this.curDim) {
                    this.curAttrs.set(this.curDim, new AttributesImpl(attributes));
                } else {
                    this.curAttrs.add(this.curDim, new AttributesImpl(attributes));
                }
                if (this.curQName.size() > this.curDim) {
                    this.curQName.set(this.curDim, string5);
                } else {
                    this.curQName.add(this.curDim, string5);
                }
                this.lastQName = string5;
            }
            if (string5.equals("i") || string5.equals("struct_i")) {
                if (this.lastQName.indexOf("arrayOf") == -1) {
                    this.dimensions.set(this.curDim, this.dimensions.at(this.curDim) + 1);
                }
                object = new AttributesImpl((AttributesImpl)this.curAttrs.elementAt(this.curDim));
                string6 = (String)this.curQName.elementAt(this.curDim);
            } else {
                if (bl) {
                    object = attributesImpl;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        if (((AttributesImpl)object).getIndex(attributes.getQName(i)) != -1) continue;
                        bl2 = true;
                        ((AttributesImpl)object).addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                    }
                } else {
                    object = new AttributesImpl(attributes);
                }
                string6 = string5;
            }
            this.firstInstance = true;
            if (this.m_currentNode != null && this.m_currentNode.getNodeType() == 3 && !string5.equals("struct_i") && !string5.equals("struct") && !string5.equals("xpcml") && (bl3 = this.inTree(string5, (AttributesImpl)object))) {
                this.firstInstance = false;
            }
            for (n = 0; n <= this.curDim; ++n) {
                if (this.dimensions.at(n) <= 0) continue;
                this.firstInstance = false;
            }
            if (string5.equals("i") || string5.equals("struct_i")) {
                for (n = 0; n < attributes.getLength(); ++n) {
                    if (!attributes.getQName(n).equals("index")) continue;
                    Integer n3 = new Integer(attributes.getValue(n));
                    this.dimensions.set(this.curDim, n3);
                }
            }
            this.lastQName = string5;
            if (this.firstInstance && !string5.equals("i") && !string5.equals("struct_i")) {
                PcmlAttributeList pcmlAttributeList = new PcmlAttributeList(((AttributesImpl)object).getLength() + 2);
                for (n2 = 0; n2 < ((AttributesImpl)object).getLength(); ++n2) {
                    if (((AttributesImpl)object).getQName(n2).equals("passDirection")) {
                        if (((AttributesImpl)object).getValue(n2).equals("in")) {
                            pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "input", true));
                            continue;
                        }
                        if (((AttributesImpl)object).getValue(n2).equals("inout")) {
                            pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "inputoutput", true));
                            continue;
                        }
                        if (((AttributesImpl)object).getValue(n2).equals("out")) {
                            pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "output", true));
                            continue;
                        }
                        if (!((AttributesImpl)object).getValue(n2).equals("inherit")) continue;
                        pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "inherit", true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("passMode")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("passby", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("bytesPerChar")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("chartype", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("totalBytes")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("length", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("outputSize")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("outputsize", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("entryPoint")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("entrypoint", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("returnValue")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("returnvalue", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("threadSafe")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("threadsafe", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("offsetFrom")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("offsetfrom", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("totalDigits")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("length", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("fractionDigits")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("precision", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("parseOrder")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("parseorder", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("bidiStringType")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("bidistringtype", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("isEmptyString")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("init", "", true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("dateFormat")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("dateformat", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("dateSeparator")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("dateseparator", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("timeFormat")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("timeformat", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("timeSeparator")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("timeseparator", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (string3.equals("xpcml") && (!string3.equals("xpcml") || !((AttributesImpl)object).getQName(n2).equals("version"))) continue;
                    pcmlAttributeList.addAttribute(new PcmlAttribute(((AttributesImpl)object).getQName(n2), ((AttributesImpl)object).getValue(n2), true));
                }
                if (string4.equals("program")) {
                    pcmlDocNode = new PcmlProgram(pcmlAttributeList);
                    for (n2 = 0; n2 < this.dimensions.size(); ++n2) {
                        this.dimensions.set(n2, 0);
                    }
                } else if (string4.equals("struct")) {
                    pcmlDocNode = new PcmlStruct(pcmlAttributeList);
                } else if (string4.equals("arrayOfStruct")) {
                    pcmlDocNode = new PcmlStruct(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("arrayOfStructParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "struct", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string4.equals("xpcml")) {
                    pcmlDocNode = new PcmlDocument(pcmlAttributeList, this.m_docName);
                } else if (string5.equals("stringParm") || string5.equals("arrayOfStringParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "char", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("hexBinaryParm") || string5.equals("arrayOfHexBinaryParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "byte", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("intParm") || string5.equals("arrayOfIntParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "4", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("unsignedIntParm") || string5.equals("arrayOfUnsignedIntParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "4", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("precision", "32", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("byteParm") || string5.equals("arrayOfByteParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "1", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("unsignedByteParm") || string5.equals("arrayOfUnsignedByteParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "1", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("precision", "8", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("shortParm") || string5.equals("arrayOfShortParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "2", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("unsignedShortParm") || string5.equals("arrayOfUnsignedShortParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "2", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("precision", "16", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("longParm") || string5.equals("arrayOfLongParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "8", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("unsignedLongParm") || string5.equals("arrayOfUnsignedLongParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "8", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("precision", "64", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("floatParm") || string5.equals("arrayOfFloatParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "float", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "4", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("doubleParm") || string5.equals("arrayOfDoubleParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "float", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "8", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("zonedDecimalParm") || string5.equals("arrayOfZonedDecimalParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "zoned", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("packedDecimalParm") || string5.equals("arrayOfPackedDecimalParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "packed", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("dateParm") || string5.equals("arrayOfDateParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "date", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("timeParm") || string5.equals("arrayOfTimeParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "time", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("timestampParm") || string5.equals("arrayOfTimestampParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "timestamp", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string5.equals("structParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "struct", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else {
                    pcmlDocNode = null;
                }
                if (pcmlDocNode != null) {
                    if (bl2) {
                        pcmlDocNode.setIsExtendedType(true);
                    }
                    if (this.m_rootNode == null) {
                        this.m_rootNode = (PcmlDocument)pcmlDocNode;
                        this.m_currentNode = pcmlDocNode;
                    } else {
                        if (this.m_currentNode != null) {
                            this.m_currentNode.addChild(pcmlDocNode);
                        }
                        this.m_currentNode = pcmlDocNode;
                    }
                }
            } else if (this.m_currentNode.getNodeType() == 3 && !string5.equals("struct_i") || this.m_currentNode.getNodeType() == 4 && this.m_currentNode.getAttributeValue("type").equals("struct") && !string5.equals("struct_i")) {
                String string9 = "";
                for (n2 = 0; n2 < ((AttributesImpl)object).getLength(); ++n2) {
                    if (!((AttributesImpl)object).getQName(n2).equals("name")) continue;
                    string9 = ((AttributesImpl)object).getValue(n2);
                }
                object2 = null;
                Enumeration enumeration = this.m_currentNode.getChildren();
                if (enumeration == null) {
                    return;
                }
                boolean bl4 = false;
                while (enumeration.hasMoreElements() && !bl4) {
                    object2 = (PcmlNode)enumeration.nextElement();
                    if (!((PcmlNode)object2).getName().equals(string9)) continue;
                    bl4 = true;
                }
                this.m_currentNode = (PcmlDocNode)object2;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!(this.m_currentNode == null || this.m_currentNode.getNodeType() != 4 || this.m_currentNode.getAttributeValue("type") != null && this.m_currentNode.getAttributeValue("type").equals("struct"))) {
            String string = new String(cArray, n, n2);
            if (!PcmlSAXParser.getKnownArrayTypes().contains(this.lastQName)) {
                this.initValue = this.lastQName.equals("i") ? (string.indexOf(10) != -1 ? this.initValue + string.substring(0, string.indexOf(10)) : this.initValue + string) : this.initValue + string;
                try {
                    if (this.m_currentNode.getAttributeValue("type").equals("byte")) {
                        byte[] byArray = BinaryConverter.stringToBytes(this.initValue);
                        ((PcmlData)this.m_currentNode).setValue(byArray, this.dimensions);
                    } else if (this.m_currentNode.getAttributeValue("type").equals("char") && this.m_currentNode.getAttributeValue("isEmptyString") != null && this.m_currentNode.getAttributeValue("isEmptyString").equals("true")) {
                        Trace.log(7, "Setting an empty string");
                        ((PcmlData)this.m_currentNode).setValue("", new PcmlDimensions(this.dimensions));
                    } else if (this.initValue.trim().length() > 0 || this.m_currentNode.getAttributeValue("type").equals("char")) {
                        ((PcmlData)this.m_currentNode).setInit(this.initValue);
                        ((PcmlData)this.m_currentNode).setValue(this.initValue, this.dimensions);
                    }
                    if (!this.firstInstance || this.lastQName.equals("i") || this.lastQName.equals("struct_i")) {
                        ((PcmlData)this.m_currentNode).setInit(null);
                    }
                }
                catch (Exception exception) {
                    Trace.log(7, "Exception when doing setValue.", (Throwable)exception);
                    Trace.log(7, "current node=" + this.m_currentNode.getQualifiedName());
                    Trace.log(7, "initial value=" + this.initValue + "..");
                    try {
                        int n3 = ((PcmlData)this.m_currentNode).getLength(this.dimensions);
                        Trace.log(7, "length2 is " + n3);
                    }
                    catch (Exception exception2) {
                        Trace.log(7, "Exception due to length not being set when doing setValue.", (Throwable)exception);
                        Trace.log(7, "setValue not done but init attribute set.");
                        return;
                    }
                    throw new SAXException(exception);
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        String string4 = string3;
        if (!this.docIsXPCML) {
            this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
        }
        if (this.docIsXPCML) {
            if (this.xsdFileStream != null && !PcmlSAXParser.getKnownTypes().contains(string3)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.xmlOut.toByteArray());
                LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(byteArrayInputStream));
                try {
                    String string5 = lineNumberReader.readLine();
                    boolean bl = false;
                    while (string5 != null && !bl) {
                        if (string5.indexOf("name=\"" + string3 + "\"") != -1 && string5.indexOf("parm type=") != -1) {
                            if (string5.indexOf("parm type=string") != -1) {
                                string4 = "stringParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=int") != -1) {
                                string4 = "intParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=uint") != -1) {
                                string4 = "unsignedIntParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=hexBinary") != -1) {
                                string4 = "hexBinaryParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=byte") != -1) {
                                string4 = "byteParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=ubyte") != -1) {
                                string4 = "unsignedByteParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=short") != -1) {
                                string4 = "shortParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=ushort") != -1) {
                                string4 = "unsignedShortParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=long") != -1) {
                                string4 = "longParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=ulong") != -1) {
                                string4 = "unsignedLongParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=float") != -1) {
                                string4 = "floatParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=double") != -1) {
                                string4 = "doubleParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=packed") != -1) {
                                string4 = "packedDecimalParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=zoned") != -1) {
                                string4 = "zonedDecimalParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=date") != -1) {
                                string4 = "dateParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=time") != -1) {
                                string4 = "timeParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=timestamp") != -1) {
                                string4 = "timestampParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=structParm") != -1) {
                                string4 = "structParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfString") != -1) {
                                string4 = "arrayOfStringParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfInt") != -1) {
                                string4 = "arrayOfIntParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfUInt") != -1) {
                                string4 = "arrayOfUnsignedIntParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfHexBinary") != -1) {
                                string4 = "arrayOfHexBinaryParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfByte") != -1) {
                                string4 = "arrayOfByteParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfUByte") != -1) {
                                string4 = "arrayOfUnsignedByteParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfShort") != -1) {
                                string4 = "arrayOfShortParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfUShort") != -1) {
                                string4 = "arrayOfUnsignedShortParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfLong") != -1) {
                                string4 = "arrayOfLongParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfULong") != -1) {
                                string4 = "arrayOfUnsignedLongParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfFloat") != -1) {
                                string4 = "arrayOfFloatParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfDouble") != -1) {
                                string4 = "arrayOfDoubleParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfPacked") != -1) {
                                string4 = "arrayOfPackedDecimalParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfZoned") != -1) {
                                string4 = "arrayOfZonedDecimalParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfDate") != -1) {
                                string4 = "arrayOfDateParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfTime") != -1) {
                                string4 = "arrayOfTimeParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfTimestamp") != -1) {
                                string4 = "arrayOfTimestampParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=arrayOfStructParm") != -1) {
                                string4 = "arrayOfStructParm";
                                bl = true;
                            } else if (string5.indexOf("parm type=structArray") != -1) {
                                string4 = "arrayOfStruct";
                                bl = true;
                            }
                            Trace.log(7, "Error parsing xsd stream in endElement:", string5);
                        }
                        string5 = lineNumberReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Trace.log(7, "Error reading xsd stream in endElement.", (Throwable)iOException);
                }
            }
            if (!(string4.equals("parameterList") || string4.equals("i") || string4.equals("struct_i"))) {
                this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
            }
            if (PcmlSAXParser.getKnownArrayTypes().contains(string4)) {
                this.dimensions.set(this.curDim, 0);
                --this.curDim;
            }
        }
    }

    private static final String getBracketedTagName(String string) {
        return "<" + string + ">";
    }

    boolean inTree(String string, AttributesImpl attributesImpl) {
        boolean bl = false;
        String string2 = "";
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if (!attributesImpl.getQName(i).equals("name")) continue;
            string2 = attributesImpl.getValue(i);
        }
        PcmlNode pcmlNode = null;
        Enumeration enumeration = this.m_currentNode.getChildren();
        if (enumeration != null) {
            while (enumeration.hasMoreElements() && !bl) {
                pcmlNode = (PcmlNode)enumeration.nextElement();
                if (!pcmlNode.getName().equals(string2) || string2.length() <= 0) continue;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.exceptionIfParseError_) {
            if (this.m_xh == null) {
                throw sAXParseException;
            }
            this.m_xh.warning(sAXParseException);
        } else {
            Trace.log(7, "[Warning]: " + sAXParseException.getMessage());
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.exceptionIfParseError_) {
            if (this.m_xh == null) {
                throw sAXParseException;
            }
            this.m_xh.error(sAXParseException);
        } else {
            Trace.log(7, "[Error]: " + sAXParseException.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.m_xh == null) {
            throw sAXParseException;
        }
        this.m_xh.error(sAXParseException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashSet getKnownTypes() {
        if (knownTypes_ != null) return knownTypes_;
        Class<PcmlSAXParser> clazz = PcmlSAXParser.class;
        synchronized (PcmlSAXParser.class) {
            if (knownTypes_ != null) return knownTypes_;
            knownTypes_ = new HashSet(50);
            knownTypes_.addAll(PcmlSAXParser.getKnownArrayTypes());
            String[] stringArray = new String[]{"byteParm", "dateParm", "doubleParm", "floatParm", "hexBinaryParm", "intParm", "longParm", "packedDecimalParm", "parameterList", "program", "shortParm", "stringParm", "struct", "structParm", "timeParm", "timestampParm", "unsignedByteParm", "unsignedIntParm", "unsignedLongParm", "unsignedShortParm", "xpcml", "zonedDecimalParm"};
            for (int i = 0; i < stringArray.length; ++i) {
                knownTypes_.add(stringArray[i]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return knownTypes_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashSet getKnownArrayTypes() {
        if (knownArrayTypes_ != null) return knownArrayTypes_;
        Class<PcmlSAXParser> clazz = PcmlSAXParser.class;
        synchronized (PcmlSAXParser.class) {
            if (knownArrayTypes_ != null) return knownArrayTypes_;
            knownArrayTypes_ = new HashSet(25);
            String[] stringArray = new String[]{"arrayOfByteParm", "arrayOfDateParm", "arrayOfDoubleParm", "arrayOfFloatParm", "arrayOfHexBinaryParm", "arrayOfIntParm", "arrayOfLongParm", "arrayOfPackedDecimalParm", "arrayOfShortParm", "arrayOfStringParm", "arrayOfStruct", "arrayOfStructParm", "arrayOfTimeParm", "arrayOfTimestampParm", "arrayOfUnsignedByteParm", "arrayOfUnsignedIntParm", "arrayOfUnsignedLongParm", "arrayOfUnsignedShortParm", "arrayOfZonedDecimalParm"};
            for (int i = 0; i < stringArray.length; ++i) {
                knownArrayTypes_.add(stringArray[i]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return knownArrayTypes_;
        }
    }
}

