/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400Array;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.ArrayFieldDescription;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.TimeFieldDescription;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlAttribute;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.RfmlData;
import com.ibm.as400.data.RfmlDescriptor;
import com.ibm.as400.data.RfmlDocument;
import com.ibm.as400.data.RfmlRecordFormat;
import com.ibm.as400.data.RfmlSAXParser;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XmlException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.Vector;

public class RecordFormatDocument
implements Serializable,
Cloneable {
    static final long serialVersionUID = 5L;
    static final String RFML_VERSION = "4.0";
    private RfmlDocument m_rfmlDoc_;

    public RecordFormatDocument() {
    }

    public RecordFormatDocument(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("documentName");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(string, null);
    }

    public RecordFormatDocument(String string, ClassLoader classLoader) throws XmlException {
        if (string == null) {
            throw new NullPointerException("documentName");
        }
        if (classLoader == null) {
            throw new NullPointerException("loader");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(string, classLoader);
    }

    public RecordFormatDocument(Record record) throws XmlException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        RecordFormat recordFormat = record.getRecordFormat();
        if (recordFormat == null) {
            throw new XmlException("RECORD_NOT_INITIALIZED");
        }
        this.setRecordFormat(recordFormat);
        this.setValues(recordFormat.getName(), record);
    }

    public RecordFormatDocument(RecordFormat recordFormat) throws XmlException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        this.setRecordFormat(recordFormat);
    }

    private static void addAttribute(PcmlAttributeList pcmlAttributeList, String string, String string2) {
        PcmlAttribute pcmlAttribute = new PcmlAttribute(string, string2, true);
        pcmlAttributeList.addAttribute(pcmlAttribute);
    }

    public Object clone() {
        RecordFormatDocument recordFormatDocument = null;
        try {
            recordFormatDocument = (RecordFormatDocument)super.clone();
            if (this.m_rfmlDoc_ != null) {
                recordFormatDocument.m_rfmlDoc_ = (RfmlDocument)this.m_rfmlDoc_.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(1, cloneNotSupportedException);
        }
        return recordFormatDocument;
    }

    private static PcmlAttributeList generateAttributeList(FieldDescription fieldDescription, boolean bl, Vector vector, String string) throws XmlException {
        int n;
        Object object;
        AS400DataType aS400DataType = fieldDescription.getDataType();
        PcmlAttributeList pcmlAttributeList = new PcmlAttributeList(1);
        int n2 = 1;
        int n3 = aS400DataType.getInstanceType();
        if (n3 == 0) {
            n2 = ((AS400Array)aS400DataType).getNumberOfElements();
            if (n2 < 0) {
                Trace.log(1, "AS400Array count is not set (" + n2 + ")");
                n2 = 1;
            }
            RecordFormatDocument.addAttribute(pcmlAttributeList, "count", Integer.toString(n2));
            aS400DataType = ((AS400Array)aS400DataType).getType();
            n3 = aS400DataType.getInstanceType();
            if (aS400DataType.getInstanceType() == 0) {
                throw new XmlException("MULTI_ARRAY_NOT_SUPPORTED");
            }
        }
        if (n3 == 8) {
            throw new XmlException("DATATYPE_NOT_SUPPORTED", new String[]{"AS400Structure"});
        }
        String string2 = fieldDescription.getFieldName();
        if (vector.contains(string2)) {
            throw new XmlException("DUPLICATE_FIELD_NAME", new String[]{string, string2});
        }
        if (string2 != null && string2.length() != 0) {
            RecordFormatDocument.addAttribute(pcmlAttributeList, "name", string2);
            vector.add(string2);
        }
        if (n3 != 1 && n3 != 10 && n3 != 2 && n3 != 11 && n3 != 3 && n3 != 16 && n3 != 5 && n3 != 6 && n3 != 7) {
            int n4 = n2 == 0 ? fieldDescription.getLength() : fieldDescription.getLength() / n2;
            RecordFormatDocument.addAttribute(pcmlAttributeList, "length", Integer.toString(n4));
        }
        if ((object = fieldDescription.getDFT()) == null) {
            object = fieldDescription.getDFTCurrentValue();
        }
        if (object != null) {
            if (object instanceof byte[] && ((byte[])object).length != 0) {
                CharSequence charSequence;
                byte[] byArray = (byte[])object;
                if (RecordFormatDocument.isSameByteRepeated(byArray)) {
                    charSequence = Byte.toString(byArray[0]);
                    RecordFormatDocument.addAttribute(pcmlAttributeList, "init", (String)charSequence);
                } else {
                    charSequence = new StringBuffer();
                    for (n = 0; n < byArray.length; ++n) {
                        ((StringBuffer)charSequence).append(Byte.toString(byArray[n]) + " ");
                    }
                    ((StringBuffer)charSequence).deleteCharAt(((StringBuffer)charSequence).length() - 1);
                    RecordFormatDocument.addAttribute(pcmlAttributeList, "init", ((StringBuffer)charSequence).toString());
                }
            } else {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "init", object.toString());
            }
        }
        switch (n3) {
            case 1: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "int");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "2");
                break;
            }
            case 2: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "int");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "4");
                break;
            }
            case 3: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "int");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "8");
                break;
            }
            case 10: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "int");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "2");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "precision", "16");
                break;
            }
            case 11: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "int");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "4");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "precision", "32");
                break;
            }
            case 16: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "int");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "8");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "precision", "64");
                break;
            }
            case 4: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "byte");
                break;
            }
            case 5: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "float");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "4");
                break;
            }
            case 6: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "float");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", "8");
                break;
            }
            case 7: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "packed");
                int n5 = ((AS400PackedDecimal)aS400DataType).getNumberOfDigits();
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", Integer.toString(n5));
                int n6 = ((AS400PackedDecimal)aS400DataType).getNumberOfDecimalPositions();
                RecordFormatDocument.addAttribute(pcmlAttributeList, "precision", Integer.toString(n6));
                break;
            }
            case 9: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "char");
                try {
                    if (fieldDescription instanceof ArrayFieldDescription) {
                        n = ((AS400Text)aS400DataType).getCcsid();
                        if (n <= 0) break;
                        RecordFormatDocument.addAttribute(pcmlAttributeList, "ccsid", Integer.toString(n));
                        break;
                    }
                    Method method = fieldDescription.getClass().getMethod("getCCSID", null);
                    String string3 = (String)method.invoke((Object)fieldDescription, (Object[])null);
                    if (string3 == null || string3.length() == 0) break;
                    RecordFormatDocument.addAttribute(pcmlAttributeList, "ccsid", string3);
                }
                catch (Exception exception) {
                    Trace.log(1, exception);
                }
                break;
            }
            case 12: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "zoned");
                n = ((AS400ZonedDecimal)aS400DataType).getNumberOfDecimalPositions();
                RecordFormatDocument.addAttribute(pcmlAttributeList, "precision", Integer.toString(n));
                break;
            }
            case 17: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "date");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", Integer.toString(fieldDescription.getLength()));
                String string4 = ((DateFieldDescription)((Object)aS400DataType)).getDATFMT();
                RecordFormatDocument.addAttribute(pcmlAttributeList, "dateformat", string4);
                String string5 = ((DateFieldDescription)((Object)aS400DataType)).getDATSEP();
                RecordFormatDocument.addAttribute(pcmlAttributeList, "dateseparator", string5);
                break;
            }
            case 18: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "time");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", Integer.toString(fieldDescription.getLength()));
                String string6 = ((TimeFieldDescription)((Object)aS400DataType)).getTIMFMT();
                RecordFormatDocument.addAttribute(pcmlAttributeList, "timeformat", string6);
                String string7 = ((TimeFieldDescription)((Object)aS400DataType)).getTIMSEP();
                RecordFormatDocument.addAttribute(pcmlAttributeList, "timeseparator", string7);
                break;
            }
            case 19: {
                RecordFormatDocument.addAttribute(pcmlAttributeList, "type", "timestamp");
                RecordFormatDocument.addAttribute(pcmlAttributeList, "length", Integer.toString(fieldDescription.getLength()));
                break;
            }
            default: {
                Trace.log(2, "Unrecognized data type: dtType==" + n3);
                throw new InternalErrorException(6);
            }
        }
        if (bl) {
            RecordFormatDocument.addAttribute(pcmlAttributeList, "keyfield", "true");
        }
        return pcmlAttributeList;
    }

    public static Descriptor getDescriptor(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("documentName");
        }
        RfmlDocument rfmlDocument = null;
        rfmlDocument = RecordFormatDocument.loadRfmlDocument(string, null);
        return new RfmlDescriptor(rfmlDocument);
    }

    public static Descriptor getDescriptor(String string, ClassLoader classLoader) throws XmlException {
        if (string == null) {
            throw new NullPointerException("documentName");
        }
        if (classLoader == null) {
            throw new NullPointerException("loader");
        }
        RfmlDocument rfmlDocument = null;
        rfmlDocument = RecordFormatDocument.loadRfmlDocument(string, classLoader);
        return new RfmlDescriptor(rfmlDocument);
    }

    public Descriptor getDescriptor() {
        if (this.m_rfmlDoc_ != null) {
            return new RfmlDescriptor(this.m_rfmlDoc_);
        }
        return null;
    }

    String getDocName() {
        if (this.m_rfmlDoc_ == null) {
            return null;
        }
        return this.m_rfmlDoc_.getDocName();
    }

    public double getDoubleValue(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getDoubleValue(string);
    }

    public double getDoubleValue(String string, int[] nArray) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (nArray == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getDoubleValue(string, new PcmlDimensions(nArray));
    }

    public int getIntValue(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getIntValue(string);
    }

    public int getIntValue(String string, int[] nArray) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (nArray == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getIntValue(string, new PcmlDimensions(nArray));
    }

    public String getStringValue(String string) throws XmlException {
        return this.getStringValue(string, 0);
    }

    public String getStringValue(String string, int n) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getStringValue(string, n);
    }

    public String getStringValue(String string, int[] nArray, int n) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (nArray == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getStringValue(string, new PcmlDimensions(nArray), n);
    }

    public Object getValue(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getValue(string);
    }

    public Object getValue(String string, int[] nArray) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (nArray == null) {
            throw new NullPointerException("indices");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        return this.m_rfmlDoc_.getValue(string, new PcmlDimensions(nArray));
    }

    private static boolean isSameByteRepeated(byte[] byArray) {
        for (int i = 1; i < byArray.length; ++i) {
            if (byArray[i] == byArray[0]) continue;
            return false;
        }
        return true;
    }

    private static RfmlDocument loadRfmlDocument(String string, ClassLoader classLoader) throws XmlException {
        RfmlDocument rfmlDocument = null;
        rfmlDocument = RecordFormatDocument.loadSerializedRfmlDocument(string, classLoader);
        if (rfmlDocument != null) {
            return rfmlDocument;
        }
        rfmlDocument = RecordFormatDocument.loadSourceRfmlDocument(string, classLoader);
        return rfmlDocument;
    }

    private static RfmlDocument loadSerializedRfmlDocument(String string, ClassLoader classLoader) throws XmlException {
        RfmlDocument rfmlDocument = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = SystemResourceFinder.getSerializedRFMLDocument(string, classLoader);
            objectInputStream = new ObjectInputStream(inputStream);
            rfmlDocument = (RfmlDocument)objectInputStream.readObject();
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (StreamCorruptedException streamCorruptedException) {
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                iOException.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.isTraceErrorOn()) {
                classNotFoundException.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(classNotFoundException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return rfmlDocument;
    }

    private static RfmlDocument loadSourceRfmlDocument(String string, ClassLoader classLoader) throws XmlException {
        RfmlDocument rfmlDocument = null;
        try {
            RfmlSAXParser rfmlSAXParser = new RfmlSAXParser();
            rfmlSAXParser.parse(string, classLoader);
            rfmlDocument = rfmlSAXParser.getRfmlDocument();
        }
        catch (ParseException parseException) {
            parseException.reportErrors();
            throw new XmlException(parseException);
        }
        catch (PcmlSpecificationException pcmlSpecificationException) {
            pcmlSpecificationException.reportErrors();
            throw new XmlException(pcmlSpecificationException);
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                iOException.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(iOException);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                exception.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(exception);
        }
        return rfmlDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = SystemResourceFinder.format("PCD_ARGUMENTS");
        if (stringArray.length == 2) {
            if (!stringArray[0].equalsIgnoreCase("-SERIALIZE")) {
                System.out.println(string);
                System.exit(-1);
            }
            FileOutputStream fileOutputStream = null;
            try {
                RecordFormatDocument recordFormatDocument = new RecordFormatDocument(stringArray[1]);
                String string2 = recordFormatDocument.getDocName() + ".rfml.ser";
                fileOutputStream = new FileOutputStream(string2);
                recordFormatDocument.serialize(fileOutputStream);
                Trace.log(7, SystemResourceFinder.format("XML_SERIALIZED", new Object[]{"RFML", string2}));
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.exit(-1);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            System.out.println(string);
            System.exit(-1);
        }
    }

    private static void saveRfmlDocument(RfmlDocument rfmlDocument, OutputStream outputStream) throws XmlException {
        ObjectOutputStream objectOutputStream = null;
        rfmlDocument.setSerializingWithData(false);
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(rfmlDocument);
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                iOException.printStackTrace(Trace.getPrintWriter());
            }
            throw new XmlException(iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void serialize(OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RecordFormatDocument.saveRfmlDocument(this.m_rfmlDoc_, outputStream);
    }

    public void serialize(File file) throws IOException, XmlException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            this.serialize(fileOutputStream);
        }
    }

    public void serialize(String string) throws IOException, XmlException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(string);
            this.serialize(fileOutputStream);
        }
    }

    public void setIntValue(String string, int n) throws XmlException {
        this.setValue(string, new Integer(n));
    }

    public void setIntValue(String string, int[] nArray, int n) throws XmlException {
        this.setValue(string, nArray, new Integer(n));
    }

    private void setRecordFormat(RecordFormat recordFormat) throws XmlException {
        String string = recordFormat.getName();
        if (string == null || string.length() == 0) {
            Trace.log(2, "RecordFormat name is null or zero-length.");
            throw new XmlException("RECORDFORMAT_NOT_INITIALIZED");
        }
        this.setRecordFormat(string, recordFormat);
    }

    private void setRecordFormat(String string, RecordFormat recordFormat) throws XmlException {
        PcmlAttributeList pcmlAttributeList = new PcmlAttributeList(1);
        RecordFormatDocument.addAttribute(pcmlAttributeList, "version", RFML_VERSION);
        this.m_rfmlDoc_ = new RfmlDocument(pcmlAttributeList, recordFormat.getName());
        pcmlAttributeList = new PcmlAttributeList(1);
        RecordFormatDocument.addAttribute(pcmlAttributeList, "name", string);
        RfmlRecordFormat rfmlRecordFormat = new RfmlRecordFormat(pcmlAttributeList);
        this.m_rfmlDoc_.addChild(rfmlRecordFormat);
        FieldDescription[] fieldDescriptionArray = recordFormat.getFieldDescriptions();
        Object[] objectArray = recordFormat.getKeyFieldDescriptions();
        Vector vector = new Vector();
        for (int i = 0; i < fieldDescriptionArray.length; ++i) {
            FieldDescription fieldDescription = fieldDescriptionArray[i];
            boolean bl = RecordFormatDocument.contains(objectArray, fieldDescription);
            pcmlAttributeList = RecordFormatDocument.generateAttributeList(fieldDescription, bl, vector, recordFormat.getName());
            if (pcmlAttributeList == null) continue;
            RfmlData rfmlData = new RfmlData(pcmlAttributeList);
            rfmlRecordFormat.addChild(rfmlData);
        }
    }

    private static final boolean contains(Object[] objectArray, Object object) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length && !bl; ++i) {
            if (!objectArray[i].equals(object)) continue;
            bl = true;
        }
        return bl;
    }

    public void setStringValue(String string, String string2) throws XmlException {
        this.setStringValue(string, string2, 0);
    }

    public void setStringValue(String string, String string2, int n) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setStringValue(string, string2, n);
    }

    public void setStringValue(String string, int[] nArray, String string2, int n) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (nArray == null) {
            throw new NullPointerException("indices");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setStringValue(string, string2, new PcmlDimensions(nArray), n);
    }

    public void setDocument(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("documentName");
        }
        if (this.m_rfmlDoc_ != null) {
            throw new XmlException("DOCUMENT_ALREADY_SET");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(string, null);
    }

    public void setDocument(String string, ClassLoader classLoader) throws XmlException {
        if (string == null) {
            throw new NullPointerException("documentName");
        }
        if (classLoader == null) {
            throw new NullPointerException("loader");
        }
        if (this.m_rfmlDoc_ != null) {
            throw new XmlException("DOCUMENT_ALREADY_SET");
        }
        this.m_rfmlDoc_ = RecordFormatDocument.loadRfmlDocument(string, classLoader);
    }

    public void setValue(String string, Object object) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (object == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setValue(string, object);
    }

    public void setValue(String string, int[] nArray, Object object) throws XmlException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (nArray == null) {
            throw new NullPointerException("indices");
        }
        if (object == null) {
            throw new NullPointerException("value");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.setValue(string, object, new PcmlDimensions(nArray));
    }

    public void setValues(String string, Record record) throws XmlException {
        Serializable serializable;
        if (string == null) {
            throw new NullPointerException("formatName");
        }
        if (record == null) {
            throw new NullPointerException("record");
        }
        if (this.m_rfmlDoc_ == null) {
            serializable = record.getRecordFormat();
            if (serializable != null) {
                this.setRecordFormat(string, (RecordFormat)serializable);
            } else {
                Trace.log(2, "The Record has a null RecordFormat.");
                throw new XmlException("RECORD_NOT_INITIALIZED");
            }
        }
        serializable = this.m_rfmlDoc_.getRecordFormatNode(string);
        try {
            ((RfmlRecordFormat)serializable).setValues(record);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XmlException(unsupportedEncodingException);
        }
    }

    public void setValues(String string, byte[] byArray) throws XmlException {
        if (string == null) {
            throw new NullPointerException("formatName");
        }
        if (byArray == null) {
            throw new NullPointerException("values");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RfmlRecordFormat rfmlRecordFormat = this.m_rfmlDoc_.getRecordFormatNode(string);
        int n = rfmlRecordFormat.parseBytes(byArray);
        if (n < byArray.length) {
            throw new XmlException("EXCESS_INPUT_DATA", new Object[]{Integer.toString(n), Integer.toString(byArray.length), "<recordformat>", this.m_rfmlDoc_.getNameForException()});
        }
    }

    public byte[] toByteArray(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("formatName");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RfmlRecordFormat rfmlRecordFormat = this.m_rfmlDoc_.getRecordFormatNode(string);
        return rfmlRecordFormat.toBytes();
    }

    public Record toRecord(String string) throws XmlException {
        try {
            return new Record(this.toRecordFormat(string), this.toByteArray(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XmlException(unsupportedEncodingException);
        }
    }

    public RecordFormat toRecordFormat(String string) throws XmlException {
        if (string == null) {
            throw new NullPointerException("formatName");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        RfmlRecordFormat rfmlRecordFormat = this.m_rfmlDoc_.getRecordFormatNode(string);
        return rfmlRecordFormat.toRecordFormat();
    }

    public void toXml(OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_rfmlDoc_ == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_rfmlDoc_.toXml(outputStream);
    }

    public void toXml(File file) throws IOException, XmlException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            this.toXml(fileOutputStream);
        }
    }

    public void toXml(String string) throws IOException, XmlException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(string);
            this.toXml(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RecordFormatDocument recordFormatDocument = this;
        synchronized (recordFormatDocument) {
            if (this.m_rfmlDoc_ != null) {
                this.m_rfmlDoc_.setSerializingWithData(true);
            }
            objectOutputStream.defaultWriteObject();
        }
    }
}

