/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.CommandMap;
import com.ibm.as400.resource.CommandMapEntry;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ValueMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

class CommandAttributeSetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private CommandMap attributeMap_ = null;
    private CommandCall commandCall_ = null;
    private CharConverter converter_ = null;
    private int defaultStringType_ = -1;
    private Hashtable invariants_ = new Hashtable();
    private AS400 system_ = null;

    public CommandAttributeSetter(AS400 aS400, CommandMap commandMap) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (commandMap == null) {
            throw new NullPointerException("attributeMap");
        }
        this.system_ = aS400;
        this.commandCall_ = new CommandCall(aS400);
        this.attributeMap_ = commandMap;
    }

    private void append(ByteArrayOutputStream byteArrayOutputStream, String string) throws IOException {
        if (this.defaultStringType_ == -1) {
            this.defaultStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        if (this.converter_ == null) {
            this.converter_ = new CharConverter(this.system_.getCcsid(), this.system_);
        }
        byteArrayOutputStream.write(this.converter_.stringToByteArray(string));
    }

    private void append(ByteArrayOutputStream byteArrayOutputStream, String string, Object object) throws IOException {
        if (this.defaultStringType_ == -1) {
            this.defaultStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        this.append(byteArrayOutputStream, string, object, this.defaultStringType_);
    }

    private void append(ByteArrayOutputStream byteArrayOutputStream, String string, Object object, int n) throws IOException {
        if (this.converter_ == null) {
            this.converter_ = new CharConverter(this.system_.getCcsid(), this.system_);
        }
        byteArrayOutputStream.write(this.converter_.stringToByteArray(string + "("));
        byteArrayOutputStream.write(this.converter_.stringToByteArray(object.toString(), n));
        byteArrayOutputStream.write(this.converter_.stringToByteArray(") "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("commandName");
        }
        if (string2 == null) {
            throw new NullPointerException("parameterName");
        }
        if (string3 == null) {
            throw new NullPointerException("parameterValue");
        }
        CommandAttributeSetter commandAttributeSetter = this;
        synchronized (commandAttributeSetter) {
            Hashtable hashtable;
            if (this.invariants_.containsKey(string)) {
                hashtable = (Hashtable)this.invariants_.get(string);
            } else {
                hashtable = new Hashtable();
                this.invariants_.put(string, hashtable);
            }
            hashtable.put(string2, string3);
        }
    }

    public void setValues(Object[] objectArray, Object[] objectArray2) throws ResourceException {
        if (objectArray == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (this.defaultStringType_ == -1) {
            this.defaultStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.defaultStringType_;
        }
        this.setValues(objectArray, objectArray2, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] objectArray, Object[] objectArray2, int[] nArray) throws ResourceException {
        if (objectArray == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (objectArray2 == null) {
            throw new NullPointerException("values");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (objectArray.length != nArray.length) {
            throw new ExtendedIllegalArgumentException("bidiStringTypes", 2);
        }
        if (this.commandCall_.getSystem() == null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        try {
            CommandAttributeSetter commandAttributeSetter = this;
            synchronized (commandAttributeSetter) {
                int n;
                Object object;
                Object object2;
                Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
                for (int i = 0; i < objectArray.length; ++i) {
                    ValueMap valueMap;
                    Object object3;
                    object2 = this.attributeMap_.getEntries(objectArray[i]);
                    object = null;
                    n = -1;
                    for (int j = 0; j < ((Object)object2).length; ++j) {
                        object3 = ((CommandMapEntry)object2[j]).getCommandName();
                        if (!hashtable.containsKey(object3)) continue;
                        object = (ByteArrayOutputStream)hashtable.get(object3);
                        n = j;
                        break;
                    }
                    if (object == null) {
                        String string = ((CommandMapEntry)object2[0]).getCommandName();
                        object = new ByteArrayOutputStream();
                        this.append((ByteArrayOutputStream)object, string + " ");
                        if (this.invariants_.containsKey(string)) {
                            object3 = (Hashtable)this.invariants_.get(string);
                            Enumeration enumeration = ((Hashtable)object3).keys();
                            while (enumeration.hasMoreElements()) {
                                String string2 = (String)enumeration.nextElement();
                                String string3 = (String)((Hashtable)object3).get(string2);
                                this.append((ByteArrayOutputStream)object, string2, string3);
                            }
                        }
                        hashtable.put(string, (byte[])object);
                        n = 0;
                    }
                    object3 = (valueMap = ((CommandMapEntry)object2[n]).getValueMap()) != null ? valueMap.ltop(objectArray2[i], this.commandCall_.getSystem()) : objectArray2[i];
                    this.append((ByteArrayOutputStream)object, ((CommandMapEntry)object2[n]).getParameterName(), object3, nArray[i]);
                }
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (ByteArrayOutputStream)enumeration.nextElement();
                    object = ((ByteArrayOutputStream)object2).toByteArray();
                    if (Trace.isTraceOn()) {
                        String string = this.converter_.byteArrayToString((byte[])object);
                        Trace.log(3, "Setting attribute values using command: " + string + ".");
                    }
                    try {
                        n = this.commandCall_.run((byte[])object) ? 1 : 0;
                        if (n != 0) continue;
                        throw new ResourceException(this.commandCall_.getMessageList());
                    }
                    catch (Exception exception) {
                        throw new ResourceException(2, (Throwable)exception);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new ResourceException(2, (Throwable)iOException);
        }
    }
}

