/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import java.awt.Image;
import java.beans.SimpleBeanInfo;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PresentationLoader
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String DESCRIPTION_SUFFIX = "_DESCRIPTION";
    private static final String FULLNAME_SUFFIX = "_FULLNAME";
    private static final String HELP_SUFFIX = "_HELP";
    private static final String NAME_SUFFIX = "_NAME";
    private static final String ICON_16_SUFFIX = "16.gif";
    private static final String ICON_32_SUFFIX = "32.gif";
    private static IconLoader_ iconLoader_;
    private ResourceBundle resourceBundle_;

    public PresentationLoader(String string) {
        if (string == null) {
            throw new NullPointerException("resourceBundleBaseName");
        }
        this.resourceBundle_ = ResourceBundle.getBundle(string);
    }

    public PresentationLoader(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new NullPointerException("resourceBundle");
        }
        this.resourceBundle_ = resourceBundle;
    }

    public Presentation getPresentation(String string) {
        if (string == null) {
            throw new NullPointerException("keyBaseName");
        }
        return this.newPresentation(string, null);
    }

    public Presentation getPresentationWithIcon(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("keyBaseName");
        }
        if (string2 == null) {
            throw new NullPointerException("iconFileName");
        }
        return this.newPresentation(string, string2);
    }

    public Presentation getPresentation(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("keyBaseName");
        }
        if (string2 == null) {
            throw new NullPointerException("keySuffix");
        }
        return this.newPresentation(PresentationLoader.newKeyBaseName(string, string2), null);
    }

    public Presentation getPresentationWithIcon(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("keyBaseName");
        }
        if (string2 == null) {
            throw new NullPointerException("keySuffix");
        }
        if (string3 == null) {
            throw new NullPointerException("iconFileName");
        }
        return this.newPresentation(PresentationLoader.newKeyBaseName(string, string2), string3);
    }

    private String getString(String string) {
        try {
            return this.resourceBundle_.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    static Image loadIcon(String string) {
        if (string == null) {
            throw new NullPointerException("iconFileName");
        }
        if (iconLoader_ == null) {
            iconLoader_ = new IconLoader_();
        }
        try {
            return iconLoader_.loadImage(string);
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to load icon: " + string, (Throwable)exception);
            }
            return null;
        }
    }

    private static String newKeyBaseName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('_');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private Presentation newPresentation(String string, String string2) {
        String string3 = this.getString(string + NAME_SUFFIX);
        String string4 = this.getString(string + FULLNAME_SUFFIX);
        String string5 = this.getString(string + DESCRIPTION_SUFFIX);
        String string6 = this.getString(string + HELP_SUFFIX);
        if (string3 == null && string4 == null && string5 == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to load presentation for " + string);
            }
            throw new ExtendedIllegalArgumentException("keyBaseName", 2);
        }
        Presentation presentation = new Presentation();
        if (string3 != null) {
            presentation.setName(string3);
        }
        if (string4 != null) {
            presentation.setFullName(string4);
        }
        if (string5 != null) {
            presentation.setValue("Description Text", string5);
        }
        if (string6 != null) {
            presentation.setValue("Help Text", string6);
        }
        if (string2 != null) {
            presentation.setColorIcons(string2 + ICON_16_SUFFIX, string2 + ICON_32_SUFFIX);
        }
        return presentation;
    }

    private static class IconLoader_
    extends SimpleBeanInfo {
        private IconLoader_() {
        }
    }
}

