/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BufferedResourceList;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;

public class SystemResourceList
extends BufferedResourceList {
    static final long serialVersionUID = 4L;
    private static final String closeProgramName_ = "qgyclst";
    private static final String requestHandleDataNameSuffix_ = ".requestHandle";
    private static final String closeRequestHandleDataName_ = "qgyclst.requestHandle";
    private static final String getProgramName_ = "qgygtle";
    private static final String getNumberOfRecordsToReturnDataName_ = "qgygtle.numberOfRecordsToReturn";
    private static final String getRequestHandleDataName_ = "qgygtle.requestHandle";
    private static final String getStartingRecordDataName_ = "qgygtle.startingRecord";
    private static final String listInformationDataNameSuffix_ = ".listInformation";
    private static final String listStatusIndicatorDataNameSuffix_ = ".listInformation.listStatusIndicator";
    private static final String receiverVariableLengthDataName_ = "qgygtle.receiverVariableLength";
    private static final String recordsReturnedDataNameSuffix_ = ".listInformation.recordsReturned";
    private static final String requestHandleDataNameSuffix2_ = ".listInformation.requestHandle";
    private static final String totalRecordsDataNameSuffix_ = ".listInformation.totalRecords";
    private String formatName_ = null;
    private String openListProgramName_ = null;
    private ProgramMap selectionMap_ = null;
    private Hashtable selectionBidiStringTypes_ = new Hashtable();
    private transient ProgramCallDocument document_ = null;
    private transient int formatLength_ = -1;
    private transient byte[] requestHandle_ = null;

    SystemResourceList(Presentation presentation, ResourceMetaDataTable resourceMetaDataTable, ResourceMetaDataTable resourceMetaDataTable2, ResourceMetaDataTable resourceMetaDataTable3, String string, String string2, ProgramMap programMap) {
        super(presentation, resourceMetaDataTable, resourceMetaDataTable2, resourceMetaDataTable3);
        this.initializeTransient();
        if (string == null) {
            throw new NullPointerException("openListProgramName");
        }
        this.openListProgramName_ = string;
        this.formatName_ = string2;
        this.selectionMap_ = programMap;
    }

    @Override
    public void close() throws ResourceException {
        block11: {
            if (!this.isOpen()) {
                return;
            }
            super.close();
            this.fireBusy();
            try {
                if (this.document_ != null && this.requestHandle_ != null) {
                    this.document_.setValue(closeRequestHandleDataName_, this.requestHandle_);
                    if (!this.document_.callProgram(closeProgramName_)) {
                        throw new ResourceException(this.document_.getMessageList(closeProgramName_));
                    }
                }
            }
            catch (ResourceException resourceException) {
                AS400Message[] aS400MessageArray = resourceException.getMessageList();
                if (aS400MessageArray != null && aS400MessageArray.length > 0 && aS400MessageArray[0].getID().equals("GUI0001")) {
                    break block11;
                }
                throw resourceException;
            }
            catch (PcmlException pcmlException) {
                throw new ResourceException(pcmlException);
            }
            finally {
                this.requestHandle_ = null;
                this.fireIdle();
            }
        }
    }

    ProgramCallDocument getDocument() {
        return this.document_;
    }

    private void initializeTransient() {
        this.formatLength_ = -1;
    }

    @Override
    protected boolean isBidiEnabled() {
        return true;
    }

    @Override
    public boolean isResourceAvailable(long l) throws ResourceException {
        boolean bl = super.isResourceAvailable(l);
        if (!bl && this.isOpen()) {
            this.loadResources(0L, 0L);
            bl = l < this.getListLength();
        }
        return bl;
    }

    private void loadResources(long l, long l2) throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Loading resources (" + l + ", " + l2 + ") from list " + this + ".");
        }
        this.fireBusy();
        try {
            if (this.formatName_ != null) {
                if (this.formatLength_ == -1) {
                    this.formatLength_ = this.document_.getOutputsize(this.formatName_);
                }
                if (l2 == 0L) {
                    this.document_.setIntValue(receiverVariableLengthDataName_, 1);
                } else {
                    this.document_.setIntValue(receiverVariableLengthDataName_, (int)l2 * this.formatLength_);
                }
            }
            this.document_.setValue(getRequestHandleDataName_, this.requestHandle_);
            this.document_.setIntValue(getNumberOfRecordsToReturnDataName_, (int)l2);
            this.document_.setIntValue(getStartingRecordDataName_, (int)l);
            if (!this.document_.callProgram(getProgramName_)) {
                throw new ResourceException(this.document_.getMessageList(getProgramName_));
            }
            this.process(getProgramName_, l - 1L);
        }
        catch (PcmlException pcmlException) {
            throw new ResourceException(pcmlException);
        }
        finally {
            this.fireIdle();
        }
    }

    Resource newResource(String string, int[] nArray) throws PcmlException, ResourceException {
        throw new ResourceException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ResourceException {
        if (this.isOpen()) {
            return;
        }
        super.open();
        this.fireBusy();
        try {
            SystemResourceList systemResourceList = this;
            synchronized (systemResourceList) {
                if (!this.isConnectionEstablished()) {
                    this.establishConnection();
                }
                try {
                    this.setOpenParameters(this.document_);
                    boolean bl = this.document_.callProgram(this.openListProgramName_);
                    if (!bl) {
                        throw new ResourceException(this.document_.getMessageList(this.openListProgramName_));
                    }
                    this.requestHandle_ = (byte[])this.document_.getValue(this.openListProgramName_ + requestHandleDataNameSuffix2_);
                    this.process(this.openListProgramName_, 0L);
                }
                catch (Exception exception) {
                    throw new ResourceException(exception);
                }
            }
        }
        finally {
            this.fireIdle();
        }
    }

    private void process(String string, long l) throws PcmlException, ResourceException {
        int n = this.document_.getIntValue(string + recordsReturnedDataNameSuffix_);
        for (int i = 0; i < n; ++i) {
            int[] nArray = new int[]{i};
            Resource resource = this.newResource(string, nArray);
            this.fireResourceAdded(resource, l + (long)i);
        }
        String string2 = (String)this.document_.getValue(string + listStatusIndicatorDataNameSuffix_);
        long l2 = this.document_.getIntValue(string + totalRecordsDataNameSuffix_);
        if (Trace.isTraceOn()) {
            Trace.log(3, "API List status indicator = " + string2);
            Trace.log(3, "API List length = " + l2);
        }
        if (string2.equals("2")) {
            this.fireListCompleted();
        } else if (string2.equals("3")) {
            this.fireListInError();
        }
        if (l2 != this.getListLength()) {
            this.fireLengthChanged(l2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void refreshContents() throws ResourceException {
        if (!this.isConnectionEstablished()) {
            this.establishConnection();
        }
        if (this.isOpen()) {
            this.close();
        }
        super.refreshContents();
    }

    @Override
    public void refreshStatus() throws ResourceException {
        super.refreshStatus();
        this.loadResources(0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource resourceAt(long l) throws ResourceException {
        SystemResourceList systemResourceList = this;
        synchronized (systemResourceList) {
            Resource resource = super.resourceAt(l);
            if (resource == null) {
                this.loadResources(l + 1L, this.getPageSize());
                resource = super.resourceAt(l);
                if (resource == null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "Double load scenario, index=" + l + ", number of pages= " + this.getNumberOfPages() + ", page size=" + this.getPageSize());
                    }
                    this.loadResources(l + 1L, this.getPageSize());
                    resource = super.resourceAt(l);
                }
            }
            return resource;
        }
    }

    void setOpenParameters(ProgramCallDocument programCallDocument) throws PcmlException, ResourceException {
        if (this.selectionMap_ != null) {
            ResourceMetaData[] resourceMetaDataArray = this.getSelectionMetaData();
            Object[] objectArray = new Object[resourceMetaDataArray.length];
            Object[] objectArray2 = new Object[resourceMetaDataArray.length];
            int[] nArray = new int[resourceMetaDataArray.length];
            for (int i = 0; i < resourceMetaDataArray.length; ++i) {
                objectArray[i] = resourceMetaDataArray[i].getID();
                objectArray2[i] = this.getSelectionValue(objectArray[i]);
                Integer n = (Integer)this.selectionBidiStringTypes_.get(objectArray[i]);
                nArray[i] = n == null ? this.getDefaultBidiStringType() : n.intValue();
            }
            this.selectionMap_.setValues(objectArray, objectArray2, this.getSystem(), programCallDocument, this.openListProgramName_, null, nArray);
        }
    }

    void setDocument(ProgramCallDocument programCallDocument) {
        if (programCallDocument == null) {
            throw new NullPointerException("document");
        }
        this.document_ = programCallDocument;
        AS400 aS400 = this.getSystem();
        if (aS400 != null) {
            this.document_.setSystem(aS400);
        }
    }

    void setOpenListProgramName(String string) {
        if (string == null) {
            throw new NullPointerException("openListProgramName");
        }
        this.openListProgramName_ = string;
    }

    @Override
    public void setSelectionValue(Object object, Object object2, int n) throws ResourceException {
        super.setSelectionValue(object, object2, n);
        this.selectionBidiStringTypes_.put(object, new Integer(n));
    }

    @Override
    public void waitForComplete() throws ResourceException {
        super.waitForComplete();
        if (!this.isComplete()) {
            this.loadResources(-1L, 0L);
        }
    }

    @Override
    public void waitForResource(long l) throws ResourceException {
        super.waitForResource(l);
        if (this.isComplete()) {
            return;
        }
        if (!this.isResourceAvailable(l)) {
            this.loadResources(l + 1L, 0L);
        }
    }
}

