/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.IP4Address;

public class ARPHeader
extends Header {
    private Field hardwaretype;
    private Field protocol;
    private Field hdwlength;
    private Field prtlength;
    private Field operation;
    private Field srchdwraddr;
    private Field srcipaddr;
    private Field dsthdwraddr;
    private Field dstipaddr;
    private int frmtype;
    private static final String CLASS = "ARPHeader";
    private static final String FRAME = "Frame Type";
    private static final String REQUEST = "REQUEST";
    private static final String RESPONSE = "RESPONSE";
    private static final String ARP = "ARP ";
    private static final String RARP = "RARP ";
    private static final String SRC = "Src Addr";
    private static final String DST = "Dst Addr";
    private static final String OPER = "Operation";

    ARPHeader(BitBuf bitBuf, int n) {
        super(bitBuf);
        this.hardwaretype = new Dec(this.rawheader.slice(0, 16));
        this.protocol = new Dec(this.rawheader.slice(16, 16));
        this.hdwlength = new Dec(this.rawheader.slice(32, 8));
        this.prtlength = new Dec(this.rawheader.slice(40, 8));
        this.operation = new Dec(this.rawheader.slice(48, 16));
        this.srchdwraddr = new Hex(this.rawheader.slice(64, 48));
        this.srcipaddr = new IP4Address(this.rawheader.slice(112, 32));
        this.dsthdwraddr = new Hex(this.rawheader.slice(144, 48));
        this.dstipaddr = new IP4Address(this.rawheader.slice(192, 32));
        this.frmtype = n;
    }

    @Override
    public int getHeaderLen() {
        return 224;
    }

    @Override
    public String toString(FormatProperties formatProperties) {
        String string = "";
        String string2 = "";
        int n = Integer.parseInt(this.operation.toString());
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (formatProperties != null) {
            boolean bl = false;
            String string3 = formatProperties.getIPAddress();
            String string4 = formatProperties.getSecondIPAddress();
            String string5 = formatProperties.getPort();
            if (string3 == null && string4 == null) {
                bl = true;
            } else if (string4 == null) {
                if (this.srcipaddr.toString().equals(string3) || this.dstipaddr.toString().equals(string3)) {
                    bl = true;
                }
            } else if ((this.srcipaddr.toString().equals(string3) || this.srcipaddr.toString().equals(string4)) && (this.dstipaddr.toString().equals(string3) || this.dstipaddr.toString().equals(string4))) {
                bl = true;
            }
            if (string5 != null) {
                bl = false;
            }
            if (!bl) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "ARPHeader.toString() Frame doesn't pass ARP IP Filter");
                }
                return "";
            }
        }
        if (n == 1 || n == 3 || n == 8) {
            string = REQUEST;
        } else if (n == 2 || n == 4 || n == 9) {
            string = RESPONSE;
        }
        if (this.frmtype == 2054) {
            string2 = ARP;
        } else if (this.frmtype == 32821) {
            string2 = RARP;
        }
        Object[] objectArray = new Object[]{this.srcipaddr, this.dstipaddr, string};
        return Formatter.jsprintf("\t    Frame Type   :  " + string2 + "Src Addr:  {0,16,L} Dst Addr:  {1,16,L} Operation: {2,8,L}\n", objectArray) + this.printHexHeader() + this.printnext(formatProperties) + new Data(this.rawpayload).toString();
    }

    public String getHardwareType() {
        return this.hardwaretype.toString();
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public String getHardwareLength() {
        return this.hdwlength.toString();
    }

    public String getProtocolLength() {
        return this.prtlength.toString();
    }

    public String getOpcode() {
        return this.operation.toString();
    }

    public String getSourceHardwareAddress() {
        return this.srchdwraddr.toString();
    }

    public String getSourceIPAddress() {
        return this.srcipaddr.toString();
    }

    public String getDestinationHardwareAddress() {
        return this.dsthdwraddr.toString();
    }

    public String getDestinationIPAddress() {
        return this.dstipaddr.toString();
    }
}

