/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Frame;
import com.ibm.as400.util.commtrace.Progress;
import com.ibm.as400.util.commtrace.Prolog;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;

public class Format {
    private static final String ALL = "*ALL";
    private static final String NO = "*NO";
    private static final String CLASS = "Format";
    private AS400 sys;
    private boolean createdSys;
    private InputStream file_;
    private Progress progress;
    private byte[] data;
    private Prolog pro_;
    private String filename;
    private String outfilePath_;
    private BitBuf nxtRecLen;
    private int ifsrecs;
    private int tcprecs;
    private int numrecs;
    private FormatProperties filter_;
    private ObjectInputStream serin_;

    public Format() {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
    }

    public Format(AS400 aS400) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.sys = aS400;
    }

    public Format(FormatProperties formatProperties, String string, String string2) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.filter_ = formatProperties;
        this.outfilePath_ = string;
        this.filename = string2;
        if (string2 == null) {
            this.close();
            return;
        }
        try {
            this.file_ = new BufferedInputStream(new FileInputStream(string2));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format()Error opening:" + string2, (Throwable)iOException);
            }
            this.close();
            return;
        }
        this.formatProlog();
    }

    public Format(String[] stringArray) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        CommandLineArguments commandLineArguments;
        block43: {
            String string6;
            this.sys = null;
            this.createdSys = false;
            this.file_ = null;
            this.progress = null;
            this.data = null;
            this.pro_ = null;
            this.filename = null;
            this.outfilePath_ = null;
            this.ifsrecs = 0;
            this.tcprecs = 0;
            this.numrecs = 0;
            Vector<String> vector = new Vector<String>();
            vector.addElement("-userID");
            vector.addElement("-password");
            vector.addElement("-trace");
            vector.addElement("-filename");
            vector.addElement("-outfile");
            vector.addElement("-current");
            vector.addElement("-verbose");
            vector.addElement("-logfile");
            vector.addElement("-country");
            vector.addElement("-language");
            vector.addElement("-ipaddress");
            vector.addElement("-ipaddress2");
            vector.addElement("-port");
            vector.addElement("-broadcast");
            vector.addElement("-starttime");
            vector.addElement("-endtime");
            vector.addElement("-starttimelong");
            vector.addElement("-endtimelong");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("-u", "-userID");
            hashtable.put("-p", "-password");
            hashtable.put("-t", "-trace");
            hashtable.put("-o", "-outfile");
            hashtable.put("-c", "-current");
            hashtable.put("-v", "-verbose");
            hashtable.put("-l", "-language");
            hashtable.put("-co", "-country");
            hashtable.put("-ip", "-ipaddress");
            hashtable.put("-ip2", "-ipaddress2");
            commandLineArguments = new CommandLineArguments(stringArray, vector, hashtable);
            string5 = commandLineArguments.getOptionValue("");
            string4 = commandLineArguments.getOptionValue("-userID");
            string3 = commandLineArguments.getOptionValue("-password");
            string2 = commandLineArguments.getOptionValue("-current");
            this.filename = string = commandLineArguments.getOptionValue("-trace");
            this.outfilePath_ = string6 = commandLineArguments.getOptionValue("-outfile");
            String string7 = commandLineArguments.getOptionValue("-verbose");
            String string8 = commandLineArguments.getOptionValue("-logfile");
            String string9 = commandLineArguments.getOptionValue("-country");
            if (string7 != null && string7.equals("true")) {
                Trace.setTraceErrorOn(true);
                Trace.setTraceWarningOn(true);
                Trace.setTraceInformationOn(true);
                Trace.setTraceOn(true);
            }
            if (string8 != null) {
                try {
                    Trace.setFileName(string8);
                }
                catch (IOException iOException) {
                    if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block43;
                    Trace.log(2, "Format.FormatCan't set trace file name, defaulting to outputing trace data to standard out");
                }
            }
        }
        this.filter_ = new FormatProperties();
        String string10 = commandLineArguments.getOptionValue("-ipaddress");
        String string11 = commandLineArguments.getOptionValue("-ipaddress2");
        String string12 = commandLineArguments.getOptionValue("-port");
        String string13 = commandLineArguments.getOptionValue("-broadcast");
        String string14 = commandLineArguments.getOptionValue("-starttime");
        String string15 = commandLineArguments.getOptionValue("-endtime");
        String string16 = commandLineArguments.getOptionValue("-starttimelong");
        String string17 = commandLineArguments.getOptionValue("-endtimelong");
        boolean bl = false;
        if (string10 != null && !string10.equals(ALL)) {
            this.filter_.setIPAddress(string10);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() IP Filtering enabled");
            }
        }
        if (string11 != null && !string11.equals(ALL)) {
            this.filter_.setSecondIPAddress(string11);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() IP Filtering enabled");
            }
        }
        if (string13 != null && !string13.equals(ALL)) {
            this.filter_.setBroadcast(string13);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Broadcast Filtering enabled");
            }
        }
        if (string12 != null && !string12.equals(ALL)) {
            this.filter_.setPort(string12);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Port Filtering enabled");
            }
        }
        if (string14 != null && !string14.equals(ALL)) {
            this.filter_.setStartTime(string14);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Beginning Timestamp Filtering enabled");
            }
            bl = true;
        }
        if (string15 != null && !string15.equals(ALL)) {
            this.filter_.setEndTime(string15);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() End Timestamp Filtering enabled");
            }
        }
        if (string16 != null && !string16.equals(ALL)) {
            if (string15 != null) {
                Object var23_24 = null;
                this.filter_.setEndTime(null);
            }
            this.filter_.setStartTime(string16);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() Beginning Timestamp Filtering enabled");
            }
        }
        if (string17 != null && !string17.equals(ALL)) {
            this.filter_.setEndTime(string17);
            if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                Trace.log(3, "Format.Format() End Timestamp Filtering enabled");
            }
        }
        if (string == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Outfile not specified");
            }
            return;
        }
        if (string2 != null) {
            this.sys = new AS400();
            this.createdSys = true;
            try {
                this.file_ = new IFSFileInputStream(this.sys, string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
                }
                return;
            }
            catch (IOException iOException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() Error opening " + string, (Throwable)iOException);
                }
                return;
            }
            catch (AS400SecurityException aS400SecurityException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() Security exception opening file", (Throwable)aS400SecurityException);
                }
                return;
            }
        }
        if (string5 == null || string4 == null || string3 == null) {
            try {
                this.file_ = new BufferedInputStream(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
                }
                return;
            }
        }
        this.sys = new AS400(string5, string4, string3);
        this.createdSys = true;
        try {
            this.file_ = new IFSFileInputStream(this.sys, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
            }
            return;
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Error opening" + string, (Throwable)iOException);
            }
            return;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() Security exception opening file", (Throwable)aS400SecurityException);
            }
            return;
        }
        if (!this.formatProlog() && bl) {
            this.setUpFilters();
        }
    }

    public Format(String string) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.filename = string;
        if (string == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File not specified");
            }
            return;
        }
        try {
            this.file_ = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.Format() File " + string + " not found", (Throwable)fileNotFoundException);
            }
            return;
        }
    }

    public Format(IFSFileInputStream iFSFileInputStream) {
        this.sys = null;
        this.createdSys = false;
        this.file_ = null;
        this.progress = null;
        this.data = null;
        this.pro_ = null;
        this.filename = null;
        this.outfilePath_ = null;
        this.ifsrecs = 0;
        this.tcprecs = 0;
        this.numrecs = 0;
        this.file_ = iFSFileInputStream;
        this.formatProlog();
    }

    private void setUpFilters() {
        block6: {
            if (this.filter_ == null) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.setUpFilters() Filters are not initialized");
                }
                return;
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyyyykkmmssSSS");
                String string = this.filter_.getStartTime();
                String string2 = this.filter_.getEndTime();
                if (string != null) {
                    this.filter_.setStartTime(Long.toString(simpleDateFormat.parse(string).getTime()));
                }
                if (string2 != null) {
                    this.filter_.setEndTime(Long.toString(simpleDateFormat.parse(string2).getTime()));
                }
            }
            catch (ParseException parseException) {
                if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block6;
                Trace.log(2, "Format.setUpFilters() Invalid Time argument", (Throwable)parseException);
            }
        }
    }

    public void setFilterProperties(FormatProperties formatProperties) {
        this.filter_ = formatProperties;
    }

    public void setOutFile(String string) {
        this.outfilePath_ = string;
    }

    public void setInFileStream(InputStream inputStream) {
        this.file_ = inputStream;
    }

    public void setSystem(AS400 aS400) {
        this.sys = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int toIFSTxtFile() {
        block33: {
            if (this.sys == null) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSTxtFile() Error the system wasn't specified");
                }
                return 1;
            }
            if (this.outfilePath_ == null) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSTxtFile() Error the out file wasn't specified");
                }
                return 1;
            }
            IFSFileOutputStream iFSFileOutputStream = null;
            try {
                try {
                    iFSFileOutputStream = new IFSTextFileOutputStream(this.sys, this.outfilePath_);
                }
                catch (IOException iOException) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSTxtFile() Error opening " + this.outfilePath_, (Throwable)iOException);
                    }
                    int n = 1;
                    if (iFSFileOutputStream != null) {
                        try {
                            iFSFileOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            Trace.log(2, iOException2);
                        }
                    }
                    return n;
                }
                catch (AS400SecurityException aS400SecurityException) {
                    int n;
                    block32: {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSTxtFile() Security exception opening file", (Throwable)aS400SecurityException);
                        }
                        n = 1;
                        if (iFSFileOutputStream == null) break block32;
                        try {
                            iFSFileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            Trace.log(2, iOException);
                        }
                    }
                    return n;
                }
                int n = 0;
                try {
                    Frame frame;
                    ((IFSTextFileOutputStream)iFSFileOutputStream).write(this.pro_.toString());
                    while ((frame = this.getNextRecord()) != null) {
                        if (n % 5 == 0) {
                            ((IFSTextFileOutputStream)iFSFileOutputStream).write(this.addBanner());
                        }
                        ((IFSTextFileOutputStream)iFSFileOutputStream).write(frame.toString());
                        ++n;
                    }
                    ((IFSTextFileOutputStream)iFSFileOutputStream).write(this.addEndBanner());
                    break block33;
                }
                catch (IOException iOException) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSTxtFile() Error writing to " + this.filename, (Throwable)iOException);
                    }
                    int n2 = 1;
                    if (iFSFileOutputStream != null) {
                        try {
                            iFSFileOutputStream.close();
                        }
                        catch (IOException iOException3) {
                            Trace.log(2, iOException3);
                        }
                    }
                    return n2;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (iFSFileOutputStream != null) {
                    try {
                        iFSFileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        Trace.log(2, iOException);
                    }
                }
            }
        }
        return 0;
    }

    public int toLclTxtFile() {
        BufferedWriter bufferedWriter;
        if (this.outfilePath_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error the out file wasn't specified");
            }
            return 1;
        }
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.outfilePath_));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error opening " + this.outfilePath_, (Throwable)iOException);
            }
            return 1;
        }
        int n = 0;
        try {
            Frame frame;
            bufferedWriter.write(this.pro_.toString());
            while ((frame = this.getNextRecord()) != null) {
                if (n % 5 == 0) {
                    bufferedWriter.write(this.addBanner());
                }
                bufferedWriter.write(frame.toString());
                ++n;
            }
            bufferedWriter.write(this.addEndBanner());
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error writing to " + this.filename, (Throwable)iOException);
            }
            return 1;
        }
        try {
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclTxtFile() Error closing " + this.filename, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int toIFSBinFile() {
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Error the prolog wasn't formatted");
            }
            return 1;
        }
        if (this.pro_.invalidData()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toIFSBinFile() Not a valid IBM i CommTrace");
            }
            return 1;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new IFSFileOutputStream(this.sys, this.outfilePath_));
            }
            catch (IOException iOException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSBinFile() Error opening " + this.outfilePath_, (Throwable)iOException);
                }
                int n = 1;
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException2) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException2);
                        }
                        return 1;
                    }
                }
                return n;
            }
            catch (AS400SecurityException aS400SecurityException) {
                int n;
                block41: {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSBinFile() Security exception opening file " + this.outfilePath_, (Throwable)aS400SecurityException);
                    }
                    n = 1;
                    if (objectOutputStream == null) break block41;
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException);
                        }
                        return 1;
                    }
                }
                return n;
            }
            try {
                objectOutputStream.writeUTF(this.pro_.toString());
                objectOutputStream.writeInt(this.ifsrecs);
                Frame frame = null;
                while ((frame = this.getNextRecord()) != null) {
                    String string = frame.toString(this.filter_);
                    if (string.length() == 0) continue;
                    objectOutputStream.writeUTF(string);
                }
                objectOutputStream.writeUTF(this.addEndBanner());
            }
            catch (NotSerializableException notSerializableException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toIFSBinFile() Error object not serializable " + this.outfilePath_, (Throwable)notSerializableException);
                }
                int n = 1;
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException);
                        }
                        return 1;
                    }
                }
                return n;
            }
            catch (IOException iOException) {
                int n;
                block43: {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSBinFile() Error writing file " + this.outfilePath_, (Throwable)iOException);
                    }
                    n = 1;
                    if (objectOutputStream == null) break block43;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException3) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException3);
                        }
                        return 1;
                    }
                }
                return n;
            }
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toIFSBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException);
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toLclBinFile() {
        Object object;
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Error the prolog wasn't formatted");
            }
            return 1;
        }
        if (this.pro_.invalidData()) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.toLclBinFile() Not a valid IBM i CommTrace");
            }
            return 1;
        }
        String string = this.filter_.getProgress();
        if (string != null && string.equals("True")) {
            this.progress = new Progress("Formating " + this.filename, this.ifsrecs, " records");
            object = new Thread((Runnable)this.progress, "ProgDiag");
            this.progress.setThread((Thread)object);
            ((Thread)object).start();
        }
        object = null;
        try {
            try {
                object = new ObjectOutputStream(new FileOutputStream(this.outfilePath_));
            }
            catch (IOException iOException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toLclBinFile() Error opening " + this.outfilePath_, (Throwable)iOException);
                }
                int n = 1;
                if (object != null) {
                    try {
                        ((ObjectOutputStream)object).close();
                    }
                    catch (IOException iOException2) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException2);
                        }
                        return 1;
                    }
                }
                return n;
            }
            try {
                ((ObjectOutputStream)object).writeUTF(this.pro_.toString());
                ((ObjectOutputStream)object).writeInt(this.ifsrecs);
                Frame frame = null;
                if (this.progress == null) {
                    while ((frame = this.getNextRecord()) != null) {
                        String string2 = frame.toString(this.filter_);
                        if (string2.length() == 0) continue;
                        ((ObjectOutputStream)object).writeUTF(string2);
                    }
                } else {
                    while ((frame = this.getNextRecord()) != null && !this.progress.isCanceled()) {
                        String string3 = frame.toString(this.filter_);
                        if (string3.length() == 0) continue;
                        ((ObjectOutputStream)object).writeUTF(string3);
                    }
                }
                ((ObjectOutputStream)object).writeUTF(this.addEndBanner());
            }
            catch (NotSerializableException notSerializableException) {
                if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                    Trace.log(2, "Format.toLclBinFile() Error object not serializable " + this.outfilePath_, (Throwable)notSerializableException);
                }
                int n = 1;
                if (object != null) {
                    try {
                        ((ObjectOutputStream)object).close();
                    }
                    catch (IOException iOException) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException);
                        }
                        return 1;
                    }
                }
                return n;
            }
            catch (IOException iOException) {
                int n;
                block40: {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toLclBinFile() Error writing file " + this.outfilePath_, (Throwable)iOException);
                    }
                    n = 1;
                    if (object == null) break block40;
                    try {
                        ((ObjectOutputStream)object).close();
                    }
                    catch (IOException iOException3) {
                        if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                            Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException3);
                        }
                        return 1;
                    }
                }
                return n;
            }
        }
        finally {
            if (object != null) {
                try {
                    ((ObjectOutputStream)object).close();
                }
                catch (IOException iOException) {
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "Format.toLclBinFile() Error closing file " + this.outfilePath_, (Throwable)iOException);
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    public int openIFSFile() {
        return this.openIFSFile(this.outfilePath_);
    }

    public int openIFSFile(String string) {
        this.outfilePath_ = string;
        if (this.outfilePath_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Outfile not specified");
            }
            return 1;
        }
        try {
            this.serin_ = new ObjectInputStream(new IFSFileInputStream(this.sys, this.outfilePath_));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Error opening " + this.outfilePath_, (Throwable)iOException);
            }
            return 1;
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openIFSFile()Security exception opening file " + this.outfilePath_, (Throwable)aS400SecurityException);
            }
            return 1;
        }
        return 0;
    }

    public int openLclFile() {
        return this.openLclFile(this.outfilePath_);
    }

    public int openLclFile(String string) {
        this.outfilePath_ = string;
        if (this.outfilePath_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openLclFile() Outfile not specified");
            }
            return 1;
        }
        try {
            this.serin_ = new ObjectInputStream(new FileInputStream(this.outfilePath_));
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.openLclFile() Error opening " + this.outfilePath_, (Throwable)iOException);
            }
            return 1;
        }
        return 0;
    }

    public int close() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Format.close()");
        }
        int n = 0;
        try {
            if (this.file_ != null) {
                this.file_.close();
            }
        }
        catch (Throwable throwable) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.close() Error closing " + this.filename, throwable);
            }
            return 1;
        }
        try {
            if (this.serin_ != null) {
                this.serin_.close();
            }
            if (this.sys != null && this.createdSys) {
                this.sys.disconnectAllServices();
            }
        }
        catch (Throwable throwable) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.close() Error closing " + this.outfilePath_, throwable);
            }
            return 1;
        }
        if (this.progress != null) {
            this.progress.setThread(null);
        }
        return n;
    }

    public String getRecFromFile() {
        String string = null;
        try {
            string = this.serin_.readUTF();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getRecFromFile() Error reading file", (Throwable)iOException);
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getRecFromFile() Error file not opened ", (Throwable)nullPointerException);
            }
            return null;
        }
        return string;
    }

    public int getIntFromFile() {
        int n = 0;
        try {
            n = this.serin_.readInt();
        }
        catch (IOException iOException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getIntFromFile() Error reading file", (Throwable)iOException);
            }
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getIntFromFile() Error file not opened", (Throwable)nullPointerException);
            }
            return -1;
        }
        return n;
    }

    public boolean formatProlog() {
        if (this.file_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.formatProlog() Input file not opened");
            }
            return false;
        }
        this.read(0, 258);
        BitBuf bitBuf = new BitBuf(this.data);
        this.nxtRecLen = new BitBuf(bitBuf, 2048, 16);
        this.pro_ = new Prolog(bitBuf, this.filter_);
        this.ifsrecs = this.pro_.getNumRecs();
        return this.pro_.invalidData();
    }

    public Frame getNextRecord() {
        if (this.pro_ == null) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Format.getNextRecord() Prolog not formatted.");
            }
            return null;
        }
        if (!this.pro_.invalidData()) {
            Frame frame = this.getNext();
            while (frame != null) {
                if (!frame.isTCP()) {
                    frame = this.getNext();
                    continue;
                }
                ++this.tcprecs;
                return frame;
            }
            return frame;
        }
        return null;
    }

    private Frame getNext() {
        int n = 0;
        if (this.progress != null) {
            this.progress.updateProgress(this.numrecs);
        }
        if (this.numrecs < this.ifsrecs) {
            BitBuf bitBuf;
            ++this.numrecs;
            if (this.numrecs == this.ifsrecs) {
                this.read(0, this.nxtRecLen.toInt());
                bitBuf = new BitBuf(this.data);
                n = (this.nxtRecLen.toInt() - 2) * 8;
            } else {
                this.read(0, this.nxtRecLen.toInt());
                bitBuf = new BitBuf(this.data);
                n = this.nxtRecLen.toInt() * 8 - 16;
                this.nxtRecLen = new BitBuf(bitBuf, n, 16);
            }
            return new Frame(this.pro_, bitBuf.slice(0, n));
        }
        return null;
    }

    private void read(int n, int n2) {
        int n3;
        block3: {
            this.data = new byte[n + n2];
            n3 = 0;
            try {
                n3 = this.file_.read(this.data, n, n2);
            }
            catch (IOException iOException) {
                if (!Trace.isTraceOn() || !Trace.isTraceErrorOn()) break block3;
                Trace.log(2, "Format.read() Error reading file", (Throwable)iOException);
            }
        }
        if (n3 != n2 && Trace.isTraceOn() && Trace.isTraceErrorOn()) {
            Trace.log(2, "Format.read() Incorrect number of bytes read: Requested " + n2 + ", got " + n3);
        }
    }

    public String addBanner() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ResourceBundleLoader_ct.getText("Record");
        String string2 = ResourceBundleLoader_ct.getText("MACAddress");
        stringBuffer.append(this.pro_.getTitle());
        stringBuffer.append(this.pro_.getDate());
        stringBuffer.append(string);
        stringBuffer.append("       ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Data"));
        stringBuffer.append("      ");
        stringBuffer.append(string);
        stringBuffer.append("                     ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Destination"));
        stringBuffer.append("     ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Source"));
        stringBuffer.append("           ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Frame"));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Number"));
        stringBuffer.append("  ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("S/R"));
        stringBuffer.append("  ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Length"));
        stringBuffer.append("    ");
        stringBuffer.append(ResourceBundleLoader_ct.getText("Timer"));
        stringBuffer.append("                      ");
        stringBuffer.append(string2);
        stringBuffer.append("     ");
        stringBuffer.append(string2);
        stringBuffer.append("      ");
        stringBuffer.append(ResourceBundleLoader_ct.getText(CLASS));
        stringBuffer.append("\n");
        stringBuffer.append("------  ---  ------    ------------               --------------  --------------   ------");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String addEndBanner() {
        return "\n* * * * * * * * * * * * *    " + ResourceBundleLoader_ct.getText("EOCP") + "    * * * * * * * * * * * * *\n";
    }

    public int getRecsProcessed() {
        return this.numrecs;
    }

    public Prolog getProlog() {
        return this.pro_;
    }

    public int getNumberOfTCPRecords() {
        return this.tcprecs;
    }

    public static void main(String[] stringArray) {
        Format format = new Format(stringArray);
        format.toIFSBinFile();
    }
}

