/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.FragmentFlag;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.IP4Address;

public class IP4Header
extends Header {
    private static final String CLASS = "IP4Header";
    Field version;
    Field internetheaderl;
    Field typeofservice;
    Field dscp;
    Field ecn;
    Field totallength;
    Field identification;
    Field flag;
    Field flag2;
    Field fragmentoffset;
    Field timetolive;
    Field protocol;
    Field headerchecksum;
    Field src;
    Field dst;
    Field options;
    private static final String RES = "RESERVED";
    private static final String ICMP = "ICMP";
    private static final String IGMP = "IGMP";
    private static final String TCP = "TCP";
    private static final String UDP = "UDP";
    private static final String IPV6 = "IPv6";
    private static final String UNK = "Unknown";
    private static final String MAY = "MAY";
    private static final String DONT = "DON'T";
    private static final String LAST = ",LAST";
    private static final String MORE = ",MORE";
    private static final String NONE = "NONE";
    private static final String NECT = "00 - NECT";
    private static final String ECT1 = "01 - ECT1";
    private static final String ECT0 = "10 - ECT0";
    private static final String CE = "11 - CE";
    private static final String FRM = "Frame Type";
    private static final String IP = "IP";
    private static final String DSCP = "DSCP";
    private static final String ECN = "ECN";
    private static final String LEN = "Length";
    private static final String PROT = "Protocol";
    private static final String DGID = "DataGram ID";
    private static final String SRC = "Src Addr";
    private static final String DST = "Dest Addr";
    private static final String FRAGFLAG = "Fragment Flags";
    private static final String IPOPT = "IP Options";

    IP4Header(BitBuf bitBuf) {
        super(bitBuf);
        this.version = new Dec(this.rawheader.slice(0, 4));
        this.internetheaderl = new Dec(this.rawheader.slice(4, 4));
        this.typeofservice = new Hex(this.rawheader.slice(8, 8));
        this.dscp = new Dec(this.rawheader.slice(8, 6));
        this.ecn = new Dec(this.rawheader.slice(14, 2));
        this.totallength = new Dec(this.rawheader.slice(16, 16));
        this.identification = new Hex(this.rawheader.slice(32, 16));
        this.flag = new FragmentFlag(this.rawheader.slice(48, 2));
        this.flag2 = new FragmentFlag(this.rawheader.slice(50, 4));
        this.fragmentoffset = new Dec(this.rawheader.slice(52, 12));
        this.timetolive = new Dec(this.rawheader.slice(64, 8));
        this.protocol = new Dec(this.rawheader.slice(72, 8));
        this.headerchecksum = new Dec(this.rawheader.slice(80, 16));
        this.src = new IP4Address(this.rawheader.slice(96, 32));
        this.dst = new IP4Address(this.rawheader.slice(128, 32));
        this.options = new Hex(this.rawheader.slice(160, Integer.parseInt(this.internetheaderl.toString()) * 8 - 40));
        this.type = 23;
    }

    @Override
    public int getHeaderLen() {
        if (this.internetheaderl == null) {
            this.internetheaderl = new Dec(this.rawheader.slice(4, 4));
        }
        return Integer.parseInt(this.internetheaderl.toString()) * 32;
    }

    @Override
    public Header getNextHeader() {
        return Header.createHeader(this.rawheader.slice(72, 8).toByte(), this.rawpayload);
    }

    @Override
    public String toString(FormatProperties formatProperties) {
        Object[] objectArray;
        Object object;
        String string = this.protocol.toString();
        Object object2 = "";
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (formatProperties != null) {
            boolean bl = false;
            object = formatProperties.getIPAddress();
            objectArray = formatProperties.getSecondIPAddress();
            if (object == null && objectArray == null) {
                bl = true;
            } else if (object == null) {
                if (this.src.toString().equals(objectArray) || this.dst.toString().equals(objectArray)) {
                    bl = true;
                }
            } else if (((String)object).indexOf(58) != -1) {
                bl = true;
            } else if (objectArray == null) {
                if (this.src.toString().equals(object) || this.dst.toString().equals(object)) {
                    bl = true;
                }
            } else if ((this.src.toString().equals(object) || this.src.toString().equals(objectArray)) && (this.dst.toString().equals(object) || this.dst.toString().equals(objectArray))) {
                bl = true;
            }
            if (!bl) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "IP4Header.toString() Frame doesn't pass IP filter");
                }
                return "";
            }
        }
        char[] cArray = this.flag.toString().toCharArray();
        object = this.flag2.toString().toCharArray();
        string = string.equals("0") ? RES : (string.equals("1") ? ICMP : (string.equals("2") ? IGMP : (string.equals("6") ? TCP : (string.equals("17") ? UDP : (string.equals("41") ? IPV6 : (string.equals("01") ? ICMP : (string.equals("255") ? RES : UNK)))))));
        switch (cArray.length) {
            case 1: {
                if (cArray[0] == '0') {
                    object2 = MAY;
                    break;
                }
                object2 = DONT;
                break;
            }
            case 2: {
                if (cArray[0] == '0' && cArray[1] == '0') {
                    object2 = MAY;
                    break;
                }
                object2 = DONT;
                break;
            }
        }
        switch (((Object)object).length) {
            case 1: {
                if (object[0] == 48) {
                    object2 = (String)object2 + LAST;
                    break;
                }
                object2 = (String)object2 + MORE;
                break;
            }
            case 2: {
                if (object[0] == 48 && object[1] == 48) {
                    object2 = (String)object2 + LAST;
                    break;
                }
                object2 = (String)object2 + MORE;
                break;
            }
        }
        objectArray = new Object[]{this.totallength, this.identification, object2, string, this.src, this.dst, this.options, this.dscp, this.ecn};
        if (this.options.toString().equals("0x")) {
            objectArray[6] = NONE;
        }
        if (Integer.parseInt(this.dscp.toString()) == 0) {
            objectArray[7] = "0";
        }
        switch (Integer.parseInt(this.ecn.toString())) {
            case 0: {
                objectArray[8] = NECT;
                break;
            }
            case 1: {
                objectArray[8] = ECT1;
                break;
            }
            case 2: {
                objectArray[8] = ECT0;
                break;
            }
            case 3: {
                objectArray[8] = CE;
            }
        }
        String string2 = this.printnext(formatProperties);
        if (string2 == "") {
            return "";
        }
        return Formatter.jsprintf("\t    Frame Type   :  IP \t\tDSCP: {7,2,L}  ECN: {8,10,L}    Length:  {0,4,L}   Protocol:  {3,10,L}   DataGram ID:  {1,6,L}\n\t\t\t    Src Addr:  {4,15,L}    Dest Addr:  {5,15,L}       Fragment Flags:  {2,10,L}\n\t    IP Options   :  {6,80,L}\n", objectArray) + this.printHexHeader() + string2;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getInternetHeaderLength() {
        return this.internetheaderl.toString();
    }

    public String getTypeOfService() {
        return this.typeofservice.toString();
    }

    public String getDscp() {
        return this.dscp.toString();
    }

    public String getEcn() {
        return this.ecn.toString();
    }

    public String getTotalLength() {
        return this.totallength.toString();
    }

    public String getIdentification() {
        return this.identification.toString();
    }

    public String getFlag() {
        return this.flag.toString();
    }

    public String getFlag2() {
        return this.flag2.toString();
    }

    public String getFragmentOffset() {
        return this.fragmentoffset.toString();
    }

    public String getTimeToLive() {
        return this.timetolive.toString();
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public String getHeaderChecksum() {
        return this.headerchecksum.toString();
    }

    public String getSrcAddr() {
        return this.src.toString();
    }

    public String getDstAddr() {
        return this.dst.toString();
    }

    public String getOptions() {
        return new Dec(this.options.getData()).toString();
    }
}

