/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.Flag;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.IP6Address;
import com.ibm.as400.util.commtrace.NDOption;

public class PrefixInfo
extends NDOption {
    private Field prefixlen;
    private Field l;
    private Field a;
    private Field validlifetime;
    private Field preferredlifetime;
    private Field prefix;

    PrefixInfo(BitBuf bitBuf) {
        super(bitBuf);
        this.prefixlen = new Dec(this.rawheader.slice(16, 8));
        this.l = new Flag(this.rawheader.slice(24, 1));
        this.a = new Flag(this.rawheader.slice(25, 1));
        this.validlifetime = new Dec(this.rawheader.slice(64, 32));
        this.preferredlifetime = new Dec(this.rawheader.slice(96, 32));
        this.prefix = new IP6Address(this.rawheader.slice(128, 128));
        this.type = 3;
    }

    @Override
    public String toString(FormatProperties formatProperties) {
        Object[] objectArray = new Object[]{this.ndtype, this.length, this.prefixlen, this.l, this.a, this.validlifetime, this.preferredlifetime, this.prefix};
        return Formatter.jsprintf("\t    Option Data:   Type: {0,3,R}       Length: {1,3,R}\n\t\t\t\t      PrefixLen: {2,3,R}  L: {3}  A: {4}     ValidLifeTime: {5,10,R}     PreferredTime: {6,10,R}\t\t\t\t      Prefix: {7}\n", objectArray) + this.printHexHeader() + this.printnext(formatProperties);
    }

    public String getPrefixLength() {
        return this.prefixlen.toString();
    }

    public String getLFlag() {
        return this.l.toString();
    }

    public String getAFlag() {
        return this.a.toString();
    }

    public String getValidLifeTime() {
        return this.validlifetime.toString();
    }

    public String getPreferredLifeTime() {
        return this.preferredlifetime.toString();
    }

    public String getPrefix() {
        return this.prefix.toString();
    }
}

