/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.IP6Address;
import com.ibm.as400.util.commtrace.Message;
import com.ibm.as400.util.commtrace.NDOption;

public class Redirect
extends Message {
    private Field target;
    private Field destination;

    @Override
    public Header getNextHeader() {
        return NDOption.createNDOption(this.rawpayload);
    }

    Redirect(BitBuf bitBuf) {
        super(bitBuf);
        this.target = new IP6Address(this.rawheader.slice(32, 128));
        this.destination = new IP6Address(this.rawheader.slice(160, 128));
        this.type = 137;
    }

    @Override
    public int getHeaderLen() {
        return 288;
    }

    @Override
    public String toString(FormatProperties formatProperties) {
        Object[] objectArray = new Object[]{this.target, this.destination};
        return Formatter.jsprintf("Target:  {0}\n\tDestination: {1}\n", objectArray) + this.printHexHeader() + this.printnext(formatProperties);
    }

    public String getTarget() {
        return this.target.toString();
    }

    public String getDestination() {
        return this.destination.toString();
    }
}

