/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.Flag;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.Port;

public class TCPHeader
extends Header {
    private Field sourceport;
    private Field destport;
    private Field sequence;
    private Field sequencehex;
    private Field acknum;
    private Field acknumhex;
    private Field dataoffset;
    private Field cwr;
    private Field ece;
    private Field urg;
    private Field ack;
    private Field psh;
    private Field rst;
    private Field syn;
    private Field fin;
    private Field window;
    private Field checksum;
    private Field urgentptr;
    private Field options;
    private Field option;
    private Field msssize;
    private Field segmentsize;
    private static final String CLASS = "TCPHeader";
    private static final String CWR = "CWR ";
    private static final String ECE = "ECE ";
    private static final String URG = "URG ";
    private static final String ACK = "ACK ";
    private static final String PSH = "PSH ";
    private static final String RST = "RST ";
    private static final String SYN = "SYN ";
    private static final String FIN = "FIN ";
    private static final String UNASSIGNED = "Unassigned";
    private static final String MSS = "MSS=";
    private static final String NOOP = "NO OP";
    private static final String ENDOP = "END OP";
    private static final String BADOP = "BAD OP";
    private static final String NONE = "NONE";
    private static final String TCPSTR = "TCP";
    private static final String SRC = "SrcPort";
    private static final String DST = "DstPort";
    private static final String SEQ = "SeqNum";
    private static final String ACKNUM = "AckNum";
    private static final String FLAGS = "Flags";
    private static final String DATAOFF = "DataOffset";
    private static final String CHKSUM = "Checksum";
    private static final String WINSIZE = "Window Size";
    private static final String TCPOPT = "TCP Options";

    TCPHeader(BitBuf bitBuf) {
        super(bitBuf);
        this.sourceport = new Dec(this.rawheader.slice(0, 16));
        this.destport = new Dec(this.rawheader.slice(16, 16));
        this.sequence = new Dec(this.rawheader.slice(32, 32));
        this.sequencehex = new Hex(this.rawheader.slice(32, 32));
        this.acknum = new Dec(this.rawheader.slice(64, 32));
        this.acknumhex = new Hex(this.rawheader.slice(64, 32));
        this.dataoffset = new Dec(this.rawheader.slice(96, 4));
        this.cwr = new Flag(this.rawheader.slice(104, 1), CWR, "");
        this.ece = new Flag(this.rawheader.slice(105, 1), ECE, "");
        this.urg = new Flag(this.rawheader.slice(106, 1), URG, "");
        this.ack = new Flag(this.rawheader.slice(107, 1), ACK, "");
        this.psh = new Flag(this.rawheader.slice(108, 1), PSH, "");
        this.rst = new Flag(this.rawheader.slice(109, 1), RST, "");
        this.syn = new Flag(this.rawheader.slice(110, 1), SYN, "");
        this.fin = new Flag(this.rawheader.slice(111, 1), FIN, "");
        this.window = new Dec(this.rawheader.slice(112, 16));
        this.checksum = new Hex(this.rawheader.slice(128, 16));
        this.urgentptr = new Dec(this.rawheader.slice(144, 16));
        this.options = new Hex(this.rawheader.slice(160, Integer.parseInt(this.dataoffset.toString()) * 8 - 40));
        this.option = new Dec(this.rawheader.slice(160, 8));
        this.msssize = new Dec(this.rawheader.slice(168, 8));
        this.segmentsize = new Dec(this.rawheader.slice(176, Integer.parseInt(this.msssize.toString()) * 8 / 2));
        this.type = 6;
    }

    @Override
    public int getHeaderLen() {
        return this.rawheader.slice(96, 4).toInt() * 32;
    }

    @Override
    public String toString(FormatProperties formatProperties) {
        Object object;
        String string = (String)Port.get(this.sourceport.toString());
        String string2 = (String)Port.get(this.destport.toString());
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (formatProperties != null) {
            boolean bl = false;
            object = formatProperties.getPort();
            if (object == null) {
                bl = true;
            } else if (((String)object).equals(this.sourceport.toString()) || ((String)object).equals(this.destport.toString())) {
                bl = true;
            }
            if (!bl) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "TCPHeader.toString()Not printing record");
                }
                return "";
            }
        }
        if (string == null) {
            string = UNASSIGNED;
        }
        if (string2 == null) {
            string2 = UNASSIGNED;
        }
        String string3 = this.sourceport.toString() + ", " + string;
        object = this.destport.toString() + ", " + string2;
        Object[] objectArray = new Object[]{string3, object, this.acknum, this.acknumhex, this.sequence, this.sequencehex, this.dataoffset, this.cwr, this.ece, this.urg, this.ack, this.psh, this.rst, this.syn, this.fin, this.window, this.checksum, this.options, this.segmentsize};
        if (Integer.parseInt(this.dataoffset.toString()) > 5) {
            switch (Integer.parseInt(this.option.toString())) {
                case 2: {
                    objectArray[17] = MSS;
                    break;
                }
                case 1: {
                    objectArray[18] = "";
                    objectArray[17] = NOOP;
                    break;
                }
                case 0: {
                    objectArray[18] = "";
                    objectArray[17] = ENDOP;
                    break;
                }
                default: {
                    objectArray[18] = "";
                    objectArray[17] = BADOP;
                    break;
                }
            }
        } else {
            objectArray[18] = "";
            objectArray[17] = NONE;
        }
        return Formatter.jsprintf("\t    TCP  . . . . :  SrcPort:  {0,18,L} DstPort:  {1,18,L}\n\t\t\t    SeqNum:  {4,10,L} AckNum:  {2,10,L} {3,10,L} {5,10,L} Flags:  {7}{8}{9}{10}{11}{12}{13}{14}\n\t\t\t    DataOffset:  {7,2,L} Checksum:  {16} Window Size:  {15,5,L} TCP Options:  {17,5,L}  {18,6,L}\n", objectArray) + this.printHexHeader() + this.printnext(formatProperties) + new Data(this.rawpayload).toString();
    }

    public String getSrcPort() {
        return this.sourceport.toString();
    }

    public String getDstPort() {
        return this.destport.toString();
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public String getAckNum() {
        return this.acknum.toString();
    }

    public String getDataOffset() {
        return this.dataoffset.toString();
    }

    public String getCWRFlag() {
        return this.cwr.toString();
    }

    public String getECEFlag() {
        return this.ece.toString();
    }

    public String getURGFlag() {
        return this.urg.toString();
    }

    public String getACKFlag() {
        return this.ack.toString();
    }

    public String getPSHFlag() {
        return this.psh.toString();
    }

    public String getRSTFlag() {
        return this.rst.toString();
    }

    public String getSYNFlag() {
        return this.syn.toString();
    }

    public String getFINFlag() {
        return this.fin.toString();
    }

    public String getWindow() {
        return this.window.toString();
    }

    public String getCheckSum() {
        return new Dec(this.checksum.getData()).toString();
    }

    public String getUrgentPointer() {
        return this.urgentptr.toString();
    }

    public String getOptions() {
        return new Dec(this.options.getData()).toString();
    }

    public String getOption() {
        return this.options.toString();
    }

    public String getMaximumSegmentSize() {
        return this.msssize.toString();
    }

    public String getSegmentSize() {
        return this.segmentsize.toString();
    }
}

