/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mavensar;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class SarMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper helper;
    private MavenArchiveConfiguration archiveConfig = new MavenArchiveConfiguration();
    private JarArchiver jarArchiver;
    private File targetDir;
    private File classesDir;
    private String targetFile;
    private String classifier;
    private static final String[] EXCLUDES = new String[]{"**/*.html"};
    private static final String[] INCLUDES = new String[]{"**/*.xml", "**/*.class"};

    public final void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"====== MAVEN-SAR-PLUGIN ======");
        this.getLog().info((CharSequence)("targetDir  [" + this.targetDir + "]"));
        this.getLog().info((CharSequence)("targetFile [" + this.targetFile + ".sar]"));
        this.getLog().info((CharSequence)("classesDir [" + this.classesDir.toString() + "]"));
        File sar = new File(this.targetDir, this.targetFile + ".sar");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(sar);
        try {
            File jbossServiceXml = new File(this.classesDir.toString() + "/META-INF/jboss-service.xml");
            if (!jbossServiceXml.exists()) {
                String msg = this.classesDir.toString() + "/META-INF/jboss-service.xml was not found.";
                throw new MojoExecutionException(msg);
            }
            archiver.getArchiver().addDirectory(this.classesDir, INCLUDES, EXCLUDES);
            archiver.createArchive(this.project, this.archiveConfig);
            if (this.classifier == null) {
                this.project.getArtifact().setFile(sar);
            } else {
                this.helper.attachArtifact(this.project, "sar", this.classifier, sar);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packaging SAR", e);
        }
        this.getLog().info((CharSequence)"====== MAVEN-SAR-PLUGIN ======");
    }
}

