/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassSubHierarchyInitializer
implements ClassVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        this.addSubclass(programClass, programClass.getSuperClass());
        for (int index = 0; index < programClass.u2interfacesCount; ++index) {
            this.addSubclass(programClass, programClass.getInterface(index));
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.addSubclass(libraryClass, libraryClass.superClass);
        Clazz[] interfaceClasses = libraryClass.interfaceClasses;
        if (interfaceClasses != null) {
            for (int index = 0; index < interfaceClasses.length; ++index) {
                this.addSubclass(libraryClass, interfaceClasses[index]);
            }
        }
    }

    private void addSubclass(Clazz subclass, Clazz clazz) {
        if (clazz != null) {
            clazz.addSubClass(subclass);
        }
    }
}

