/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.UnknownDoubleValue;
import proguard.evaluation.value.UnknownFloatValue;
import proguard.evaluation.value.UnknownIntegerValue;
import proguard.evaluation.value.UnknownLongValue;
import proguard.evaluation.value.Value;

public class ValueFactory {
    static final IntegerValue INTEGER_VALUE = new UnknownIntegerValue();
    static final LongValue LONG_VALUE = new UnknownLongValue();
    static final FloatValue FLOAT_VALUE = new UnknownFloatValue();
    static final DoubleValue DOUBLE_VALUE = new UnknownDoubleValue();
    static final ReferenceValue REFERENCE_VALUE_NULL = new TypedReferenceValue(null, null, true);
    static final ReferenceValue REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL = new TypedReferenceValue("java/lang/Object", null, true);
    static final ReferenceValue REFERENCE_VALUE_JAVA_LANG_OBJECT_NOT_NULL = new TypedReferenceValue("java/lang/Object", null, false);

    public Value createValue(String type, Clazz referencedClass, boolean mayBeNull) {
        switch (type.charAt(0)) {
            case 'V': {
                return null;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.createIntegerValue();
            }
            case 'J': {
                return this.createLongValue();
            }
            case 'F': {
                return this.createFloatValue();
            }
            case 'D': {
                return this.createDoubleValue();
            }
        }
        return this.createReferenceValue(ClassUtil.isInternalArrayType(type) ? type : ClassUtil.internalClassNameFromClassType(type), referencedClass, mayBeNull);
    }

    public IntegerValue createIntegerValue() {
        return INTEGER_VALUE;
    }

    public IntegerValue createIntegerValue(int value) {
        return this.createIntegerValue();
    }

    public LongValue createLongValue() {
        return LONG_VALUE;
    }

    public LongValue createLongValue(long value) {
        return this.createLongValue();
    }

    public FloatValue createFloatValue() {
        return FLOAT_VALUE;
    }

    public FloatValue createFloatValue(float value) {
        return this.createFloatValue();
    }

    public DoubleValue createDoubleValue() {
        return DOUBLE_VALUE;
    }

    public DoubleValue createDoubleValue(double value) {
        return this.createDoubleValue();
    }

    public ReferenceValue createReferenceValueNull() {
        return REFERENCE_VALUE_NULL;
    }

    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeNull) {
        return type == null ? REFERENCE_VALUE_NULL : (!type.equals("java/lang/Object") ? new TypedReferenceValue(type, referencedClass, mayBeNull) : (mayBeNull ? REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : REFERENCE_VALUE_JAVA_LANG_OBJECT_NOT_NULL));
    }

    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return this.createReferenceValue('[' + type, referencedClass, false);
    }
}

