/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;

public class ContextItemExpression
extends Expression {
    ContextItemStaticInfo staticInfo = ContextItemStaticInfo.DEFAULT;

    public String getExpressionName() {
        return "contextItem";
    }

    public Expression copy() {
        ContextItemExpression cie2 = new ContextItemExpression();
        cie2.staticInfo = this.staticInfo;
        ExpressionTool.copyLocationInfo(this, cie2);
        return cie2;
    }

    protected String getErrorCodeForUndefinedContext() {
        return "XPDY0002";
    }

    public void setStaticInfo(ContextItemStaticInfo info) {
        this.staticInfo = info;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (contextInfo.getItemType() == ErrorType.getInstance()) {
            visitor.issueWarning("Evaluation will always fail: there is no context item", this.getLocation());
            ErrorExpression ee = new ErrorExpression("There is no context item", this.getErrorCodeForUndefinedContext(), true);
            ExpressionTool.copyLocationInfo(this, ee);
            return ee;
        }
        this.staticInfo = contextInfo;
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (contextItemType == null) {
            XPathException err = new XPathException("The context item is undefined at this point");
            err.setErrorCode(this.getErrorCodeForUndefinedContext());
            err.setIsTypeError(true);
            err.setLocation(this.getLocation());
            throw err;
        }
        return this;
    }

    public ItemType getItemType() {
        return this.staticInfo.getItemType();
    }

    public boolean isContextPossiblyUndefined() {
        return this.staticInfo.isPossiblyAbsent();
    }

    public int computeCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000 | 0x10000;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public boolean equals(Object other) {
        return other instanceof ContextItemExpression;
    }

    public int hashCode() {
        return "ContextItemExpression".hashCode();
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
        }
        return pathMapNodeSet;
    }

    public boolean isSubtreeExpression() {
        return true;
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        return AnchorPattern.getInstance();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is absent", this.getErrorCodeForUndefinedContext(), context);
        }
        return SingletonIterator.makeIterator(item);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is absent", this.getErrorCodeForUndefinedContext(), context);
        }
        return item;
    }

    public String toString() {
        return ".";
    }

    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("dot", this);
        ItemType type = this.getItemType();
        if (type != AnyItemType.getInstance()) {
            destination.emitAttribute("type", type.toString());
        }
        if (this.staticInfo.isPossiblyAbsent()) {
            destination.emitAttribute("flags", "a");
        }
        destination.endElement();
    }

    public String toShortString() {
        return ".";
    }
}

