/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class LetExpression
extends Assignation
implements TailCallReturner {
    private int evaluationMode = -1;

    public String getExpressionName() {
        return "let";
    }

    private void recomputeRefCount() {
        if (this.refCount != 10000) {
            this.setRefCount(LetExpression.countReferences(this, this, false));
        }
    }

    private static int countReferences(LetExpression let, Expression child, boolean inLoop) {
        int total = 0;
        for (Operand o : child.operands()) {
            boolean repeated;
            Expression g = o.getChildExpression();
            boolean bl = repeated = inLoop || o.isEvaluatedRepeatedly();
            if (!repeated && !o.hasSameFocus() && ExpressionTool.dependsOnFocus(let.getSequence())) {
                repeated = true;
            }
            total = g instanceof LocalVariableReference && ((LocalVariableReference)g).getBinding() == let ? (total += repeated ? 10 : 1) : (total += LetExpression.countReferences(let, g, repeated));
            if (total < 10) continue;
            break;
        }
        return total;
    }

    public void setRefCount(int refCount) {
        this.refCount = refCount;
    }

    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        if (this.refCount != 10000) {
            this.setRefCount(-1);
        }
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getSequenceOp().typeCheck(visitor, contextInfo);
        RoleDiagnostic role = new RoleDiagnostic(3, this.getVariableQName().getDisplayName(), 0);
        this.setSequence(TypeChecker.strictTypeCheck(this.getSequence(), this.requiredType, role, visitor.getStaticContext()));
        ItemType actualItemType = this.getSequence().getItemType();
        this.refineTypeInformation(actualItemType, this.getSequence().getCardinality(), this.getSequence() instanceof Literal ? ((Literal)this.getSequence()).getValue() : null, this.getSequence().getSpecialProperties(), visitor, this);
        boolean indexed = this.refCount == 10000;
        this.refCount = 0;
        this.getActionOp().typeCheck(visitor, contextInfo);
        if (indexed) {
            this.refCount = 10000;
        }
        return this;
    }

    public boolean implementsStaticTypeCheck() {
        return true;
    }

    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleDiagnostic role, ExpressionVisitor visitor) throws XPathException {
        this.setAction(TypeChecker.staticTypeCheck(this.getAction(), req, backwardsCompatible, role, visitor));
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        boolean done;
        Optimizer opt = this.getConfiguration().obtainOptimizer();
        if (this.getAction() instanceof VariableReference && ((VariableReference)this.getAction()).getBinding() == this && !ExpressionTool.changesXsltContext(this.getSequence())) {
            this.getSequenceOp().optimize(visitor, contextItemType);
            opt.trace("Eliminated trivial variable " + this.getVariableName(), this.getSequence());
            return this.getSequence();
        }
        if (this.getSequence() instanceof DocumentInstr && ((DocumentInstr)this.getSequence()).isTextOnly() && this.allReferencesAreFlattened()) {
            Expression stringValueExpression = ((DocumentInstr)this.getSequence()).getStringValueExpression();
            stringValueExpression = stringValueExpression.typeCheck(visitor, contextItemType);
            this.setSequence(stringValueExpression);
            this.requiredType = SequenceType.SINGLE_UNTYPED_ATOMIC;
            this.adoptChildExpression(this.getSequence());
            this.refineTypeInformation(this.requiredType.getPrimaryType(), this.requiredType.getCardinality(), null, 0, visitor, this);
        }
        if (this.refCount < 2) {
            this.recomputeRefCount();
        }
        if (this.refCount == 0) {
            this.getActionOp().optimize(visitor, contextItemType);
            opt.trace("Eliminated unused variable " + this.getVariableName(), this.getAction());
            return this.getAction();
        }
        if (this.refCount == 1 && ExpressionTool.dependsOnFocus(this.getSequence()) && visitor.isOptimizeForStreaming()) {
            this.refCount = 5;
        }
        if (this.refCount == 1 && ExpressionTool.changesXsltContext(this.getSequence())) {
            this.refCount = 5;
        }
        if ((this.refCount == 1 || this.getSequence() instanceof Literal) && (done = this.replaceVariable(this.getSequence()))) {
            this.recomputeRefCount();
            if (this.refCount == 0) {
                this.getActionOp().typeCheck(visitor, contextItemType);
                this.getActionOp().optimize(visitor, contextItemType);
                opt.trace("Inlined local variable " + this.getVariableName(), this.getAction());
                return this.getAction();
            }
        }
        int tries = 0;
        while (tries++ < 5) {
            Expression seq0 = this.getSequence();
            this.getSequenceOp().optimize(visitor, contextItemType);
            if (seq0 != this.getSequence()) continue;
            break;
        }
        tries = 0;
        while (tries++ < 5) {
            Expression act0 = this.getAction();
            this.getActionOp().optimize(visitor, contextItemType);
            if (act0 == this.getAction()) break;
            if (this.refCount < 2) {
                this.recomputeRefCount();
            }
            if (this.refCount >= 2) continue;
            return this.optimize(visitor, contextItemType);
        }
        if (this.requiresEagerEvaluation(this.getAction())) {
            this.setEvaluationMode(ExpressionTool.eagerEvaluationMode(this.getSequence()));
        } else if (this.isIndexedVariable()) {
            this.setEvaluationMode(3);
        } else {
            this.setEvaluationMode(ExpressionTool.lazyEvaluationMode(this.getSequence()));
        }
        return this;
    }

    private boolean requiresEagerEvaluation(Expression child) {
        if (child instanceof TryCatch) {
            Expression t = ((TryCatch)child).getTryExpr();
            if (ExpressionTool.dependsOnVariable(t, new Binding[]{this})) {
                return true;
            }
            for (TryCatch.CatchClause clause : ((TryCatch)child).getCatchClauses()) {
                Expression c = clause.catchOp.getChildExpression();
                if (!this.requiresEagerEvaluation(c)) continue;
                return true;
            }
            return false;
        }
        if (child instanceof ForEach && ((ForEach)child).getThreads() != null) {
            Expression body = ((ForEach)child).getAction();
            return ExpressionTool.dependsOnVariable(body, new Binding[]{this});
        }
        if (child instanceof ResultDocument && ((ResultDocument)child).isAsynchronous()) {
            Expression body = ((ResultDocument)child).getContentExpression();
            return ExpressionTool.dependsOnVariable(body, new Binding[]{this});
        }
        for (Operand o : child.operands()) {
            if (!this.requiresEagerEvaluation(o.getChildExpression())) continue;
            return true;
        }
        return false;
    }

    public int getCost() {
        return this.getSequence().getCost() + this.getAction().getCost();
    }

    private boolean allReferencesAreFlattened() {
        ArrayList<VariableReference> references = new ArrayList<VariableReference>();
        ExpressionTool.gatherVariableReferences(this.getAction(), this, references);
        for (int i = references.size() - 1; i >= 0; --i) {
            BindingReference bref = (BindingReference)references.get(i);
            if (bref instanceof VariableReference) {
                VariableReference ref = (VariableReference)bref;
                if (ref.isFlattened()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isVacuousExpression() {
        return this.getAction().isVacuousExpression();
    }

    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        this.getAction().checkPermittedContents(parentType, whole);
    }

    public IntegerValue[] getIntegerBounds() {
        return this.getAction().getIntegerBounds();
    }

    public int getImplementationMethod() {
        return this.getAction().getImplementationMethod();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        return let.getAction().iterate(context);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        return let.getAction().iterateEvents(context);
    }

    public Sequence eval(XPathContext context) throws XPathException {
        if (this.evaluationMode == -1) {
            this.setEvaluationMode(ExpressionTool.lazyEvaluationMode(this.getSequence()));
        }
        int savedOutputState = context.getTemporaryOutputState();
        context.setTemporaryOutputState(206);
        Sequence result = ExpressionTool.evaluate(this.getSequence(), this.evaluationMode, context, this.refCount);
        context.setTemporaryOutputState(savedOutputState);
        return result;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        return let.getAction().evaluateItem(context);
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        return let.getAction().effectiveBooleanValue(context);
    }

    public void process(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        let.getAction().process(context);
    }

    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    public int computeCardinality() {
        return this.getAction().getCardinality();
    }

    public int computeSpecialProperties() {
        int props = this.getAction().getSpecialProperties();
        int seqProps = this.getSequence().getSpecialProperties();
        if ((seqProps & 0x400000) == 0) {
            props &= 0xFFBFFFFF;
        }
        return props;
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        return ExpressionTool.markTailFunctionCalls(this.getAction(), qName, arity);
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Binding b;
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        Expression seq2 = this.doPromotion(this.getSequence(), offer);
        if (seq2 != this.getSequence()) {
            if (seq2 instanceof VariableReference && (b = ((VariableReference)seq2).getBinding()) instanceof GlobalVariable && this.refCount == 10000) {
                ((GlobalVariable)b).setIndexedVariable();
            }
            this.setSequence(seq2);
        }
        if (offer.action == 14) {
            this.setAction(this.doPromotion(this.getAction(), offer));
        } else if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            offer.bindingList = this.extendBindingList(offer.bindingList);
            this.setAction(this.doPromotion(this.getAction(), offer));
            offer.bindingList = savedBindingList;
        }
        if (this.getSequence() instanceof VariableReference && (b = ((VariableReference)this.getSequence()).getBinding()) != null && !b.isAssignable()) {
            this.replaceVariable(this.getSequence());
            if (ExpressionTool.dependsOnVariable(this.getAction(), new Binding[]{this})) {
                offer.getOptimizer().trace("Failed to eliminate redundant variable $" + this.getVariableName(), this);
            } else {
                return this.getAction();
            }
        }
        return this;
    }

    public Expression copy() {
        LetExpression let = new LetExpression();
        ExpressionTool.copyLocationInfo(this, let);
        let.refCount = this.refCount;
        let.setVariableQName(this.variableName);
        let.setRequiredType(this.requiredType);
        let.setSequence(this.getSequence().copy());
        Expression newAction = this.getAction().copy();
        let.setAction(newAction);
        ExpressionTool.rebindVariableReferences(newAction, this, let);
        return let;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        if (let.getAction() instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)let.getAction())).processLeavingTail(context);
        }
        let.getAction().process(context);
        return null;
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        LetExpression let = this;
        while (true) {
            Sequence val = let.eval(context);
            context.setLocalVariable(let.getLocalSlotNumber(), val);
            if (!(let.getAction() instanceof LetExpression)) break;
            let = (LetExpression)let.getAction();
        }
        let.getAction().evaluatePendingUpdates(context, pul);
    }

    public String toString() {
        return "let $" + this.getVariableEQName() + " := " + this.getSequence().toString() + " return " + ExpressionTool.parenthesize(this.getAction());
    }

    public String toShortString() {
        return "let $" + this.getVariableName() + " := ...";
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("let", this);
        out.emitAttribute("var", this.variableName);
        out.emitAttribute("as", this.getSequence().getItemType().toString() + Cardinality.getOccurrenceIndicator(this.getSequence().getCardinality()));
        if (this.isIndexedVariable()) {
            out.emitAttribute("indexable", "true");
        }
        out.emitAttribute("slot", this.getLocalSlotNumber() + "");
        out.emitAttribute("eval", this.getEvaluationMode() + "");
        this.getSequence().export(out);
        this.getAction().export(out);
        out.endElement();
    }

    public void setEvaluationMode(int evaluationMode) {
        this.evaluationMode = evaluationMode;
    }

    public int getEvaluationMode() {
        return this.evaluationMode;
    }
}

