/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root_1;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.IntegerValue;

public class SystemFunctionCall
extends StaticFunctionCall
implements Negatable {
    public SystemFunctionCall(SystemFunction target, Expression[] arguments) {
        super(target, arguments);
    }

    public void setRetainedStaticContext(RetainedStaticContext rsc) {
        super.setRetainedStaticContext(rsc);
        this.getTargetFunction().setRetainedStaticContext(rsc);
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        SystemFunction target = this.getTargetFunction();
        if ((target.getDetails().properties & 0x200) == 0) {
            return super.preEvaluate(visitor);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        this.checkFunctionCall(this.getTargetFunction(), visitor);
        this.getTargetFunction().supplyTypeInformation(visitor, contextInfo, this.getArguments());
        if ((this.getTargetFunction().getDetails().properties & 0x200) == 0) {
            return this.preEvaluateIfConstant(visitor);
        }
        return this;
    }

    public SystemFunction getTargetFunction() {
        return (SystemFunction)super.getTargetFunction();
    }

    public int getIntrinsicDependencies() {
        int properties = this.getTargetFunction().getDetails().properties;
        if ((properties & 0x1804) != 0) {
            int dep = 0;
            if ((properties & 4) != 0) {
                dep |= 2;
            }
            if ((properties & 0x800) != 0) {
                dep |= 4;
            }
            if ((properties & 0x1000) != 0) {
                dep |= 8;
            }
            return dep;
        }
        if (this.isCallOn(RegexGroup.class)) {
            return 32;
        }
        if (this.isCallOnSystemFunction("current-merge-group")) {
            return 32;
        }
        if (this.isCallOnSystemFunction("current-merge-key")) {
            return 32;
        }
        return 0;
    }

    protected int computeCardinality() {
        return this.getTargetFunction().getCardinality(this.getArguments());
    }

    protected int computeSpecialProperties() {
        return this.getTargetFunction().getSpecialProperties(this.getArguments());
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression sfo;
        Expression sf = super.optimize(visitor, contextInfo);
        if (sf == this && (sfo = this.getTargetFunction().makeOptimizedFunctionCall(visitor, contextInfo, this.getArguments())) != null) {
            sfo.setParentExpression(this.getParentExpression());
            ExpressionTool.copyLocationInfo(this, sfo);
            return sfo;
        }
        if (sf instanceof SystemFunctionCall) {
            StandardFunction.Entry details = ((SystemFunctionCall)sf).getTargetFunction().getDetails();
            if ((details.properties & 0x400) != 0) {
                this.setArg(0, this.getArg(0).unordered(true, visitor.isOptimizeForStreaming()));
            }
            if (this.getArity() <= details.resultIfEmpty.length) {
                for (int i = 0; i < this.getArity(); ++i) {
                    if (!Literal.isEmptySequence(this.getArg(i)) || details.resultIfEmpty[i] == null) continue;
                    return Literal.makeLiteral(SequenceTool.toGroundedValue(details.resultIfEmpty[i]));
                }
            }
        }
        return sf;
    }

    public boolean isVacuousExpression() {
        return this.isCallOn(Error.class);
    }

    public ItemType getItemType() {
        return this.getTargetFunction().getResultItemType(this.getArguments());
    }

    public Expression copy() {
        Expression[] args = new Expression[this.getArity()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.getArg(i).copy();
        }
        return new SystemFunctionCall(this.getTargetFunction(), args);
    }

    public IntegerValue[] getIntegerBounds() {
        SystemFunction fn = this.getTargetFunction();
        if ((fn.getDetails().properties & 0x100) != 0) {
            return this.getArg(0).getIntegerBounds();
        }
        return fn.getIntegerBounds();
    }

    public boolean isNegatable(TypeHierarchy th) {
        return this.isCallOn(NotFn.class) || this.isCallOn(BooleanFn.class) || this.isCallOn(Empty.class) || this.isCallOn(Exists.class);
    }

    public Expression negate() {
        SystemFunction fn = this.getTargetFunction();
        if (fn instanceof NotFn) {
            Expression arg = this.getArg(0);
            if (arg.getItemType() == BuiltInAtomicType.BOOLEAN && arg.getCardinality() == 16384) {
                return arg;
            }
            return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), arg);
        }
        if (fn instanceof BooleanFn) {
            return SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getArg(0));
        }
        if (fn instanceof Exists) {
            return SystemFunction.makeCall("empty", this.getRetainedStaticContext(), this.getArg(0));
        }
        if (fn instanceof Empty) {
            return SystemFunction.makeCall("exists", this.getRetainedStaticContext(), this.getArg(0));
        }
        throw new UnsupportedOperationException();
    }

    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        SystemFunction fn = this.getTargetFunction();
        if (fn instanceof Reverse) {
            return this.getArg(0);
        }
        if (fn instanceof TreatFn) {
            this.setArg(0, this.getArg(0).unordered(retainAllNodes, forStreaming));
        }
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (this.isCallOn(Doc.class) || this.isCallOn(DocumentFn.class) || this.isCallOn(CollectionFn.class)) {
            this.getArg(0).addToPathMap(pathMap, pathMapNodeSet);
            return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
        }
        return super.addToPathMap(pathMap, pathMapNodeSet);
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        SystemFunction fn = this.getTargetFunction();
        if (fn instanceof Root_1 && is30 && (this.getArg(0) instanceof ContextItemExpression || this.getArg(0) instanceof ItemChecker && ((ItemChecker)this.getArg(0)).getBaseExpression() instanceof ContextItemExpression)) {
            return new NodeSetPattern(this);
        }
        return super.toPattern(config, is30);
    }

    public Sequence[] evaluateArguments(XPathContext context) throws XPathException {
        OperandArray operanda = this.getOperanda();
        int numArgs = operanda.getNumberOfOperands();
        Sequence[] actualArgs = new Sequence[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            actualArgs[i] = new LazySequence(operanda.getOperandExpression(i).iterate(context));
        }
        return actualArgs;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("fn", this);
        out.emitAttribute("name", this.getFunctionName().getDisplayName());
        this.getTargetFunction().exportAttributes(out);
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        out.endElement();
    }
}

