/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class CurrentGroupCall
extends Expression
implements Callable {
    private boolean isInLoop = false;
    private ItemType itemType = AnyItemType.getInstance();
    private ForEachGroup controllingInstruction = null;

    public void setControllingInstruction(ForEachGroup instruction, ItemType itemType, boolean isInLoop) {
        this.controllingInstruction = instruction;
        this.isInLoop = isInLoop;
        this.itemType = itemType;
        this.resetLocalStaticProperties();
    }

    public ForEachGroup getControllingInstruction() {
        if (this.controllingInstruction == null) {
            Expression parent;
            Expression child = this;
            for (parent = this.getParentExpression(); !(parent == null || parent instanceof ForEachGroup && child == ((ForEachGroup)parent).getActionExpression()); parent = parent.getParentExpression()) {
                child = parent;
            }
            this.controllingInstruction = (ForEachGroup)parent;
        }
        return this.controllingInstruction;
    }

    public boolean isInLoop() {
        return this.isInLoop;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public int getIntrinsicDependencies() {
        return 32;
    }

    protected int computeCardinality() {
        return 49152;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("currentGroup");
        out.endElement();
    }

    public int computeSpecialProperties() {
        if (this.getControllingInstruction() == null) {
            return 0;
        }
        return this.controllingInstruction.getSelectExpression().getSpecialProperties();
    }

    public Expression copy() {
        CurrentGroupCall cg = new CurrentGroupCall();
        cg.isInLoop = this.isInLoop;
        cg.itemType = this.itemType;
        cg.controllingInstruction = this.controllingInstruction;
        return cg;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        GroupIterator gi = c.getCurrentGroupIterator();
        if (gi == null || !gi.hasCurrentGroup()) {
            if (this.getRetainedStaticContext().getXPathVersion() >= 30) {
                XPathException err = new XPathException("There is no current group", "XTDE1061");
                err.setLocation(this.getLocation());
                throw err;
            }
            return EmptyIterator.emptyIterator();
        }
        return gi.iterateCurrentGroup();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.iterate(context));
    }

    public String toString() {
        return "current-group()";
    }

    public String toShortString() {
        return this.toString();
    }
}

