/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public final class SimplePositionalPattern
extends Pattern {
    private NodeTest nodeTest;
    private int position;

    public SimplePositionalPattern(NodeTest nodeTest, int position) {
        this.nodeTest = nodeTest;
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    public boolean matches(Item item, XPathContext context) throws XPathException {
        return item instanceof NodeInfo && this.matchesBeneathAnchor((NodeInfo)item, null, context);
    }

    public UType getUType() {
        return this.nodeTest.getUType();
    }

    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public ItemType getItemType() {
        return this.nodeTest.getPrimitiveItemType();
    }

    public boolean equals(Object other) {
        if (other instanceof SimplePositionalPattern) {
            SimplePositionalPattern fp = (SimplePositionalPattern)other;
            return this.nodeTest.equals(fp.nodeTest) && this.position == fp.position;
        }
        return false;
    }

    public int hashCode() {
        return this.nodeTest.hashCode() ^ this.position << 3;
    }

    public boolean isMotionless(boolean allowExtensions) {
        return false;
    }

    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (!this.nodeTest.matchesNode(node)) {
            return false;
        }
        if (anchor != null && node.getParent() != anchor) {
            return false;
        }
        return this.position == Navigator.getSiblingPosition(node, this.nodeTest, this.position);
    }

    public Pattern copy() {
        SimplePositionalPattern n = new SimplePositionalPattern(this.nodeTest.copy(), this.position);
        ExpressionTool.copyLocationInfo(this, n);
        return n;
    }

    public String toString() {
        return this.nodeTest.toString() + "[" + this.position + "]";
    }

    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("p.simPos");
        presenter.emitAttribute("test", this.nodeTest.toString());
        if ("JS".equals(presenter.getOption("target"))) {
            presenter.emitAttribute("jsTest", this.nodeTest.generateJavaScriptItemTypeTest(AnyItemType.getInstance()));
        }
        presenter.emitAttribute("pos", this.position + "");
        presenter.endElement();
    }
}

