/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.MessageListener2;
import net.sf.saxon.s9api.MessageListener2Proxy;
import net.sf.saxon.s9api.MessageListenerProxy;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.ReconfigurableSerializer;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xslt30Transformer {
    private Processor processor;
    private Controller controller;
    private GlobalParameterSet globalParameterSet;
    private boolean primed = false;
    private boolean baseOutputUriWasSet = false;
    private Item globalContextItem = null;
    private boolean alreadyStripped;

    protected Xslt30Transformer(Processor processor, Controller controller, GlobalParameterSet staticParameters) {
        this.processor = processor;
        this.controller = controller;
        this.globalParameterSet = new GlobalParameterSet(staticParameters);
    }

    public void setSchemaValidationMode(ValidationMode mode) {
        if (mode != null) {
            this.controller.setSchemaValidationMode(mode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get(this.controller.getSchemaValidationMode());
    }

    public void setGlobalContextItem(XdmItem globalContextItem) throws SaxonApiException {
        this.setGlobalContextItem(globalContextItem, false);
    }

    public void setGlobalContextItem(XdmItem globalContextItem, boolean alreadyStripped) throws SaxonApiException {
        if (this.primed) {
            throw new IllegalStateException("Stylesheet has already been evaluated");
        }
        this.globalContextItem = globalContextItem == null ? null : globalContextItem.getUnderlyingValue();
        this.alreadyStripped = alreadyStripped;
    }

    public void setInitialContextNode(XdmNode node) {
        if (this.primed) {
            throw new IllegalStateException("Stylesheet has already been evaluated");
        }
        this.globalContextItem = node.getUnderlyingNode();
    }

    public void setInitialContextItem(XdmItem item) {
        if (this.primed) {
            throw new IllegalStateException("Stylesheet has already been evaluated");
        }
        this.globalContextItem = item.getUnderlyingValue();
    }

    public void setStylesheetParameters(Map<QName, XdmValue> parameters) throws SaxonApiException {
        if (this.primed) {
            throw new IllegalStateException("Stylesheet has already been evaluated");
        }
        if (this.globalParameterSet == null) {
            this.globalParameterSet = new GlobalParameterSet();
        }
        for (Map.Entry<QName, XdmValue> param : parameters.entrySet()) {
            this.globalParameterSet.put(param.getKey().getStructuredQName(), param.getValue().getUnderlyingValue());
        }
    }

    private void prime() throws SaxonApiException {
        if (!this.primed) {
            if (this.globalParameterSet == null) {
                this.globalParameterSet = new GlobalParameterSet();
            }
            this.controller.setGlobalContextItem(this.globalContextItem, this.alreadyStripped);
            try {
                this.controller.initializeController(this.globalParameterSet);
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }
        this.primed = true;
    }

    public void setBaseOutputURI(String uri) {
        this.controller.setBaseOutputURI(uri);
        this.baseOutputUriWasSet = uri != null;
    }

    public String getBaseOutputURI() {
        return this.controller.getBaseOutputURI();
    }

    public void setURIResolver(URIResolver resolver) {
        this.controller.setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.controller.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.controller.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        UnfailingErrorListener uel = this.controller.getErrorListener();
        if (uel instanceof DelegatingErrorListener) {
            return ((DelegatingErrorListener)uel).getBaseErrorListener();
        }
        return uel;
    }

    public void setMessageListener(MessageListener listener) {
        this.controller.setMessageEmitter(new MessageListenerProxy(listener, this.controller.makePipelineConfiguration()));
    }

    public void setMessageListener(MessageListener2 listener) {
        this.controller.setMessageEmitter(new MessageListener2Proxy(listener, this.controller.makePipelineConfiguration()));
    }

    public MessageListener getMessageListener() {
        Receiver r = this.controller.getMessageEmitter();
        if (r instanceof MessageListenerProxy) {
            return ((MessageListenerProxy)r).getMessageListener();
        }
        return null;
    }

    public boolean isAssertionsEnabled() {
        return this.controller.isAssertionsEnabled();
    }

    public void setAssertionsEnabled(boolean enabled) {
        this.controller.setAssertionsEnabled(enabled);
    }

    public void setTraceListener(TraceListener listener) {
        this.controller.setTraceListener(listener);
    }

    public TraceListener getTraceListener() {
        return this.controller.getTraceListener();
    }

    public void setTraceFunctionDestination(Logger stream) {
        this.controller.setTraceFunctionDestination(stream);
    }

    public Logger getTraceFunctionDestination() {
        return this.controller.getTraceFunctionDestination();
    }

    public void setInitialTemplateParameters(Map<QName, XdmValue> parameters, boolean tunnel) throws SaxonApiException {
        HashMap<StructuredQName, Sequence> templateParams = new HashMap<StructuredQName, Sequence>();
        for (Map.Entry<QName, XdmValue> entry : parameters.entrySet()) {
            templateParams.put(entry.getKey().getStructuredQName(), entry.getValue().getUnderlyingValue());
        }
        this.controller.setInitialTemplateParameters(templateParams, tunnel);
    }

    public void setInitialMode(QName modeName) throws IllegalArgumentException {
        try {
            this.controller.setInitialMode(modeName == null ? null : modeName.getStructuredQName());
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public QName getInitialMode() {
        Mode mode = this.controller.getInitialMode();
        if (mode == null) {
            return null;
        }
        return new QName(mode.getModeName());
    }

    public void applyTemplates(Source source, Destination destination) throws SaxonApiException {
        this.prime();
        try {
            Receiver out = this.getDestinationReceiver(destination);
            this.controller.transform(source, out);
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    public XdmValue applyTemplates(Source source) throws SaxonApiException {
        this.prime();
        try {
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            SequenceOutputter out = new SequenceOutputter(pipe, 1);
            this.controller.setBuildTree(false);
            this.controller.transform(source, out);
            Sequence result = out.getSequence();
            return XdmValue.wrap(result);
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    public void applyTemplates(XdmValue selection, Destination destination) throws SaxonApiException {
        this.prime();
        try {
            Receiver out = this.getDestinationReceiver(destination);
            if (this.baseOutputUriWasSet) {
                out.setSystemId(this.controller.getBaseOutputURI());
            }
            this.setBuildTreeConditionally(destination);
            this.controller.applyTemplates(selection.getUnderlyingValue(), out);
            destination.close();
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    public XdmValue applyTemplates(XdmValue selection) throws SaxonApiException {
        this.prime();
        try {
            this.controller.setBuildTree(false);
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            SequenceOutputter out = new SequenceOutputter(pipe, 1);
            this.controller.applyTemplates(selection.getUnderlyingValue(), out);
            Sequence result = out.getSequence();
            return XdmValue.wrap(result);
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    public void callTemplate(QName templateName, Destination destination) throws SaxonApiException {
        this.prime();
        if (templateName == null) {
            templateName = new QName("xsl", "http://www.w3.org/1999/XSL/Transform", "initial-template");
        }
        try {
            Receiver out = this.getDestinationReceiver(destination);
            if (this.baseOutputUriWasSet) {
                out.setSystemId(this.controller.getBaseOutputURI());
            }
            this.setBuildTreeConditionally(destination);
            this.controller.callTemplate(templateName.getStructuredQName(), out);
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    private void setBuildTreeConditionally(Destination destination) {
        if (destination instanceof Serializer) {
            String method = ((Serializer)destination).getOutputProperty(Serializer.Property.METHOD);
            if (method == null) {
                method = this.controller.getExecutable().getDefaultOutputProperties().getProperty("method");
            }
            if ("json".equals(method) || "adaptive".equals(method)) {
                this.controller.setBuildTree(false);
            }
        }
    }

    public XdmValue callTemplate(QName templateName) throws SaxonApiException {
        this.prime();
        if (templateName == null) {
            templateName = new QName("xsl", "http://www.w3.org/1999/XSL/Transform", "initial-template");
        }
        try {
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            SequenceOutputter out = new SequenceOutputter(pipe, 1);
            this.controller.setBuildTree(false);
            this.controller.callTemplate(templateName.getStructuredQName(), out);
            Sequence result = out.getSequence();
            return XdmValue.wrap(result);
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    public XdmValue callFunction(QName function, XdmValue[] arguments) throws SaxonApiException {
        this.prime();
        try {
            Component f = this.getFunctionComponent(function, arguments);
            UserFunction uf = (UserFunction)f.getActor();
            Sequence[] vr = this.typeCheckFunctionArguments(uf, arguments);
            XPathContextMajor context = this.controller.newXPathContext();
            context.setCurrentComponent(f);
            context.setTemporaryOutputState(158);
            Sequence result = uf.call(context, vr);
            result = SequenceTool.toGroundedValue(result);
            return XdmValue.wrap(result);
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
    }

    @NotNull
    private Component getFunctionComponent(QName function, XdmValue[] arguments) throws XPathException {
        SymbolicName.F fName = new SymbolicName.F(function.getStructuredQName(), arguments.length);
        PreparedStylesheet pss = (PreparedStylesheet)this.controller.getExecutable();
        Component f = pss.getComponent(fName);
        if (f == null) {
            throw new XPathException("No public function with name " + function.getClarkName() + " and arity " + arguments.length + " has been declared in the stylesheet", "XTDE0041");
        }
        if (f.getVisibility() != Visibility.FINAL && f.getVisibility() != Visibility.PUBLIC) {
            throw new XPathException("Cannot invoke " + fName + " externally, because it is not public", "XTDE0041");
        }
        return f;
    }

    @NotNull
    private Sequence[] typeCheckFunctionArguments(UserFunction uf, XdmValue[] arguments) throws XPathException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        UserFunctionParameter[] params = uf.getParameterDefinitions();
        Sequence[] vr = new Sequence[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            SequenceType type = params[i].getRequiredType();
            vr[i] = arguments[i].getUnderlyingValue();
            if (type.matches(vr[i], config.getTypeHierarchy())) continue;
            RoleDiagnostic role = new RoleDiagnostic(0, uf.getFunctionName().getDisplayName(), i);
            vr[i] = config.getTypeHierarchy().applyFunctionConversionRules(vr[i], type, role, ExplicitLocation.UNKNOWN_LOCATION);
        }
        return vr;
    }

    public void callFunction(QName function, XdmValue[] arguments, Destination destination) throws SaxonApiException {
        this.prime();
        try {
            Component f = this.getFunctionComponent(function, arguments);
            UserFunction uf = (UserFunction)f.getActor();
            Sequence[] vr = this.typeCheckFunctionArguments(uf, arguments);
            XPathContextMajor context = this.controller.newXPathContext();
            context.setCurrentComponent(f);
            context.setTemporaryOutputState(158);
            if (destination instanceof Serializer) {
                Serializer serializer = (Serializer)destination;
                serializer.setDefaultOutputProperties(this.controller.getExecutable().getDefaultOutputProperties());
                serializer.setCharacterMap(this.controller.getExecutable().getCharacterMapIndex());
            }
            Receiver receiver = destination.getReceiver(this.controller.getConfiguration());
            receiver.open();
            if (!(receiver instanceof SequenceReceiver)) {
                receiver = new TreeReceiver(receiver);
            }
            context.setReceiver((SequenceReceiver)receiver);
            uf.process(vr, context);
            receiver.close();
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException(e);
        }
        destination.close();
    }

    public Serializer newSerializer() {
        Serializer serializer = this.processor.newSerializer();
        serializer.setDefaultOutputProperties(this.controller.getExecutable().getDefaultOutputProperties());
        serializer.setCharacterMap(this.controller.getExecutable().getCharacterMapIndex());
        return serializer;
    }

    public Serializer newSerializer(File file) {
        Serializer serializer = this.processor.newSerializer(file);
        serializer.setDefaultOutputProperties(this.controller.getExecutable().getDefaultOutputProperties());
        serializer.setCharacterMap(this.controller.getExecutable().getCharacterMapIndex());
        this.setBaseOutputURI(file.toURI().toString());
        return serializer;
    }

    public Serializer newSerializer(Writer writer) {
        Serializer serializer = this.newSerializer();
        serializer.setOutputWriter(writer);
        return serializer;
    }

    public Serializer newSerializer(OutputStream stream) {
        Serializer serializer = this.newSerializer();
        serializer.setOutputStream(stream);
        return serializer;
    }

    private Receiver getDestinationReceiver(Destination destination) throws SaxonApiException {
        if (destination instanceof Serializer) {
            Serializer serializer = (Serializer)destination;
            serializer.setDefaultOutputProperties(this.controller.getExecutable().getDefaultOutputProperties());
            serializer.setCharacterMap(this.controller.getExecutable().getCharacterMapIndex());
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            Receiver r = serializer.getReceiver(pipe);
            return new ReconfigurableSerializer(r, serializer.getLocalOutputProperties(), serializer.getResult());
        }
        Receiver r = destination.getReceiver(this.controller.getConfiguration());
        PipelineConfiguration pipe = r.getPipelineConfiguration();
        pipe.setController(this.controller);
        return r;
    }

    public Controller getUnderlyingController() {
        return this.controller;
    }
}

